/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.core.helpers;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.IArtifactMetaModelAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.handlers.PriorityHandler;
import org.eclipse.capra.core.helpers.EMFHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ArtifactHelper {
    private static final String QUOTE_CHARACTERS = "[\"']";
    private static final String NEWLINE_CHARACTERS = "[\r\n]+";
    private EObject artifactModel;
    private static Optional<PriorityHandler> priorityHandler = ExtensionPointHelper.getPriorityHandler();
    private static Collection<? extends IArtifactHandler<?>> handlers = ExtensionPointHelper.getArtifactHandlers();

    private String sanitize(String input) {
        return input.replaceAll(QUOTE_CHARACTERS, " ").replaceAll(NEWLINE_CHARACTERS, " ");
    }

    public ArtifactHelper(EObject artifactModel) {
        this.artifactModel = artifactModel;
    }

    public List<EObject> createWrappers(List<?> artifacts) {
        return artifacts.stream().map(vagueArtifact -> this.getHandler(vagueArtifact).map(h -> h.withCastedHandlerUnchecked(vagueArtifact, (handler, artifact) -> handler.createWrapper(artifact, this.artifactModel)))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public EObject createWrapper(Object vagueArtifact) {
        Optional<EObject> wrapped = this.getHandler(vagueArtifact).map(vagueHandler -> vagueHandler.withCastedHandlerUnchecked(vagueArtifact, (handler, artifact) -> handler.createWrapper(artifact, this.artifactModel)));
        return wrapped.orElse(null);
    }

    public Object unwrapWrapper(Object wrapper) {
        if (wrapper instanceof EObject) {
            IArtifactMetaModelAdapter artifactMetaModelAdapter = ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();
            IArtifactHandler<?> handler = artifactMetaModelAdapter.getArtifactHandlerInstance((EObject)wrapper);
            if (handler != null && handler.resolveWrapper((EObject)wrapper) != null) {
                return handler.resolveWrapper((EObject)wrapper);
            }
            return wrapper;
        }
        return wrapper;
    }

    public <T> Optional<IArtifactHandler<?>> getHandler(T artifact) {
        List availableHandlers = handlers.stream().filter(h -> h.canHandleArtifact(artifact)).collect(Collectors.toList());
        if (availableHandlers.isEmpty()) {
            return Optional.empty();
        }
        if (availableHandlers.size() == 1) {
            return Optional.of((IArtifactHandler)availableHandlers.get(0));
        }
        return priorityHandler.map(h -> h.getSelectedHandler(availableHandlers, artifact));
    }

    public String getArtifactLabel(EObject object) {
        String artifactLabel = null;
        Object originalObject = this.unwrapWrapper(object);
        if (originalObject != null) {
            IArtifactHandler<?> handler = this.getHandler(originalObject).orElseThrow();
            artifactLabel = handler.withCastedHandler(originalObject, (h, o) -> h.getDisplayName(o)).orElseThrow(IllegalArgumentException::new);
        } else {
            String label = EMFHelper.getIdentifier(object);
            if (label.indexOf(58) > 0) {
                artifactLabel = label.substring(0, label.indexOf(58));
            }
        }
        if (artifactLabel != null) {
            return this.sanitize(artifactLabel);
        }
        return "Unknown (no fitting artifact handler found)";
    }

    public String getArtifactLocation(EObject object) {
        String artifactLink = null;
        IArtifactMetaModelAdapter adapter = ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();
        artifactLink = adapter.getArtifactUri(object);
        if (artifactLink == null) {
            try {
                artifactLink = EcoreUtil.getURI((EObject)object).toPlatformString(false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (artifactLink != null && !artifactLink.isEmpty() && artifactLink.startsWith("/")) {
            artifactLink = "platform:/resource" + artifactLink;
        }
        return artifactLink;
    }

    public void deleteArtifact(final EObject artifactToDelete) throws IllegalStateException {
        TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain, "Delete artifact"){

            protected void doExecute() {
                EcoreUtil.delete((EObject)artifactToDelete);
            }
        };
        try {
            ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
        }
        catch (RollbackException e) {
            throw new IllegalStateException("Deleting an artifact was rolled back.", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Deleting an artifact was interrupted.", e);
        }
    }
}

