/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.importer.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.polarsys.capella.vp.requirements.importer.extension.AttributeSet;
import org.polarsys.capella.vp.requirements.importer.extension.ReqImporterPreferencesUtil;

public class ImportPreferencesModel {
    private final List<URI> propertiesFiles = new ArrayList<URI>(ReqImporterPreferencesUtil.getPropertyFilesFromPreferences());
    private final List<AttributeSet> categories = new ArrayList<AttributeSet>();

    public ImportPreferencesModel() {
        this.categories.addAll(ReqImporterPreferencesUtil.loadContributedCategories());
        this.categories.addAll(ReqImporterPreferencesUtil.loadPropertiesFileAttributes(this.propertiesFiles));
    }

    public void addPropertyFiles(List<URI> newPropertyFileURIs) {
        this.categories.addAll(ReqImporterPreferencesUtil.loadPropertiesFileAttributes(newPropertyFileURIs));
        this.propertiesFiles.addAll(newPropertyFileURIs);
    }

    public Collection<String> getSelectedAttributeTypes() {
        Collection<String> allAttributesName = this.getAttributeTypes();
        for (AttributeSet attribute : this.getAttributes()) {
            if (attribute.isMandatory() || attribute.isSelected()) continue;
            allAttributesName.remove(attribute.getName());
        }
        return allAttributesName;
    }

    public List<AttributeSet> getAttributes() {
        ArrayList<AttributeSet> result = new ArrayList<AttributeSet>();
        for (AttributeSet category : this.getCategories()) {
            result.addAll(category.getChildren());
        }
        return result;
    }

    public Collection<String> getAttributeTypes() {
        HashSet<String> result = new HashSet<String>();
        for (AttributeSet attribute : this.getAttributes()) {
            result.add(attribute.getName());
        }
        return result;
    }

    public List<AttributeSet> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public List<URI> getPropertiesFiles() {
        return Collections.unmodifiableList(this.propertiesFiles);
    }

    public void removePropertyFile(URI oldPropertyFileURI) {
        Iterator<AttributeSet> it = this.categories.iterator();
        while (it.hasNext()) {
            AttributeSet as = it.next();
            if (!as.getName().equals(oldPropertyFileURI.lastSegment())) continue;
            it.remove();
        }
        this.propertiesFiles.remove(oldPropertyFileURI);
    }

    public void resetToDefaultSelection() {
        for (AttributeSet category : this.categories) {
            for (AttributeSet att : category.getChildren()) {
                att.setSelected(att.defaultValue() || att.isMandatory());
            }
        }
    }

    public void selectAll(boolean selected) {
        for (AttributeSet category : this.categories) {
            for (AttributeSet att : category.getChildren()) {
                att.setSelected(selected || att.isMandatory());
            }
        }
    }
}

