/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import java.math.BigInteger;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.TextObjectEditor;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class FloatObjectEditor
extends TextObjectEditor {
    public FloatObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
    }

    @Override
    protected Control createControl(Composite composite, String label, int style) {
        this.createLabel(composite, label);
        this.text = this.getToolkit().createText(composite, "");
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if (('0' > chars[i] || chars[i] > '9') && chars[i] != '.') {
                        e.doit = false;
                        FloatObjectEditor.this.showErrorMessage(NLS.bind((String)Messages.FloatObjectEditor_Invalid_Character, (Object)e.text));
                        return;
                    }
                    ++i;
                }
            }
        });
        this.updateText();
        ISWTObservableValue textObserveTextObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.text);
        textObserveTextObserveWidget.addValueChangeListener((IValueChangeListener)new IValueChangeListener<String>(){

            public void handleValueChange(ValueChangeEvent<? extends String> event) {
                try {
                    Double i = Double.parseDouble(FloatObjectEditor.this.text.getText());
                    if (!FloatObjectEditor.this.getValue().equals(i)) {
                        this.setFeatureValue(i);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setFeatureValue(0.0);
                }
            }

            private void setFeatureValue(double i) {
                FloatObjectEditor.this.getBusinessObjectDelegate().setValue(FloatObjectEditor.this.object, FloatObjectEditor.this.feature, Double.toString(i));
            }
        });
        return this.text;
    }

    @Override
    public Double getValue() {
        Object v = this.getBusinessObjectDelegate().getValue(this.object, this.feature);
        if (v instanceof Short) {
            return ((Short)v).doubleValue();
        }
        if (v instanceof Integer) {
            return ((Integer)v).doubleValue();
        }
        if (v instanceof Long) {
            return ((Long)v).doubleValue();
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        if (v instanceof BigInteger) {
            return ((BigInteger)v).doubleValue();
        }
        if (v instanceof String) {
            try {
                return Double.parseDouble((String)v);
            }
            catch (Exception exception) {}
        }
        return 0.0;
    }
}

