/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.tests;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.acute.tests.AbstractAcuteTest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Test;

public class TestLSPIntegration
extends AbstractAcuteTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        LanguageServerPlugin.getDefault().getPreferenceStore().putValue("org.eclipse.acute.Omnisharp.file.logging.enabled", Boolean.toString(true));
    }

    @Test
    public void testLSFoundWithCSProj() throws Exception {
        IProject project = this.getProject("csproj");
        IFile csharpSourceFile = project.getFile("Program.cs");
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)csharpSourceFile);
        SourceViewer viewer = (SourceViewer)TestLSPIntegration.getTextViewer(editor);
        this.workaroundOmniSharpIssue1088(viewer.getDocument());
        int offset = viewer.getDocument().get().indexOf("WriteLine") + 6;
        viewer.setSelectedRange(offset, 0);
        final AtomicReference topProposal = new AtomicReference();
        viewer.getContentAssistantFacade().addCompletionListener(new ICompletionListener(){

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
                topProposal.set(proposal);
            }

            public void assistSessionStarted(ContentAssistEvent event) {
            }

            public void assistSessionEnded(ContentAssistEvent event) {
            }
        });
        viewer.doOperation(13);
        Assert.assertTrue((boolean)new DisplayHelper(){

            protected boolean condition() {
                ICompletionProposal proposal = (ICompletionProposal)topProposal.get();
                return proposal != null && proposal.getDisplayString().contains("WriteLine");
            }
        }.waitForCondition(viewer.getTextWidget().getDisplay(), 5000L));
    }

    private void workaroundOmniSharpIssue1088(final IDocument document) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        final Method getDocumentListenersMethod = AbstractDocument.class.getDeclaredMethod("getDocumentListeners", new Class[0]);
        getDocumentListenersMethod.setAccessible(true);
        new DisplayHelper(){

            protected boolean condition() {
                try {
                    return ((Collection)getDocumentListenersMethod.invoke((Object)document, new Object[0])).stream().anyMatch(o -> o.getClass().getName().contains("lsp4e"));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 5000L);
        Assert.assertNotEquals((String)"LS Document listener was not setup after 5s", Collections.emptyList(), (Object)getDocumentListenersMethod.invoke((Object)document, new Object[0]));
        DisplayHelper.sleep((long)5000L);
        document.set(document.get().replace("Hello", "Kikoo"));
        DisplayHelper.sleep((long)500L);
    }

    @Test
    public void testLSFindsDiagnosticsCSProj() throws Exception {
        IProject project = this.getProject("csprojWithError");
        final IFile csharpSourceFile = project.getFile("Program.cs");
        IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)csharpSourceFile);
        SourceViewer viewer = (SourceViewer)TestLSPIntegration.getTextViewer(editor);
        this.workaroundOmniSharpIssue1088(viewer.getDocument());
        new DisplayHelper(){

            protected boolean condition() {
                try {
                    return csharpSourceFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 0).length > 0;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }.waitForCondition(Display.getDefault(), 5000L);
        DisplayHelper.sleep((long)500L);
        IMarker marker = csharpSourceFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 0)[0];
        Assert.assertTrue((boolean)marker.getType().contains("lsp4e"));
        Assert.assertEquals((long)12L, (long)marker.getAttribute("lineNumber", -1));
    }
}

