/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.SWTBotTests.dotnettest;

import org.eclipse.acute.SWTBotTests.AbstractDotnetTest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.junit.Assert;
import org.junit.Test;

public class TestRun
extends AbstractDotnetTest {
    @Override
    public void setup() throws CoreException {
        super.buildEmptyProject();
        this.csprojFile = this.project.getFile("Project2.Tests.csproj");
        this.csprojFile.create(this.getClass().getResourceAsStream(this.csprojFile.getName()), true, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testDotnetRunSuccessful() throws CoreException {
        int exitCode = this.runTest("ProjectTestsPass.cs");
        Assert.assertTrue((String)("Test's exit code was incorrect; expected: 0, actual: " + exitCode), (exitCode == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDotnetRunFailure() throws CoreException {
        int exitCode = this.runTest("ProjectTestsFail.cs");
        Assert.assertTrue((String)("Test's exit code was incorrect; expected: 1, actual: " + exitCode), (exitCode == 1 ? 1 : 0) != 0);
    }

    private int runTest(String csharpSourceFileName) throws CoreException {
        this.csharpSourceFile = this.project.getFile(csharpSourceFileName);
        this.csharpSourceFile.create(this.getClass().getResourceAsStream(this.csharpSourceFile.getName()), true, (IProgressMonitor)new NullProgressMonitor());
        SWTBotView packageExplorer = bot.viewByTitle("Project Explorer");
        SWTBotTree explorerTree = new SWTBot(packageExplorer.getWidget()).tree(0);
        SWTBotTreeItem projectItem = explorerTree.getTreeItem(this.project.getName());
        SWTBotTreeItem fileItem = projectItem.expand().getNode(this.csharpSourceFile.getName());
        fileItem.select().contextMenu("Open").click();
        SWTBotEditor editor = bot.editorByTitle(this.csharpSourceFile.getName());
        editor.setFocus();
        editor.toTextEditor().contextMenu("Run As").menu("2 .NET Core Test").click();
        final SWTBotView debugView = bot.viewByTitle("Debug");
        final SWTBotTree debugTree = new SWTBot(debugView.getWidget()).tree(0);
        bot.waitUntil(new ICondition(){

            public boolean test() throws Exception {
                SWTBotTreeItem[] sWTBotTreeItemArray = debugTree.getAllItems();
                int n = sWTBotTreeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SWTBotTreeItem item = sWTBotTreeItemArray[n2];
                    for (String node : item.expand().getNodes()) {
                        if (!node.matches("<terminated, exit value: \\d>dotnet test")) continue;
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            public void init(SWTBot bot) {
                debugView.setFocus();
            }

            public String getFailureMessage() {
                SWTBotView consoleView = bot.viewByPartName("Console");
                return "Test program failed: " + consoleView.bot().styledText().getText();
            }
        }, 30000L);
        SWTBotTreeItem[] sWTBotTreeItemArray = debugTree.getAllItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            for (String node : item.expand().getNodes()) {
                if (!node.matches("<terminated, exit value: \\d>dotnet test")) continue;
                return Integer.parseInt(node.replace("<terminated, exit value: ", "").replace(">dotnet test", ""));
            }
            ++n2;
        }
        return -1;
    }
}

