/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.insert;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.gef.commands.Command;

public class InsertAlgorithmCommand
extends Command
implements ScopedCommand {
    private final BasicFBType fbType;
    private STAlgorithm newAlgorithm;
    private final Algorithm oldAlgorithm;
    private final int index;

    public InsertAlgorithmCommand(BasicFBType fbType, Algorithm oldAlgorithm, int index) {
        this.fbType = Objects.requireNonNull(fbType);
        this.oldAlgorithm = Objects.requireNonNull(oldAlgorithm);
        this.index = index;
    }

    public void execute() {
        this.newAlgorithm = LibraryElementFactory.eINSTANCE.createSTAlgorithm();
        this.newAlgorithm.setName(this.oldAlgorithm.getName());
        this.newAlgorithm.setComment(this.oldAlgorithm.getComment());
        this.newAlgorithm.setText(((STAlgorithm)this.oldAlgorithm).getText());
        this.redo();
        this.newAlgorithm.setName(NameRepository.createUniqueName((INamedElement)this.newAlgorithm, (String)this.oldAlgorithm.getName()));
    }

    public void undo() {
        this.fbType.getCallables().remove((Object)this.newAlgorithm);
    }

    public void redo() {
        this.fbType.getCallables().add(this.index, (Object)this.newAlgorithm);
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.fbType);
    }
}

