; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --include-generated-funcs --version 5
; RUN: opt -passes="ipsccp<func-spec>" -funcspec-min-function-size=1       \
; RUN:                                 -funcspec-for-literal-constant=true \
; RUN:                                 -funcspec-min-codesize-savings=50   \
; RUN:                                 -funcspec-min-latency-savings=0     \
; RUN:                                 -S < %s | FileCheck %s

; Verify that we are able to estimate the codesize savings arising from a branch
; based on a binary operator, where one operand is already found constant by
; IPSCCP.
define i32 @main(i1 %flag) {
  %notspec = call i32 @test(i1 %flag, i1 false)
  %spec = call i32 @test(i1 false, i1 false)
  %sum = add i32 %notspec, %spec
  ret i32 %sum
}

define internal i32 @test(i1 %argflag, i1 %constflag) {
entry:
  %cond = or i1 %argflag, %constflag
  br i1 %cond, label %if.then, label %if.end

if.then:
  call void @do_something()
  call void @do_something()
  call void @do_something()
  call void @do_something()
  br label %if.end

if.end:
  %res = phi i32 [ 0, %entry ], [ 1, %if.then]
  ret i32 %res
}

declare void @do_something()
; CHECK-LABEL: define range(i32 0, 2) i32 @main(
; CHECK-SAME: i1 [[FLAG:%.*]]) {
; CHECK-NEXT:    [[NOTSPEC:%.*]] = call i32 @test(i1 [[FLAG]], i1 false)
; CHECK-NEXT:    [[SPEC:%.*]] = call i32 @test.specialized.1(i1 false, i1 false)
; CHECK-NEXT:    [[SUM:%.*]] = add nuw nsw i32 [[NOTSPEC]], 0
; CHECK-NEXT:    ret i32 [[SUM]]
;
;
; CHECK-LABEL: define internal range(i32 0, 2) i32 @test(
; CHECK-SAME: i1 [[ARGFLAG:%.*]], i1 [[CONSTFLAG:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[COND:%.*]] = or i1 [[ARGFLAG]], false
; CHECK-NEXT:    br i1 [[COND]], label %[[IF_THEN:.*]], label %[[IF_END:.*]]
; CHECK:       [[IF_THEN]]:
; CHECK-NEXT:    call void @do_something()
; CHECK-NEXT:    call void @do_something()
; CHECK-NEXT:    call void @do_something()
; CHECK-NEXT:    call void @do_something()
; CHECK-NEXT:    br label %[[IF_END]]
; CHECK:       [[IF_END]]:
; CHECK-NEXT:    [[RES:%.*]] = phi i32 [ 0, %[[ENTRY]] ], [ 1, %[[IF_THEN]] ]
; CHECK-NEXT:    ret i32 [[RES]]
;
;
; CHECK-LABEL: define internal i32 @test.specialized.1(
; CHECK-SAME: i1 [[ARGFLAG:%.*]], i1 [[CONSTFLAG:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    br label %[[IF_END:.*]]
; CHECK:       [[IF_END]]:
; CHECK-NEXT:    ret i32 poison
;
