/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.annotation;

import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class UnderlineDrawingStrategy
implements AnnotationPainter.IDrawingStrategy {
    public void draw(Annotation annotation, GC gc, StyledText textWidget, int offset, int length, Color color) {
        if (gc != null) {
            Rectangle bounds;
            if (length > 0) {
                bounds = textWidget.getTextBounds(offset, offset + length - 1);
            } else {
                Point location = textWidget.getLocationAtOffset(offset);
                bounds = new Rectangle(location.x, location.y, 1, textWidget.getLineHeight());
            }
            int y = bounds.y + bounds.height - 1;
            gc.setForeground(color);
            gc.drawLine(bounds.x, y, bounds.x + bounds.width, y);
        } else {
            textWidget.redrawRange(offset, length, true);
        }
    }
}

