/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.AllowedValue;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.FsIndexKeyDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypePriorityList;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.taeconfigurator.InternalErrorCDE;
import org.apache.uima.taeconfigurator.TAEConfiguratorPlugin;
import org.apache.uima.taeconfigurator.editors.MultiPageEditor;
import org.apache.uima.taeconfigurator.editors.ui.AbstractImportablePartSection;
import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.CapabilityPage;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddAllowedValueDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddFeatureDialog;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AddTypeDialog;
import org.apache.uima.taeconfigurator.wizards.TypeSystemNewWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;

public class TypeSection
extends AbstractImportablePartSection {
    public static final String CASCADE_MESSAGE = "This will cause a cascading deletion of an associated input, output, index, or type priority, unless this deletion exposes a built-in or imported type or feature of the same name.  Ok to continue?";
    public static final String CASCADE_DELETE_WARNING = "Cascade Delete Warning";
    public static final int NAME_COL = 0;
    public static final int SUPER_COL = 1;
    public static final int RANGE_COL = 1;
    public static final int MULTIPLE_REF_OK_COL = 2;
    public static final int ELEMENT_TYPE_COL = 3;
    public static final int AV_COL = 1;
    public static final String HEADER_ALLOWED_VALUE = "Allowed Value:";
    private TableTree tt;
    private Button addTypeButton;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button jcasGenButton;
    private Button exportButton;
    private Button limitJCasGenToProjectScope;
    private static final boolean ALLOWED = true;
    private static final TypeFeature[] typeFeature0 = new TypeFeature[0];
    private static final int FIND_EQUAL_TYPE = 1;
    private static final int REMOVE_EQUAL_TYPE = 2;
    private static final int UPDATE_TYPE_NAME = 4;
    private static final boolean TYPES = true;
    private static final boolean FEATURES = false;
    private static final Comparator fsIndexDescCompare = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((FsIndexDescription)o2).getTypeName().equals(o1) ? 0 : 1;
        }
    };
    private static final Comparator fsIndexKeyDescCompare = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.equals(((FsIndexKeyDescription)o2).getFeatureName()) ? 0 : 1;
        }
    };
    private static final Comparator capabilityTypeCompare = new Comparator(){

        public int compare(Object o1, Object o2) {
            TypeOrFeature tf = (TypeOrFeature)o2;
            return tf.isType() && tf.getName().equals(o1) || tf.getName().startsWith((String)o1 + ':') ? 0 : 1;
        }
    };
    private static final Comparator capabilityFeatureCompare = new Comparator(){

        public int compare(Object o1, Object o2) {
            TypeOrFeature tf = (TypeOrFeature)o2;
            return !tf.isType() && tf.getName().equals(o1) ? 0 : 1;
        }
    };

    public TypeSection(MultiPageEditor editor, Composite parent) {
        super(editor, parent, "Types (or Classes)", "The following types (classes) are defined in this analysis engine descriptor.\nThe grayed out items are imported or merged from other descriptors, and cannot be edited here. (To edit them, edit their source files).");
    }

    @Override
    public void initialize(IManagedForm form) {
        super.initialize(form);
        Composite sectionClient = this.new2ColumnComposite((Composite)this.getSection());
        this.enableBorders(sectionClient);
        this.toolkit.paintBordersFor(sectionClient);
        this.tt = this.newTableTree(sectionClient, 65540);
        new TableColumn(this.tt.getTable(), 0).setText("Type Name or Feature Name");
        new TableColumn(this.tt.getTable(), 0).setText("SuperType or Range");
        new TableColumn(this.tt.getTable(), 0).setText(" ");
        new TableColumn(this.tt.getTable(), 0).setText("Element Type");
        this.tt.getTable().setHeaderVisible(true);
        this.tt.getTable().addListener(32, (Listener)this);
        Composite buttonContainer = this.newButtonContainer(sectionClient);
        this.addTypeButton = this.newPushButton(buttonContainer, "Add Type", "Click here to add a new type.");
        this.addButton = this.newPushButton(buttonContainer, "Add...", "Click here to add a feature or allowed-value to the selected type.");
        this.editButton = this.newPushButton(buttonContainer, "Edit...", "Click here to edit the selected item. You can also double-click the item to edit it.");
        this.removeButton = this.newPushButton(buttonContainer, "Remove", "Click here to remove the selected item.  You can also use the delete key.");
        this.exportButton = this.newPushButton(buttonContainer, "Export...", "Export to an importable part, and substitute an Import for that part here");
        TypeSection.spacer(buttonContainer);
        this.jcasGenButton = this.newPushButton(buttonContainer, "JCasGen", "Click here to run JCasGen on this type system.");
        this.limitJCasGenToProjectScope = this.newCheckBox(buttonContainer, "limited", "JCasGen only those types defined within this project\n  You can change the default in UIMA prefs or in the UIMA menu");
        boolean defaultValue = this.editor.getLimitJCasGenToProjectScope();
        this.limitJCasGenToProjectScope.setSelection(defaultValue);
    }

    public void refresh() {
        super.refresh();
        this.tt.removeAll();
        TypeSystemDescription tsdFull = this.getMergedTypeSystemDescription();
        TypeDescription[] tdsFull = tsdFull.getTypes();
        if (null != tdsFull) {
            for (int i = 0; i < tdsFull.length; ++i) {
                this.addTypeToGUI(tdsFull[i]);
            }
        }
        if (this.tt.getItemCount() > 0) {
            this.tt.setSelection(new TableTreeItem[]{this.tt.getItems()[0]});
        }
        this.packTable(this.tt.getTable());
        this.enable();
    }

    private FeatureDescription[] setDifference(FeatureDescription[] all, FeatureDescription[] subset) {
        if (null == all) {
            return featureDescriptionArray0;
        }
        if (null == subset) {
            return all;
        }
        ArrayList<FeatureDescription> result = new ArrayList<FeatureDescription>();
        block0: for (int i = 0; i < all.length; ++i) {
            String name = all[i].getName();
            for (int j = 0; j < subset.length; ++j) {
                if (subset[j].getName().equals(name)) continue block0;
            }
            result.add(all[i]);
        }
        return result.toArray(new FeatureDescription[result.size()]);
    }

    private void addTypeToGUI(TypeDescription td) {
        AllowedValue[] avs;
        TableTreeItem item = new TableTreeItem(this.tt, 0);
        item.setText(0, this.formatName(td.getName()));
        item.setText(1, this.formatName(td.getSupertypeName()));
        item.setData((Object)td);
        this.setItemColor(item, this.isLocalType(td));
        FeatureDescription[] features = td.getFeatures();
        this.addFeaturesToGui(td, item, features);
        TypeDescription builtInTd = this.getBuiltInTypeDescription(td);
        if (null != builtInTd) {
            FeatureDescription[] additionalBuiltInFeatures = this.setDifference(builtInTd.getFeatures(), td.getFeatures());
            this.addFeaturesToGui(td, item, additionalBuiltInFeatures);
        }
        if (null != (avs = td.getAllowedValues())) {
            for (int i = 0; i < avs.length; ++i) {
                TableTreeItem avItem = new TableTreeItem(item, 0);
                avItem.setText(0, HEADER_ALLOWED_VALUE);
                avItem.setText(1, TypeSection.convertNull(avs[i].getString()));
                avItem.setData((Object)avs[i]);
                this.setItemColor(avItem, null != this.getLocalAllowedValue(td, avs[i]));
            }
        }
        item.setExpanded(true);
    }

    private void addFeaturesToGui(TypeDescription td, TableTreeItem item, FeatureDescription[] features) {
        if (null != features) {
            for (int i = 0; i < features.length; ++i) {
                TableTreeItem fItem = new TableTreeItem(item, 0);
                this.updateGuiFeature(fItem, features[i], td);
            }
        }
    }

    private void updateGuiFeature(TableTreeItem fItem, FeatureDescription fd, TypeDescription td) {
        fItem.setText(0, fd.getName());
        String rangeType = fd.getRangeTypeName();
        fItem.setText(1, this.formatName(rangeType));
        fItem.setData((Object)fd);
        this.setItemColor(fItem, null != this.getLocalFeatureDefinition(td, fd));
        if (TypeSection.isArrayOrListType(rangeType)) {
            Boolean mra = fd.getMultipleReferencesAllowed();
            fItem.setImage(2, null != mra && mra != false ? TAEConfiguratorPlugin.getImage("arrows.gif") : TAEConfiguratorPlugin.getImage("one_arrow.gif"));
        } else {
            fItem.setImage(2, null);
        }
        String ert = fd.getElementType();
        fItem.setText(3, TypeSection.isFSArrayOrListType(rangeType) && ert != null ? this.formatName(ert) : "");
    }

    private void setItemColor(TableTreeItem item, boolean isLocal) {
        if (isLocal) {
            return;
        }
        item.setForeground(this.editor.getFadeColor());
    }

    public void handleEvent(Event event) {
        if (event.widget == this.addTypeButton) {
            this.handleAddType();
        } else if (event.widget == this.addButton) {
            TableTreeItem parent = this.tt.getSelection()[0];
            if (null != parent.getParentItem()) {
                parent = parent.getParentItem();
            }
            if (this.isSubtypeOfString(parent)) {
                this.handleAddAllowedValue(parent);
            } else {
                this.handleAddFeature(parent);
            }
        } else if (event.widget == this.editButton) {
            this.handleEdit();
        } else if (event.type == 8 && !this.isAggregate() && this.isLocalItem(this.tt.getSelection()[0])) {
            this.handleEdit();
        } else if (event.widget == this.removeButton) {
            this.handleRemove();
        } else if (event.widget == this.exportButton) {
            this.editor.getTypePage().getTypeImportSection().exportImportablePart("<typeSystemDescription>", TypeSystemNewWizard.TYPESYSTEM_TEMPLATE);
            this.refresh();
        } else if (event.widget == this.jcasGenButton) {
            this.editor.doJCasGenChkSrc(null);
        } else if (event.widget == this.limitJCasGenToProjectScope) {
            this.editor.setLimitJCasGenToProjectScope(this.limitJCasGenToProjectScope.getSelection());
        } else if (event.type == 32) {
            this.handleHover(event);
        }
        this.enable();
    }

    public void handleHover(Event event) {
        TableTreeItem item = this.tt.getItem(new Point(event.x, event.y));
        if (null != item) {
            Object o = item.getData();
            if (null == o) {
                throw new InternalErrorCDE("invalid state");
            }
            if (o instanceof TypeDescription) {
                TypeSection.setToolTipText((Control)this.tt, ((TypeDescription)o).getDescription());
            } else if (o instanceof FeatureDescription) {
                FeatureDescription fd = (FeatureDescription)o;
                if (item.getBounds(2).contains(event.x, event.y) && TypeSection.isArrayOrListType(fd.getRangeTypeName())) {
                    Boolean mra = fd.getMultipleReferencesAllowed();
                    TypeSection.setToolTipText((Control)this.tt, mra != null && mra != false ? "Multiple References Allowed" : "Multiple References Not Allowed");
                } else {
                    TypeSection.setToolTipText((Control)this.tt, fd.getDescription());
                }
            } else if (o instanceof AllowedValue) {
                TypeSection.setToolTipText((Control)this.tt, ((AllowedValue)o).getDescription());
            }
        } else {
            this.tt.setToolTipText("");
        }
    }

    public TypeDescription getTypeDescriptionFromTableTreeItem(TableTreeItem item) {
        return (TypeDescription)item.getData();
    }

    public void handleAddAllowedValue(TableTreeItem parent) {
        boolean refreshNeeded = false;
        TypeDescription td = this.getTypeDescriptionFromTableTreeItem(parent);
        TypeDescription localTd = this.getLocalTypeDefinition(td);
        AddAllowedValueDialog dialog = new AddAllowedValueDialog(this, null);
        if (dialog.open() == 1) {
            return;
        }
        AllowedValue av = UIMAFramework.getResourceSpecifierFactory().createAllowedValue();
        this.allowedValueUpdate(av, dialog);
        this.addAllowedValue(localTd, av);
        if (!Utility.arrayContains(td.getAllowedValues(), av)) {
            this.addAllowedValue(td, (AllowedValue)av.clone());
        } else {
            refreshNeeded = true;
        }
        if (refreshNeeded) {
            this.refresh();
        } else {
            TableTreeItem item = new TableTreeItem(parent, 0);
            item.setText(0, HEADER_ALLOWED_VALUE);
            item.setText(1, TypeSection.convertNull(av.getString()));
            item.setData((Object)av);
            parent.setExpanded(true);
        }
        this.editor.addDirtyTypeName(td.getName());
        this.finishActionPack();
    }

    private void addAllowedValue(TypeDescription td, AllowedValue av) {
        td.setAllowedValues((AllowedValue[])Utility.addElementToArray(td.getAllowedValues(), av, AllowedValue.class));
    }

    private void removeAllowedValue(TypeDescription td, AllowedValue av) {
        td.setAllowedValues((AllowedValue[])Utility.removeEqualElementFromArray(td.getAllowedValues(), av, AllowedValue.class));
    }

    public void handleAddFeature(TableTreeItem parent) {
        TypeDescription td = this.getTypeDescriptionFromTableTreeItem(parent);
        TypeDescription localTd = this.getLocalTypeDefinition(td);
        AddFeatureDialog dialog = new AddFeatureDialog((AbstractSection)this, td, null);
        if (dialog.open() == 1) {
            return;
        }
        FeatureDescription fd = localTd.addFeature(null, null, null);
        this.featureUpdate(fd, dialog);
        this.editor.addDirtyTypeName(td.getName());
        if (this.isImportedType(td) || this.isBuiltInType(td)) {
            if (!this.isImportedFeature(dialog.featureName, td)) {
                fd = td.addFeature(null, null, null);
                this.featureUpdate(fd, dialog);
            }
            this.refresh();
            this.selectTypeInGui(td);
            this.finishAction();
        } else {
            fd = td.addFeature(null, null, null);
            this.featureUpdate(fd, dialog);
            TableTreeItem item = new TableTreeItem(parent, 0);
            this.updateGuiFeature(item, fd, td);
            parent.setExpanded(true);
            this.finishActionPack();
        }
    }

    private void selectTypeInGui(TypeDescription td) {
        TableTreeItem[] items = this.tt.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!td.getName().equals(((TypeDescription)items[i].getData()).getName())) continue;
            this.tt.setSelection(new TableTreeItem[]{items[i]});
            return;
        }
    }

    public void allowedValueUpdate(AllowedValue av, AddAllowedValueDialog dialog) {
        this.valueChanged = false;
        av.setString(this.setValueChanged(dialog.allowedValue, av.getString()));
        av.setDescription(this.setValueChanged(dialog.description, av.getDescription()));
    }

    public void featureUpdate(FeatureDescription fd, AddFeatureDialog dialog) {
        this.valueChanged = false;
        String v = this.setValueChanged(dialog.featureName, fd.getName());
        fd.setName(v);
        v = this.setValueChanged(this.multiLineFix(dialog.description), fd.getDescription());
        fd.setDescription(v);
        String range = this.setValueChanged(dialog.featureRangeName, fd.getRangeTypeName());
        fd.setRangeTypeName(range);
        if (TypeSection.isArrayOrListType(range)) {
            Boolean b = this.setValueChangedCapitalBoolean(dialog.multiRef, fd.getMultipleReferencesAllowed());
            fd.setMultipleReferencesAllowed(b);
            if (TypeSection.isFSArrayOrListType(range)) {
                v = this.setValueChanged(dialog.elementRangeName, fd.getElementType());
                fd.setElementType(v);
            } else {
                fd.setElementType(null);
            }
        } else {
            fd.setMultipleReferencesAllowed(null);
            fd.setElementType(null);
        }
    }

    public void handleAddType() {
        AddTypeDialog dialog = new AddTypeDialog(this);
        if (dialog.open() == 1) {
            return;
        }
        TypeSystemDescription tsd = this.getMergedTypeSystemDescription();
        TypeSystemDescription localTsd = this.getTypeSystemDescription();
        TypeDescription td = localTsd.addType(dialog.typeName, this.multiLineFix(dialog.description), dialog.supertypeName);
        if (!this.isImportedType(dialog.typeName)) {
            td = tsd.addType(dialog.typeName, this.multiLineFix(dialog.description), dialog.supertypeName);
            this.addTypeToGUI(td);
        } else {
            this.rebuildMergedTypeSystem();
        }
        if (this.isImportedType(dialog.typeName) || this.isBuiltInType(dialog.typeName)) {
            this.refresh();
            this.selectTypeInGui(td);
        }
        this.editor.addDirtyTypeName(dialog.typeName);
        this.finishActionPack();
    }

    private void finishActionPack() {
        this.packTable(this.tt.getTable());
        this.finishAction();
    }

    private void finishAction() {
        if (this.isLocalProcessingDescriptor()) {
            this.editor.getIndexesPage().markStale();
            this.editor.getCapabilityPage().markStale();
        }
        this.setFileDirty();
    }

    private void handleEdit() {
        TableTreeItem item = this.tt.getSelection()[0];
        TableTreeItem parentType = item.getParentItem();
        if (null == parentType) {
            this.editType(item);
        } else if (item.getText(0).equals(HEADER_ALLOWED_VALUE)) {
            this.editAllowedValue(item, parentType);
        } else {
            this.editFeature(item, parentType);
        }
    }

    public FeatureDescription getFeatureDescriptionFromTableTreeItem(TableTreeItem item) {
        return (FeatureDescription)item.getData();
    }

    private void editFeature(TableTreeItem item, TableTreeItem parent) {
        boolean remergeNeeded = false;
        boolean refreshNeeded = false;
        TypeDescription td = this.getTypeDescriptionFromTableTreeItem(parent);
        FeatureDescription fd = this.getFeatureDescriptionFromTableTreeItem(item);
        FeatureDescription localFd = this.getLocalFeatureDefinition(td, fd);
        String oldFeatureName = fd.getName();
        AddFeatureDialog dialog = new AddFeatureDialog((AbstractSection)this, td, fd);
        if (dialog.open() == 1) {
            return;
        }
        this.featureUpdate(localFd, dialog);
        if (!this.valueChanged) {
            return;
        }
        if (!dialog.featureName.equals(oldFeatureName)) {
            if (this.isImportedFeature(oldFeatureName, td)) {
                Utility.popMessage("Imported Feature not changed", "Changing the feature name from '" + oldFeatureName + "' to '" + dialog.featureName + "' will not affect the corresponding imported type with the previous feature name.  Both features will be included in the type.", 2);
                remergeNeeded = true;
                refreshNeeded = true;
            }
            if (this.isBuiltInFeature(oldFeatureName, td)) {
                Utility.popMessage("BuiltIn Feature not changed", "Changing the feature name from '" + oldFeatureName + "' to '" + dialog.featureName + "' will not affect the corresponding built-in type with the previous feature name.  Both features will be included in the type.", 2);
                refreshNeeded = true;
            }
        }
        if (remergeNeeded) {
            this.rebuildMergedTypeSystem();
        } else {
            this.featureUpdate(fd, dialog);
        }
        if (refreshNeeded) {
            this.refresh();
        } else {
            this.updateGuiFeature(item, fd, td);
        }
        this.alterFeatureMentions(oldFeatureName, fd.getName(), td.getName());
        this.editor.addDirtyTypeName(td.getName());
        this.finishActionPack();
    }

    public AllowedValue getAllowedValueFromTableTreeItem(TableTreeItem item) {
        return (AllowedValue)item.getData();
    }

    private void editAllowedValue(TableTreeItem item, TableTreeItem parent) {
        TypeDescription td = this.getTypeDescriptionFromTableTreeItem(parent);
        AllowedValue av = this.getAllowedValueFromTableTreeItem(item);
        AllowedValue localAv = this.getLocalAllowedValue(td, av);
        AddAllowedValueDialog dialog = new AddAllowedValueDialog(this, av);
        if (dialog.open() == 1) {
            return;
        }
        this.allowedValueUpdate(av, dialog);
        this.allowedValueUpdate(localAv, dialog);
        if (!this.valueChanged) {
            return;
        }
        item.setText(1, av.getString());
        this.editor.addDirtyTypeName(td.getName());
        this.finishActionPack();
    }

    private String newFeatureTests(TypeDescription td, AddFeatureDialog dialog) {
        if (this.isLocalFeature(dialog.featureName, td)) {
            return "Duplicate Feature Name in this Descriptor";
        }
        if (this.isBuiltInFeature(dialog.featureName, td)) {
            return "Feature Name duplicates built-in feature for this type";
        }
        FeatureDescription fd = this.getFeature(td, dialog.featureName);
        if (null != fd && !fd.getRangeTypeName().equals(dialog.featureRangeName)) {
            return "Range Name not the same as the range from an imported type/feature description";
        }
        return null;
    }

    public String checkFeature(AddFeatureDialog dialog, TypeDescription td, FeatureDescription oldFd) {
        if (null == oldFd) {
            return this.newFeatureTests(td, dialog);
        }
        String errMsg = null;
        if (!oldFd.getName().equals(dialog.featureName)) {
            errMsg = this.newFeatureTests(td, dialog);
            if (null != errMsg) {
                return errMsg;
            }
            return null;
        }
        if (this.isFeatureUsedInIndex(td, dialog.featureName) && !TypeSection.isIndexableRange(dialog.featureRangeName)) {
            return "This feature is used in an index - it must have an indexable Range";
        }
        return null;
    }

    public String checkAllowedValue(AddAllowedValueDialog dialog, TypeDescription td, AllowedValue av) {
        if (this.isLocalAllowedValue(dialog.allowedValue, td)) {
            return "Duplicate Allowed Value in this Descriptor";
        }
        return null;
    }

    private void editType(TableTreeItem item) {
        boolean mergeAndRefreshNeeded = false;
        boolean refreshNeeded = false;
        TypeDescription td = this.getTypeDescriptionFromTableTreeItem(item);
        AddTypeDialog dialog = new AddTypeDialog(this, td);
        if (dialog.open() == 1) {
            return;
        }
        String newTypeName = dialog.typeName;
        String oldTypeName = td.getName();
        String[] typesRequiringThisOne = stringArray0;
        if (!oldTypeName.equals(newTypeName)) {
            typesRequiringThisOne = this.showTypesRequiringThisOneMessage(oldTypeName, true);
            if (null == typesRequiringThisOne) {
                return;
            }
            if (this.isImportedType(oldTypeName) && 1 == Utility.popOkCancel("Type define via Import", "The type '" + oldTypeName + "' is also defined in 1 or more imports.  Changing the type name here will not change it in the imported type file, causing both types to be in the type system, together. Please confirm this is what you intend.", 4)) {
                return;
            }
            if (this.isBuiltInType(oldTypeName) && 1 == Utility.popOkCancel("Type was extending a built-in", "The type '" + oldTypeName + "' was extending a builtin type of the same name. Changing the type name here will not change the built-in type, causing both types to be in the type system, together. Please confirm this is what you intend.", 4)) {
                return;
            }
            if (this.isImportedType(oldTypeName) || this.isImportedType(newTypeName) || this.isBuiltInType(oldTypeName) || this.isBuiltInType(newTypeName)) {
                mergeAndRefreshNeeded = true;
            }
        }
        this.valueChanged = false;
        TypeDescription localTd = this.getLocalTypeDefinition(td);
        this.typeUpdate(localTd, dialog);
        if (!this.valueChanged) {
            return;
        }
        if (mergeAndRefreshNeeded) {
            this.rebuildMergedTypeSystem();
            td = this.getMergedTypeSystemDescription().getType(newTypeName);
        } else {
            this.typeUpdate(td, dialog);
            this.updateGuiType(item, td);
        }
        this.editor.removeDirtyTypeName(oldTypeName);
        this.editor.addDirtyTypeName(td.getName());
        if ((refreshNeeded |= this.alterTypeMentionsInOtherTypes(oldTypeName, td.getName())) || mergeAndRefreshNeeded) {
            this.refresh();
        }
        this.alterTypeMentions(oldTypeName, td.getName());
        this.finishActionPack();
    }

    private void updateGuiType(TableTreeItem item, TypeDescription td) {
        item.setText(0, this.formatName(td.getName()));
        item.setText(1, this.formatName(td.getSupertypeName()));
    }

    private void rebuildMergedTypeSystem() {
        try {
            this.editor.setMergedTypeSystemDescription();
        }
        catch (ResourceInitializationException e) {
            throw new InternalErrorCDE(e);
        }
    }

    private void typeUpdate(TypeDescription td, AddTypeDialog dialog) {
        td.setName(this.setValueChanged(dialog.typeName, td.getName()));
        td.setDescription(this.setValueChanged(this.multiLineFix(dialog.description), td.getDescription()));
        td.setSupertypeName(this.setValueChanged(dialog.supertypeName, td.getSupertypeName()));
    }

    public String checkDuplTypeName(String newTypeName) {
        if (this.isLocalType(newTypeName)) {
            return "The type '" + newTypeName + "' is already defined locally in this descriptor.";
        }
        return null;
    }

    private void handleRemove() {
        TableTreeItem item = this.tt.getSelection()[0];
        TableTreeItem parent = item.getParentItem();
        if (null == parent) {
            this.handleRemoveType(item);
        } else if (item.getText(0).equals(HEADER_ALLOWED_VALUE)) {
            this.handleRemoveAllowedValue(item);
        } else {
            this.handleRemoveFeature(item);
        }
    }

    private void handleRemoveAllowedValue(TableTreeItem item) {
        TypeDescription td = this.getTypeDescriptionFromTableTreeItem(item.getParentItem());
        AllowedValue av = this.getAllowedValueFromTableTreeItem(item);
        this.removeAllowedValue(this.getLocalTypeDefinition(td), av);
        if (!this.isImportedAllowedValue(td, av)) {
            this.removeAllowedValue(td, av);
            this.tt.getTable().setSelection(this.tt.getTable().getSelectionIndex() - 1);
            item.dispose();
        } else {
            this.refresh();
        }
        this.editor.addDirtyTypeName(td.getName());
        this.finishAction();
    }

    private void handleRemoveFeature(TableTreeItem item) {
        FeatureDescription fd;
        String featureName;
        TypeDescription td = this.getTypeDescriptionFromTableTreeItem(item.getParentItem());
        boolean bFeatureInUseElsewhere = this.isFeatureInUseElsewhere(td, featureName = (fd = this.getFeatureDescriptionFromTableTreeItem(item)).getName());
        if (bFeatureInUseElsewhere) {
            String sCascadeDeleteTitle = CASCADE_DELETE_WARNING;
            String sCascadeDeleteMessage = CASCADE_MESSAGE;
            boolean bContinue = MessageDialog.openConfirm((Shell)this.getSection().getShell(), (String)sCascadeDeleteTitle, (String)sCascadeDeleteMessage);
            if (!bContinue) {
                return;
            }
        }
        TypeDescription localTd = this.getLocalTypeDefinition(td);
        FeatureDescription localFd = this.getLocalFeatureDefinition(td, fd);
        this.removeFeature(localTd, localFd);
        if (this.isImportedFeature(featureName, td)) {
            this.refresh();
        } else {
            this.removeFeature(td, fd);
            if (this.isBuiltInFeature(featureName, td)) {
                this.refresh();
            } else {
                this.tt.getTable().setSelection(this.tt.getTable().getSelectionIndex() - 1);
                item.dispose();
            }
        }
        if (bFeatureInUseElsewhere && !this.isImportedFeature(featureName, td) && !this.isBuiltInFeature(featureName, td)) {
            this.deleteTypeOrFeatureMentions(featureName, false, localTd.getName());
        }
        this.editor.addDirtyTypeName(td.getName());
        this.finishAction();
    }

    private TypeFeature[] computeFeaturesToRemove(TypeDescription localTd, TypeDescription mergedTd) {
        if (null == mergedTd) {
            return typeFeature0;
        }
        FeatureDescription[] locallyDefinedFeatures = localTd.getFeatures();
        if (null == locallyDefinedFeatures || locallyDefinedFeatures.length == 0) {
            return typeFeature0;
        }
        FeatureDescription[] remainingFeatures = mergedTd.getFeatures();
        ArrayList<String> deletedFeatures = new ArrayList<String>();
        block0: for (int i = 0; i < locallyDefinedFeatures.length; ++i) {
            String fname = locallyDefinedFeatures[i].getName();
            if (null != remainingFeatures) {
                for (int j = 0; j < remainingFeatures.length; ++j) {
                    if (fname.equals(remainingFeatures[j].getName())) continue block0;
                }
            }
            deletedFeatures.add(fname);
        }
        CAS tcas = this.editor.getCurrentView();
        TypeSystem typeSystem = tcas.getTypeSystem();
        Type thisType = typeSystem.getType(localTd.getName());
        List subsumedTypesList = typeSystem.getProperlySubsumedTypes(thisType);
        subsumedTypesList.add(thisType);
        Type[] subsumedTypes = subsumedTypesList.toArray(new Type[0]);
        String[] featNameArray = deletedFeatures.toArray(new String[deletedFeatures.size()]);
        ArrayList<TypeFeature> result = new ArrayList<TypeFeature>();
        for (int i = 0; i < subsumedTypes.length; ++i) {
            Type t = subsumedTypes[i];
            for (int j = 0; j < featNameArray.length; ++j) {
                if (null == t.getFeatureByBaseName(featNameArray[j])) continue;
                result.add(new TypeFeature(t.getName(), featNameArray[j]));
            }
        }
        return result.toArray(typeFeature0);
    }

    private void handleRemoveType(TableTreeItem item) {
        TypeDescription td = this.getTypeDescriptionFromTableTreeItem(item);
        String sTypeNameToRemove = td.getName();
        if (null == this.showTypesRequiringThisOneMessage(sTypeNameToRemove, false)) {
            return;
        }
        boolean bTypeInUseElsewhere = this.isTypeInUseElsewhere(sTypeNameToRemove);
        if (bTypeInUseElsewhere) {
            String sCascadeDeleteTitle = CASCADE_DELETE_WARNING;
            String sCascadeDeleteMessage = CASCADE_MESSAGE;
            boolean bContinue = MessageDialog.openConfirm((Shell)this.getSection().getShell(), (String)sCascadeDeleteTitle, (String)sCascadeDeleteMessage);
            if (!bContinue) {
                return;
            }
        }
        TypeDescription localTd = this.getLocalTypeDefinition(td);
        this.removeType(localTd, this.getTypeSystemDescription());
        if (this.isImportedType(td)) {
            this.rebuildMergedTypeSystem();
            this.refresh();
        } else {
            this.removeType(td, this.getMergedTypeSystemDescription());
            this.tt.getTable().setSelection(this.tt.getTable().getSelectionIndex() - 1);
            item.dispose();
        }
        TypeFeature[] featuresToRemove = this.computeFeaturesToRemove(localTd, this.getMergedTypeSystemDescription().getType(td.getName()));
        if (bTypeInUseElsewhere && !this.isImportedType(td) && !this.isBuiltInType(td)) {
            this.deleteTypeOrFeatureMentions(sTypeNameToRemove, true, null);
        }
        if (null != featuresToRemove) {
            for (int i = 0; i < featuresToRemove.length; ++i) {
                this.deleteTypeOrFeatureMentions(featuresToRemove[i].featureName, false, featuresToRemove[i].typeName);
            }
        }
        this.editor.removeDirtyTypeName(sTypeNameToRemove);
        this.finishAction();
    }

    private String[] showTypesRequiringThisOneMessage(String existingTypeName, boolean allowed) {
        if (this.isImportedType(existingTypeName) || this.isBuiltInType(existingTypeName)) {
            return stringArray0;
        }
        String[] typesRequiringThisOne = this.getTypesRequiringThisOne(existingTypeName);
        if (typesRequiringThisOne != null && typesRequiringThisOne.length > 0) {
            String sMsg = existingTypeName + " has the following dependent type(s): ";
            for (int i = 0; i < typesRequiringThisOne.length; ++i) {
                if (i > 0) {
                    sMsg = sMsg + ", ";
                }
                sMsg = sMsg + typesRequiringThisOne[i];
            }
            if (!allowed) {
                sMsg = sMsg + ".  Please delete dependent types first.";
                Utility.popMessage("Can''t Remove Needed Type", sMsg, 4);
                return null;
            }
            if (0 == Utility.popOkCancel("Confirm renaming type update actions", sMsg = sMsg + ".  If you proceed, the dependent types which are updatable will be updated. Non-updatable types (imported, etc.) you will have to update manually.  Please confirm.", 4)) {
                return typesRequiringThisOne;
            }
            return null;
        }
        return stringArray0;
    }

    private void removeType(TypeDescription td, TypeSystemDescription tsd) {
        tsd.setTypes((TypeDescription[])Utility.removeElementFromArray(tsd.getTypes(), td, TypeDescription.class));
    }

    private void removeFeature(TypeDescription td, FeatureDescription fd) {
        td.setFeatures((FeatureDescription[])Utility.removeElementFromArray(td.getFeatures(), fd, FeatureDescription.class));
    }

    private String[] getTypesRequiringThisOne(String typeName) {
        ArrayList<String> upstreamTypeNames = new ArrayList<String>();
        TypeSystemDescription typeSystem = this.getMergedTypeSystemDescription();
        TypeDescription[] types = typeSystem.getTypes();
        for (int i = 0; i < types.length; ++i) {
            if (types[i].getName().equals(typeName) || !this.typeRequiresType(types[i], typeName)) continue;
            upstreamTypeNames.add(types[i].getName());
        }
        return upstreamTypeNames.toArray(new String[upstreamTypeNames.size()]);
    }

    private boolean typeRequiresType(TypeDescription upstreamType, String typeName) {
        if (null == typeName) {
            return false;
        }
        if (typeName.equals(upstreamType.getSupertypeName())) {
            return true;
        }
        FeatureDescription[] features = upstreamType.getFeatures();
        if (features == null) {
            return false;
        }
        for (int i = 0; i < features.length; ++i) {
            if (!typeName.equals(features[i].getRangeTypeName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void enable() {
        TypeDescription[] tsa;
        this.jcasGenButton.setEnabled(this.tt.getItemCount() > 0);
        TypeSystemDescription tsd = this.getTypeSystemDescription();
        this.exportButton.setEnabled(false);
        if (null != tsd && null != (tsa = tsd.getTypes())) {
            this.exportButton.setEnabled(tsa.length > 0);
        }
        if (this.isAggregate()) {
            this.addTypeButton.setEnabled(false);
            this.addButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else {
            this.addTypeButton.setEnabled(true);
            boolean editable = this.tt.getSelectionCount() == 1 && this.isLocalItem(this.tt.getSelection()[0]);
            this.addButton.setEnabled(editable);
            this.editButton.setEnabled(editable);
            this.removeButton.setEnabled(editable);
        }
    }

    private boolean isSubtypeOfString(TableTreeItem item) {
        TypeDescription td = this.getTypeDescriptionFromTableTreeItem(item);
        return "uima.cas.String".equals(td.getSupertypeName());
    }

    private boolean isTypeInUseElsewhere(final String sTypeName) {
        if (!this.isLocalProcessingDescriptor()) {
            return false;
        }
        final String sTypeName_Colon = sTypeName + ":";
        CapabilityVisitor cv = new CapabilityVisitor(){

            @Override
            boolean visit(TypeOrFeature i_o) {
                if (i_o.isType() && i_o.getName().equals(sTypeName)) {
                    return true;
                }
                return i_o.getName().startsWith(sTypeName_Colon);
            }
        };
        if (this.capabilityVisit(cv)) {
            return true;
        }
        FsIndexDescription[] indexes = this.getAnalysisEngineMetaData().getFsIndexes();
        if (indexes != null) {
            for (int i = 0; i < indexes.length; ++i) {
                if (!indexes[i].getTypeName().equals(sTypeName)) continue;
                return true;
            }
        }
        return this.typePriorityListsVisit(1, sTypeName);
    }

    private boolean typePriorityListsVisit(int kind, String typeName) {
        return this.typePriorityListsVisit(kind, typeName, null);
    }

    private boolean typePriorityListsVisit(int kind, String typeName, String newTypeName) {
        TypePriorityList[] priorityLists;
        boolean returnValue = false;
        TypePriorities priorities = this.getAnalysisEngineMetaData().getTypePriorities();
        if (priorities != null && (priorityLists = priorities.getPriorityLists()) != null) {
            for (int i = 0; i < priorityLists.length; ++i) {
                Object[] typeNames = priorityLists[i].getTypes();
                if (typeNames == null) continue;
                if (kind == 1) {
                    for (int j = 0; j < typeNames.length; ++j) {
                        if (!typeNames[j].equals(typeName)) continue;
                        return true;
                    }
                    continue;
                }
                if (kind == 4) {
                    boolean bChanged = false;
                    for (int j = 0; j < typeNames.length; ++j) {
                        if (!((String)typeNames[j]).equals(typeName)) continue;
                        typeNames[j] = newTypeName;
                        bChanged = true;
                        break;
                    }
                    if (!bChanged) continue;
                    priorityLists[i].setTypes((String[])typeNames);
                    returnValue = true;
                    continue;
                }
                if (kind == 2) {
                    Object[] newTypeNames = Utility.removeElementsFromArray(typeNames, typeName, String.class);
                    if (newTypeNames == typeNames) continue;
                    priorityLists[i].setTypes((String[])newTypeNames);
                    returnValue = true;
                    continue;
                }
                throw new InternalErrorCDE("invalid argument");
            }
        }
        return returnValue;
    }

    private TypeOrFeature[] deleteTypeOrFeatureFromCapability(TypeOrFeature[] io_s, boolean isType, String name, String typeName) {
        if (!isType) {
            name = typeName + ':' + name;
        }
        return (TypeOrFeature[])Utility.removeElementsFromArray(io_s, name, TypeOrFeature.class, isType ? capabilityTypeCompare : capabilityFeatureCompare);
    }

    private void deleteTypeOrFeatureMentions(String typeOrFeatureName, boolean isType, String typeName) {
        FsIndexCollection indexCollection;
        if (!this.isLocalProcessingDescriptor()) {
            return;
        }
        Capability[] c = this.getCapabilities();
        for (int ic = 0; ic < c.length; ++ic) {
            c[ic].setInputs(this.deleteTypeOrFeatureFromCapability(c[ic].getInputs(), isType, typeOrFeatureName, typeName));
            c[ic].setOutputs(this.deleteTypeOrFeatureFromCapability(c[ic].getOutputs(), isType, typeOrFeatureName, typeName));
        }
        CapabilityPage p = this.editor.getCapabilityPage();
        if (null != p) {
            p.markStale();
        }
        Object[] indexes = null == (indexCollection = this.editor.getFsIndexCollection()) ? null : indexCollection.getFsIndexes();
        boolean somethingChanged = false;
        if (indexes != null) {
            if (isType) {
                FsIndexDescription[] newFsid = (FsIndexDescription[])Utility.removeElementsFromArray(indexes, typeOrFeatureName, FsIndexDescription.class, fsIndexDescCompare);
                if (newFsid != indexes) {
                    somethingChanged = true;
                    indexCollection.setFsIndexes(newFsid);
                }
            } else {
                for (int i = 0; i < indexes.length; ++i) {
                    FsIndexKeyDescription[] newFsKeys;
                    if (!typeName.equals(indexes[i].getTypeName()) || (newFsKeys = (FsIndexKeyDescription[])Utility.removeElementsFromArray(indexes[i].getKeys(), typeOrFeatureName, FsIndexKeyDescription.class, fsIndexKeyDescCompare)) == indexes[i].getKeys()) continue;
                    somethingChanged = true;
                    indexes[i].setKeys(newFsKeys);
                }
            }
            if (somethingChanged) {
                try {
                    this.editor.setMergedFsIndexCollection();
                }
                catch (ResourceInitializationException e) {
                    throw new InternalErrorCDE("unexpected exception", e);
                }
                if (null != this.editor.getIndexesPage()) {
                    this.editor.getIndexesPage().markStale();
                }
            }
        }
        if (isType && this.typePriorityListsVisit(2, typeOrFeatureName)) {
            try {
                this.editor.setMergedTypePriorities();
            }
            catch (ResourceInitializationException e) {
                throw new InternalErrorCDE("unexpected exception");
            }
            if (null != this.editor.getIndexesPage()) {
                this.editor.getIndexesPage().markStale();
            }
        }
    }

    private boolean alterTypeMentionsInOtherTypes(String oldTypeName, String newTypeName) {
        TypeSystemDescription typeSystem = this.getMergedTypeSystemDescription();
        boolean refreshNeeded = false;
        boolean remergeNeeded = false;
        TypeDescription[] types = typeSystem.getTypes();
        for (int i = 0; i < types.length; ++i) {
            FeatureDescription[] localFds;
            TypeDescription td = types[i];
            TypeDescription localTd = this.getLocalTypeDefinition(td);
            String typeName = td.getName();
            if (td.getSupertypeName().equals(oldTypeName)) {
                if (null != localTd) {
                    if (this.isImportedType(typeName)) {
                        Utility.popMessage("Imported type won't be changed", "There is both a local and imported version of type, '" + typeName + "', which has a supertype which is the item being renamed.  Although the local version will be updated, but the imported one won't.This may cause an error when you save.", 4);
                    }
                    if (this.isBuiltInType(typeName)) {
                        throw new InternalErrorCDE("invalid state");
                    }
                } else {
                    Utility.popMessage("Imported type not changed", "There is an imported type, '" + typeName + "', which has a supertype which is the item being renamed.  It won't be updated - this may cause an error when you save this descriptor.  If it does, you will need to edit the imported type to change it.", 4);
                    continue;
                }
                localTd.setSupertypeName(newTypeName);
                if (this.isImportedType(typeName)) {
                    remergeNeeded = true;
                    refreshNeeded = true;
                } else {
                    td.setSupertypeName(newTypeName);
                    this.updateGuiType(this.tt.getItems()[i], td);
                }
            }
            FeatureDescription[] fds = td.getFeatures();
            FeatureDescription[] featureDescriptionArray = localFds = null == localTd ? null : localTd.getFeatures();
            if (null == fds) continue;
            for (int j = 0; j < fds.length; ++j) {
                FeatureDescription fd = fds[j];
                if (!oldTypeName.equals(fd.getRangeTypeName()) || this.warnAndSkipIfImported(typeName)) continue;
                this.setNamedFeatureDescriptionRange(localFds, fd.getName(), newTypeName);
                if (this.isImportedType(typeName)) {
                    remergeNeeded = true;
                    refreshNeeded = true;
                    continue;
                }
                fd.setRangeTypeName(newTypeName);
                this.updateGuiFeature(this.tt.getItems()[i].getItems()[j], fd, td);
            }
        }
        if (remergeNeeded) {
            this.rebuildMergedTypeSystem();
        }
        return refreshNeeded;
    }

    private void setNamedFeatureDescriptionRange(FeatureDescription[] localFds, String featureName, String rangeName) {
        if (null != localFds) {
            for (int i = 0; i < localFds.length; ++i) {
                FeatureDescription fd = localFds[i];
                if (!fd.getName().equals(featureName)) continue;
                fd.setRangeTypeName(rangeName);
                return;
            }
        }
    }

    private boolean warnAndSkipIfImported(String typeName) {
        if (this.isLocalType(typeName)) {
            if (this.isImportedType(typeName)) {
                Utility.popMessage("Imported type won't be changed", "There is both a local and imported version of type, '" + typeName + "', which has a feature whose range type is the item being renamed.  Although the local version will be updated, but the imported one won't.This may cause an error when you save.", 4);
            }
            return false;
        }
        Utility.popMessage("Imported feature range not changed", "There is an imported type, '" + typeName + "', which has a a feature whose range which is the item being renamed.  It won't be updated - this may cause an error when you save this descriptor.  If it does, you will need to edit the imported type to change it.", 4);
        return true;
    }

    private void alterTypeMentions(final String sOldTypeName, final String sNewTypeName) {
        FsIndexCollection indexCollection;
        if (sOldTypeName.equals(sNewTypeName) || !this.isLocalProcessingDescriptor()) {
            return;
        }
        final boolean[] capabilityChanged = new boolean[]{false};
        final String oldTypeName_colon = sOldTypeName + ':';
        CapabilityVisitor cv = new CapabilityVisitor(){

            @Override
            boolean visit(TypeOrFeature i_o) {
                if (i_o.isType() && i_o.getName().equals(sOldTypeName)) {
                    capabilityChanged[0] = true;
                    i_o.setName(sNewTypeName);
                } else if (!i_o.isType() && i_o.getName().startsWith(oldTypeName_colon)) {
                    capabilityChanged[0] = true;
                    i_o.setName(sNewTypeName + ':' + i_o.getName().substring(oldTypeName_colon.length()));
                }
                return false;
            }
        };
        this.capabilityVisit(cv);
        if (capabilityChanged[0] && null != this.editor.getCapabilityPage()) {
            this.editor.getCapabilityPage().markStale();
        }
        FsIndexDescription[] indexes = null == (indexCollection = this.getAnalysisEngineMetaData().getFsIndexCollection()) ? null : indexCollection.getFsIndexes();
        boolean somethingChanged = false;
        boolean markStale = false;
        if (indexes != null) {
            for (int i = 0; i < indexes.length; ++i) {
                if (!indexes[i].getTypeName().equals(sOldTypeName)) continue;
                indexes[i].setTypeName(sNewTypeName);
                somethingChanged = true;
            }
        }
        if (somethingChanged) {
            markStale = true;
            try {
                this.editor.setMergedFsIndexCollection();
            }
            catch (ResourceInitializationException e) {
                throw new InternalErrorCDE("unexpected exception");
            }
        }
        if (this.typePriorityListsVisit(4, sOldTypeName, sNewTypeName)) {
            markStale = true;
            try {
                this.editor.setMergedTypePriorities();
            }
            catch (ResourceInitializationException e) {
                throw new InternalErrorCDE("unexpected exception");
            }
        }
        if (markStale) {
            this.editor.getIndexesPage().markStale();
        }
    }

    private boolean isFeatureUsedInIndex(TypeDescription td, String featureName) {
        return this.isFeatureUsedInIndex(td.getName() + ":" + featureName);
    }

    private boolean isFeatureUsedInIndex(String fullFeatureName) {
        FsIndexDescription[] fsid;
        if (!this.isLocalProcessingDescriptor()) {
            return false;
        }
        FsIndexCollection indexCollection = this.editor.getMergedFsIndexCollection();
        FsIndexDescription[] fsIndexDescriptionArray = fsid = null == indexCollection ? null : indexCollection.getFsIndexes();
        if (null != fsid) {
            for (int i = 0; i < fsid.length; ++i) {
                FsIndexKeyDescription[] keys = fsid[i].getKeys();
                if (null == keys) continue;
                for (int j = 0; j < keys.length; ++j) {
                    if (!keys[j].getFeatureName().equals(fullFeatureName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isFeatureInUseElsewhere(TypeDescription td, String featureName) {
        return this.isFeatureInUseElsewhere(td.getName() + ':' + featureName);
    }

    private boolean isFeatureInUseElsewhere(final String typePlusFeature) {
        if (!this.isLocalProcessingDescriptor()) {
            return false;
        }
        CapabilityVisitor v = new CapabilityVisitor(){

            @Override
            boolean visit(TypeOrFeature i_o) {
                return !i_o.isType() && i_o.getName().equals(typePlusFeature);
            }
        };
        if (this.capabilityVisit(v)) {
            return true;
        }
        return this.isFeatureUsedInIndex(typePlusFeature);
    }

    private boolean capabilityVisit(CapabilityVisitor v) {
        Capability[] c = this.getCapabilities();
        for (int ic = 0; ic < c.length; ++ic) {
            TypeOrFeature[] inputs = c[ic].getInputs();
            for (int i = 0; i < inputs.length; ++i) {
                if (!v.visit(inputs[i])) continue;
                return true;
            }
            TypeOrFeature[] outputs = c[ic].getOutputs();
            for (int i = 0; i < outputs.length; ++i) {
                if (!v.visit(outputs[i])) continue;
                return true;
            }
        }
        return false;
    }

    private void alterFeatureMentions(String sOldFeatureName, String sNewFeatureName, String typeName) {
        final boolean[] somethingChanged = new boolean[]{false};
        if (sOldFeatureName.equals(sNewFeatureName) || !this.isLocalProcessingDescriptor()) {
            return;
        }
        final String oldFullFeatureName = typeName + ':' + sOldFeatureName;
        final String newFullFeatureName = typeName + ':' + sNewFeatureName;
        CapabilityVisitor v = new CapabilityVisitor(){

            @Override
            boolean visit(TypeOrFeature i_o) {
                if (!i_o.isType() && i_o.getName().equals(oldFullFeatureName)) {
                    somethingChanged[0] = true;
                    i_o.setName(newFullFeatureName);
                }
                return false;
            }
        };
        this.capabilityVisit(v);
        if (somethingChanged[0] && null != this.editor.getCapabilityPage()) {
            this.editor.getCapabilityPage().markStale();
        }
        somethingChanged[0] = false;
        FsIndexDescription[] fsid = this.getAnalysisEngineMetaData().getFsIndexes();
        if (null != fsid) {
            for (int i = 0; i < fsid.length; ++i) {
                FsIndexKeyDescription[] keys;
                if (!typeName.equals(fsid[i].getTypeName()) || null == (keys = fsid[i].getKeys())) continue;
                for (int j = 0; j < keys.length; ++j) {
                    if (!keys[j].getFeatureName().equals(sOldFeatureName)) continue;
                    somethingChanged[0] = true;
                    keys[j].setFeatureName(sNewFeatureName);
                }
            }
        }
        if (somethingChanged[0]) {
            try {
                this.editor.setMergedFsIndexCollection();
            }
            catch (ResourceInitializationException e) {
                e.printStackTrace();
            }
            if (null != this.editor.getIndexesPage()) {
                this.editor.getIndexesPage().markStale();
            }
        }
    }

    private abstract class CapabilityVisitor {
        private CapabilityVisitor() {
        }

        abstract boolean visit(TypeOrFeature var1);
    }

    private static class TypeFeature {
        String typeName;
        String featureName;

        TypeFeature(String type, String feat) {
            this.typeName = type;
            this.featureName = feat;
        }
    }
}

