/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import java.util.ArrayList;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.learner.trabal.AnnotationErrorType;
import org.apache.uima.ruta.textruler.learner.trabal.Condition;
import org.apache.uima.ruta.textruler.learner.trabal.ConditionType;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalAnnotation;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalLearner;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRule;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRuleItem;

public abstract class ShiftingRule
extends TrabalRule {
    protected TrabalRuleItem frontBoundaryItem;
    protected TrabalRuleItem rearBoundaryItem;

    public ShiftingRule(TrabalLearner parentAlgorithm, TextRulerTarget target, TrabalAnnotation annotation, TrabalAnnotation targetAnnotation, AnnotationErrorType errorType) {
        super(parentAlgorithm, target);
        this.annotation = annotation;
        this.targetAnnotation = targetAnnotation;
        this.errorType = errorType;
        this.addConditionTypes();
    }

    public ShiftingRule(ShiftingRule copyFrom) {
        super((TrabalLearner)copyFrom.algorithm, copyFrom.target);
        this.annotation = copyFrom.annotation;
        this.targetAnnotation = copyFrom.targetAnnotation;
        this.errorType = copyFrom.errorType;
        this.frontBoundaryItem = copyFrom.frontBoundaryItem;
        this.rearBoundaryItem = copyFrom.rearBoundaryItem;
        this.conditions = new ArrayList();
        for (Condition c : copyFrom.conditions) {
            this.conditions.add(c.clone());
        }
        this.addConditionTypes();
    }

    protected void addConditionTypes() {
        this.conditionTypes = new ArrayList();
        this.conditionTypes.add(ConditionType.STARTSWITH);
        this.conditionTypes.add(ConditionType.ENDSWITH);
        this.conditionTypes.add(ConditionType.CONTAINS);
        this.conditionTypes.add(ConditionType.PARTOF);
    }

    @Override
    public boolean contains(TrabalAnnotation target) {
        if (target != null) {
            if (this.annotation.getType().getShortName().equals(target.getType().getShortName())) {
                return true;
            }
            if (this.targetAnnotation.getType().getShortName().equals(target.getType().getShortName())) {
                return true;
            }
            if (this.frontBoundaryItem != null && this.frontBoundaryItem.getAnnotation().equals(target)) {
                return true;
            }
            if (this.rearBoundaryItem != null && this.rearBoundaryItem.getAnnotation().equals(target)) {
                return true;
            }
            for (Condition each : this.getConditions()) {
                if (!each.getItem().getAnnotation().getType().getShortName().equals(target.getType().getShortName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSameBasicRule(TrabalRule rule) {
        if (rule.getAnnotation() == null) {
            return false;
        }
        if (!rule.getAnnotation().getType().equals(this.annotation.getType())) {
            return false;
        }
        if (rule.getTargetAnnotation() == null) {
            return false;
        }
        return rule.getTargetAnnotation().getType().equals(this.targetAnnotation.getType());
    }

    @Override
    public TrabalRuleItem getFrontBoundary() {
        if (this.annotation.getBegin() == this.targetAnnotation.getBegin()) {
            return new TrabalRuleItem(this.annotation);
        }
        return this.frontBoundaryItem;
    }

    @Override
    public TrabalRuleItem getRearBoundary() {
        if (this.annotation.getEnd() == this.targetAnnotation.getEnd()) {
            return new TrabalRuleItem(this.annotation);
        }
        return this.rearBoundaryItem;
    }

    public void setFrontBoundaryItem(TrabalRuleItem frontBoundaryItem) {
        this.frontBoundaryItem = frontBoundaryItem;
    }

    public void setRearBoundaryItem(TrabalRuleItem rearBoundaryItem) {
        this.rearBoundaryItem = rearBoundaryItem;
    }
}

