/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.formatter;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.ide.core.parser.RutaSourceParser;
import org.apache.uima.ruta.ide.formatter.RutaFormattedPrinter;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.formatter.AbstractScriptFormatter;
import org.eclipse.dltk.formatter.FormatterDocument;
import org.eclipse.dltk.ui.formatter.FormatterException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RutaFormatter
extends AbstractScriptFormatter {
    protected static final String[] INDENTING = new String[]{"indent.block", "indent.structure"};
    private final String lineDelimiter;

    public RutaFormatter(String lineDelimiter, Map preferences) {
        super(preferences);
        this.lineDelimiter = lineDelimiter;
    }

    public TextEdit format(String source, int offset, int length, int indent) throws FormatterException {
        String input = source;
        if (StringUtils.isEmpty((CharSequence)input)) {
            return null;
        }
        RutaSourceParser tmsp = new RutaSourceParser();
        DummyReporter reporter = new DummyReporter();
        IModuleDeclaration md = tmsp.parse("format.ruta", source, (IProblemReporter)reporter);
        CommonTokenStream tokenStream = tmsp.getTokenStream();
        if (!reporter.gotProblems()) {
            BitSet bs = new BitSet();
            bs.add(88);
            bs.add(30);
            List comments = tokenStream.getTokens(0, tokenStream.size(), bs);
            String output = this.format(input, (ModuleDeclaration)md, comments, indent);
            if (output != null) {
                if (!input.equals(output)) {
                    return new ReplaceEdit(0, source.length(), output);
                }
                return new MultiTextEdit();
            }
        }
        return null;
    }

    private String format(String input, ModuleDeclaration md, List<CommonToken> comments, int indent) {
        FormatterDocument document = this.createDocument(input);
        RutaFormattedPrinter tmfp = new RutaFormattedPrinter(document, this.lineDelimiter, this.createIndentGenerator(), comments, this);
        try {
            md.traverse((ASTVisitor)tmfp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tmfp.getOutput();
    }

    private FormatterDocument createDocument(String input) {
        FormatterDocument document = new FormatterDocument(input);
        for (int i = 0; i < INDENTING.length; ++i) {
            document.setBoolean(INDENTING[i], this.getBoolean(INDENTING[i]));
        }
        document.setInt("formatter.tabulation.size", this.getInt("formatter.tabulation.size"));
        return document;
    }

    private boolean equalsIgnoreBlanks(Reader inputReader, Reader outputReader) {
        String outputLine;
        String inputLine;
        LineNumberReader input = new LineNumberReader(inputReader);
        LineNumberReader output = new LineNumberReader(outputReader);
        do {
            inputLine = this.readLine(input);
            outputLine = this.readLine(output);
            if (inputLine == null) {
                return outputLine == null;
            }
            if (outputLine != null) continue;
            return false;
        } while (inputLine.equals(outputLine));
        return false;
    }

    private String readLine(LineNumberReader reader) {
        String line;
        do {
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                return null;
            }
            if (line != null) continue;
            return line;
        } while ((line = line.trim()).length() == 0);
        return line;
    }

    public int getInt(String key) {
        return super.getInt(key);
    }

    protected boolean getBoolean(String key) {
        return super.getBoolean(key);
    }

    protected String getString(String key) {
        return super.getString(key);
    }

    class DummyReporter
    implements IProblemReporter {
        private boolean gotProblems = false;

        DummyReporter() {
        }

        public void reportProblem(IProblem problem) {
            this.setProblems(true);
        }

        public void setProblems(boolean gotProblems) {
            this.gotProblems = gotProblems;
        }

        public boolean gotProblems() {
            return this.gotProblems;
        }
    }
}

