/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValueHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public class RangeGlobalStepPlaceholder<S>
extends FilterStep<S>
implements RangeGlobalStepContract<S>,
GValueHolder<S, S> {
    protected GValue<Long> low;
    protected GValue<Long> high;
    private boolean bypass = false;

    public RangeGlobalStepPlaceholder(Traversal.Admin traversal, GValue<Long> low, GValue<Long> high) {
        super(traversal);
        if (null == low || null == high) {
            throw new IllegalArgumentException("RangeGlobalStepPlaceholder requires both low and high values to be non-null");
        }
        this.low = low;
        this.high = high;
        traversal.getGValueManager().register(low);
        traversal.getGValueManager().register(high);
    }

    @Override
    public boolean isParameterized() {
        return this.low.isVariable() || this.high.isVariable();
    }

    @Override
    public void updateVariable(String name, Object value) {
        if (name.equals(this.low.getName())) {
            if (!(value instanceof Number)) {
                throw new IllegalArgumentException("The variable " + name + " must have a value of type Number");
            }
            this.low = GValue.ofLong(name, ((Number)value).longValue());
        }
        if (name.equals(this.high.getName())) {
            if (!(value instanceof Number)) {
                throw new IllegalArgumentException("The variable " + name + " must have a value of type Number");
            }
            this.high = GValue.ofLong(name, ((Number)value).longValue());
        }
    }

    @Override
    public Long getLowRange() {
        if (this.low.isVariable()) {
            this.traversal.getGValueManager().pinVariable(this.low.getName());
        }
        return this.low.get();
    }

    @Override
    public Long getHighRange() {
        if (this.high.isVariable()) {
            this.traversal.getGValueManager().pinVariable(this.high.getName());
        }
        return this.high.get();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RangeGlobalStepPlaceholder that = (RangeGlobalStepPlaceholder)o;
        return Objects.equals(this.low, that.low) && Objects.equals(this.high, that.high);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.low, this.high);
    }

    @Override
    public GValue<Long> getLowRangeAsGValue() {
        return this.low;
    }

    @Override
    public GValue<Long> getHighRangeAsGValue() {
        return this.high;
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        throw new IllegalStateException("RangeGlobalStepPlaceholder is not executable");
    }

    @Override
    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public void processAllStarts() {
        throw new IllegalStateException("RangeGlobalStepPlaceholder is not executable");
    }

    @Override
    public Collection<GValue<?>> getGValues() {
        HashSet gValues = new HashSet();
        if (this.low.isVariable()) {
            gValues.add(this.low);
        }
        if (this.high.isVariable()) {
            gValues.add(this.high);
        }
        return gValues;
    }

    public RangeGlobalStep<S> asConcreteStep() {
        RangeGlobalStep step = new RangeGlobalStep(this.traversal, this.low.get(), this.high.get());
        TraversalHelper.copyLabels(this, step, false);
        step.setBypass(this.bypass);
        return step;
    }

    @Override
    public RangeGlobalStepPlaceholder<S> clone() {
        RangeGlobalStepPlaceholder clone = (RangeGlobalStepPlaceholder)super.clone();
        clone.bypass = this.bypass;
        clone.low = this.low.clone();
        clone.high = this.high.clone();
        return clone;
    }
}

