/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.GValueReductionStrategy;
import org.apache.tinkerpop.gremlin.util.GremlinDisabledListDelimiterHandler;

public interface TraversalStrategy<S extends TraversalStrategy>
extends Serializable,
Comparable<Class<? extends TraversalStrategy>> {
    public void apply(Traversal.Admin<?, ?> var1);

    default public Set<Class<? extends S>> applyPrior() {
        return Collections.emptySet();
    }

    default public Set<Class<? extends S>> applyPost() {
        return Collections.emptySet();
    }

    default public Class<S> getTraversalCategory() {
        return TraversalStrategy.class;
    }

    default public Configuration getConfiguration() {
        BaseConfiguration conf = new BaseConfiguration();
        conf.setListDelimiterHandler((ListDelimiterHandler)GremlinDisabledListDelimiterHandler.instance());
        return conf;
    }

    @Override
    default public int compareTo(Class<? extends TraversalStrategy> otherTraversalCategory) {
        return 0;
    }

    public static interface VerificationStrategy
    extends TraversalStrategy<VerificationStrategy> {
        @Override
        default public Class<VerificationStrategy> getTraversalCategory() {
            return VerificationStrategy.class;
        }

        @Override
        default public int compareTo(Class<? extends TraversalStrategy> otherTraversalCategory) {
            if (otherTraversalCategory.equals(DecorationStrategy.class)) {
                return 1;
            }
            if (otherTraversalCategory.equals(OptimizationStrategy.class)) {
                return 1;
            }
            if (otherTraversalCategory.equals(ProviderOptimizationStrategy.class)) {
                return 1;
            }
            if (otherTraversalCategory.equals(FinalizationStrategy.class)) {
                return 1;
            }
            return 0;
        }
    }

    public static interface FinalizationStrategy
    extends TraversalStrategy<FinalizationStrategy> {
        @Override
        default public Class<FinalizationStrategy> getTraversalCategory() {
            return FinalizationStrategy.class;
        }

        @Override
        default public int compareTo(Class<? extends TraversalStrategy> otherTraversalCategory) {
            if (otherTraversalCategory.equals(DecorationStrategy.class)) {
                return 1;
            }
            if (otherTraversalCategory.equals(OptimizationStrategy.class)) {
                return 1;
            }
            if (otherTraversalCategory.equals(ProviderOptimizationStrategy.class)) {
                return 1;
            }
            if (otherTraversalCategory.equals(FinalizationStrategy.class)) {
                return 0;
            }
            if (otherTraversalCategory.equals(VerificationStrategy.class)) {
                return -1;
            }
            return 0;
        }
    }

    public static interface ProviderOptimizationStrategy
    extends TraversalStrategy<ProviderOptimizationStrategy> {
        @Override
        default public Class<ProviderOptimizationStrategy> getTraversalCategory() {
            return ProviderOptimizationStrategy.class;
        }

        @Override
        default public int compareTo(Class<? extends TraversalStrategy> otherTraversalCategory) {
            if (otherTraversalCategory.equals(DecorationStrategy.class)) {
                return 1;
            }
            if (otherTraversalCategory.equals(OptimizationStrategy.class)) {
                return 1;
            }
            if (otherTraversalCategory.equals(ProviderOptimizationStrategy.class)) {
                return 0;
            }
            if (otherTraversalCategory.equals(FinalizationStrategy.class)) {
                return -1;
            }
            if (otherTraversalCategory.equals(VerificationStrategy.class)) {
                return -1;
            }
            return 0;
        }
    }

    public static interface OptimizationStrategy
    extends TraversalStrategy<OptimizationStrategy> {
        @Override
        default public Class<OptimizationStrategy> getTraversalCategory() {
            return OptimizationStrategy.class;
        }

        @Override
        default public int compareTo(Class<? extends TraversalStrategy> otherTraversalCategory) {
            if (otherTraversalCategory.equals(DecorationStrategy.class)) {
                return 1;
            }
            if (otherTraversalCategory.equals(OptimizationStrategy.class)) {
                return 0;
            }
            if (otherTraversalCategory.equals(ProviderOptimizationStrategy.class)) {
                return -1;
            }
            if (otherTraversalCategory.equals(FinalizationStrategy.class)) {
                return -1;
            }
            if (otherTraversalCategory.equals(VerificationStrategy.class)) {
                return -1;
            }
            return 0;
        }

        @Override
        default public Set<Class<? extends OptimizationStrategy>> applyPost() {
            HashSet<Class<? extends OptimizationStrategy>> set = new HashSet<Class<? extends OptimizationStrategy>>();
            set.add(GValueReductionStrategy.class);
            return set;
        }
    }

    public static interface DecorationStrategy
    extends TraversalStrategy<DecorationStrategy> {
        @Override
        default public Class<DecorationStrategy> getTraversalCategory() {
            return DecorationStrategy.class;
        }

        @Override
        default public int compareTo(Class<? extends TraversalStrategy> otherTraversalCategory) {
            if (otherTraversalCategory.equals(DecorationStrategy.class)) {
                return 0;
            }
            if (otherTraversalCategory.equals(OptimizationStrategy.class)) {
                return -1;
            }
            if (otherTraversalCategory.equals(ProviderOptimizationStrategy.class)) {
                return -1;
            }
            if (otherTraversalCategory.equals(FinalizationStrategy.class)) {
                return -1;
            }
            if (otherTraversalCategory.equals(VerificationStrategy.class)) {
                return -1;
            }
            return 0;
        }
    }
}

