/*
 * Decompiled with CFR 0.152.
 */
package org.json4s;

import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.ParserUtil;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class ParserUtil$ {
    public static final ParserUtil$ MODULE$;
    public final char org$json4s$ParserUtil$$EOF;
    private final CharsetEncoder AsciiEncoder;
    private final BigDecimal BrokenDouble;

    static {
        new ParserUtil$();
    }

    public String quote(String s2, Formats formats) {
        return this.quote(s2, new ParserUtil.StringBuilderAppender(new StringBuilder()), formats).toString();
    }

    public Writer quote(String s2, Writer writer, Formats formats) {
        return this.quote(s2, new ParserUtil.StringWriterAppender(writer), formats);
    }

    private <T> T quote(String s2, ParserUtil.StringAppender<T> appender, Formats formats) {
        int l = s2.length();
        block9: for (int i = 0; i < l; ++i) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s2), i);
            switch (c) {
                default: {
                    T t;
                    boolean shouldEscape;
                    boolean bl = formats.alwaysEscapeUnicode() ? !this.AsciiEncoder.canEncode(c) : (shouldEscape = c >= '\u0000' && c <= '\u001f' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100');
                    if (shouldEscape) {
                        t = appender.append(new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)})));
                        continue block9;
                    }
                    t = appender.append(((Object)BoxesRunTime.boxToCharacter((char)c)).toString());
                    continue block9;
                }
                case '\t': {
                    T t = appender.append("\\t");
                    continue block9;
                }
                case '\r': {
                    T t = appender.append("\\r");
                    continue block9;
                }
                case '\n': {
                    T t = appender.append("\\n");
                    continue block9;
                }
                case '\f': {
                    T t = appender.append("\\f");
                    continue block9;
                }
                case '\b': {
                    T t = appender.append("\\b");
                    continue block9;
                }
                case '\\': {
                    T t = appender.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    T t = appender.append("\\\"");
                }
            }
        }
        return appender.subj();
    }

    public Formats quote$default$2(String s2) {
        return DefaultFormats$.MODULE$;
    }

    public String unquote(String string) {
        return this.unquote(new ParserUtil.Buffer(new StringReader(string), false));
    }

    public String unquote(ParserUtil.Buffer buf) {
        buf.eofIsFailure_$eq(true);
        buf.mark();
        char c = buf.next();
        while (c != '\"') {
            if (c == '\\') {
                String s2 = this.unquote0$1(buf, buf.substring());
                buf.eofIsFailure_$eq(false);
                return s2;
            }
            c = buf.next();
        }
        buf.eofIsFailure_$eq(false);
        return buf.substring();
    }

    public double parseDouble(String s2) {
        BigDecimal d;
        BigDecimal bigDecimal = d = scala.package$.MODULE$.BigDecimal().apply(s2);
        BigDecimal bigDecimal2 = this.BrokenDouble;
        if (!(bigDecimal != null ? !bigDecimal.equals(bigDecimal2) : bigDecimal2 != null)) {
            throw package$.MODULE$.error("Error parsing 2.2250738585072012e-308");
        }
        return d.doubleValue();
    }

    private final String unquote0$1(ParserUtil.Buffer buf, String base) {
        java.lang.StringBuilder s2 = new java.lang.StringBuilder(base);
        char c = '\\';
        while (c != '\"') {
            java.lang.StringBuilder stringBuilder;
            if (c == '\\') {
                char c2 = buf.next();
                switch (c2) {
                    default: {
                        stringBuilder = s2.append('\\');
                        break;
                    }
                    case 'u': {
                        char[] chars = new char[]{buf.next(), buf.next(), buf.next(), buf.next()};
                        int codePoint = Integer.parseInt(new String(chars), 16);
                        stringBuilder = s2.appendCodePoint(codePoint);
                        break;
                    }
                    case 't': {
                        stringBuilder = s2.append('\t');
                        break;
                    }
                    case 'r': {
                        stringBuilder = s2.append('\r');
                        break;
                    }
                    case 'n': {
                        stringBuilder = s2.append('\n');
                        break;
                    }
                    case 'f': {
                        stringBuilder = s2.append('\f');
                        break;
                    }
                    case 'b': {
                        stringBuilder = s2.append('\b');
                        break;
                    }
                    case '/': {
                        stringBuilder = s2.append('/');
                        break;
                    }
                    case '\\': {
                        stringBuilder = s2.append('\\');
                        break;
                    }
                    case '\"': {
                        stringBuilder = s2.append('\"');
                        break;
                    }
                }
            } else {
                stringBuilder = s2.append(c);
            }
            c = buf.next();
        }
        return s2.toString();
    }

    private ParserUtil$() {
        MODULE$ = this;
        this.org$json4s$ParserUtil$$EOF = (char)-1;
        this.AsciiEncoder = Charset.forName("US-ASCII").newEncoder();
        this.BrokenDouble = scala.package$.MODULE$.BigDecimal().apply("2.2250738585072012e-308");
    }
}

