/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config;

import java.math.BigInteger;

public final class ConfigMemorySize {
    private BigInteger bytes;

    private ConfigMemorySize(BigInteger bytes2) {
        if (bytes2.signum() < 0) {
            throw new IllegalArgumentException("Attempt to construct ConfigMemorySize with negative number: " + bytes2);
        }
        this.bytes = bytes2;
    }

    public static ConfigMemorySize ofBytes(BigInteger bytes2) {
        return new ConfigMemorySize(bytes2);
    }

    public static ConfigMemorySize ofBytes(long bytes2) {
        return new ConfigMemorySize(BigInteger.valueOf(bytes2));
    }

    public long toBytes() {
        if (this.bytes.bitLength() < 64) {
            return this.bytes.longValue();
        }
        throw new IllegalArgumentException("size-in-bytes value is out of range for a 64-bit long: '" + this.bytes + "'");
    }

    public BigInteger toBytesBigInteger() {
        return this.bytes;
    }

    public String toString() {
        return "ConfigMemorySize(" + this.bytes + ")";
    }

    public boolean equals(Object other) {
        if (other instanceof ConfigMemorySize) {
            return ((ConfigMemorySize)other).bytes.equals(this.bytes);
        }
        return false;
    }

    public int hashCode() {
        return this.bytes.hashCode();
    }
}

