/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics;

import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.Aggregation;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.View;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;

public final class ViewBuilder {
    @Nullable
    private String name;
    @Nullable
    private String description;
    private Aggregation aggregation = Aggregation.defaultAggregation();
    private AttributesProcessor processor = AttributesProcessor.noop();

    ViewBuilder() {
    }

    public ViewBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ViewBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ViewBuilder setAggregation(Aggregation aggregation) {
        if (!(aggregation instanceof AggregatorFactory)) {
            throw new IllegalArgumentException("Custom Aggregation implementations are currently not supported. Use one of the standard implementations returned by the static factories in the Aggregation class.");
        }
        this.aggregation = aggregation;
        return this;
    }

    public ViewBuilder setAttributeFilter(Predicate<String> keyFilter) {
        Objects.requireNonNull(keyFilter, "keyFilter");
        return this.addAttributesProcessor(AttributesProcessor.filterByKeyName(keyFilter));
    }

    ViewBuilder addAttributesProcessor(AttributesProcessor attributesProcessor) {
        this.processor = this.processor.then(attributesProcessor);
        return this;
    }

    public View build() {
        return View.create(this.name, this.description, this.aggregation, this.processor);
    }
}

