/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.ch.qos.logback.core.model.processor;

import javax.naming.NamingException;
import org.apache.rocketmq.shaded.ch.qos.logback.core.Context;
import org.apache.rocketmq.shaded.ch.qos.logback.core.joran.action.ActionUtil;
import org.apache.rocketmq.shaded.ch.qos.logback.core.model.InsertFromJNDIModel;
import org.apache.rocketmq.shaded.ch.qos.logback.core.model.Model;
import org.apache.rocketmq.shaded.ch.qos.logback.core.model.ModelUtil;
import org.apache.rocketmq.shaded.ch.qos.logback.core.model.processor.ModelHandlerBase;
import org.apache.rocketmq.shaded.ch.qos.logback.core.model.processor.ModelHandlerException;
import org.apache.rocketmq.shaded.ch.qos.logback.core.model.processor.ModelInterpretationContext;
import org.apache.rocketmq.shaded.ch.qos.logback.core.util.JNDIUtil;
import org.apache.rocketmq.shaded.ch.qos.logback.core.util.OptionHelper;

public class InsertFromJNDIModelHandler
extends ModelHandlerBase {
    public InsertFromJNDIModelHandler(Context context) {
        super(context);
    }

    public static ModelHandlerBase makeInstance(Context context, ModelInterpretationContext ic) {
        return new InsertFromJNDIModelHandler(context);
    }

    protected Class<InsertFromJNDIModel> getSupportedModelClass() {
        return InsertFromJNDIModel.class;
    }

    @Override
    public void handle(ModelInterpretationContext mic, Model model) throws ModelHandlerException {
        int errorCount = 0;
        InsertFromJNDIModel ifjm = (InsertFromJNDIModel)model;
        String envEntryName = mic.subst(ifjm.getEnvEntryName());
        String asKey = mic.subst(ifjm.getAs());
        String scopeStr = mic.subst(ifjm.getScopeStr());
        ActionUtil.Scope scope = ActionUtil.stringToScope(scopeStr);
        if (OptionHelper.isNullOrEmpty(envEntryName)) {
            this.addError("[env-entry-name] missing");
            ++errorCount;
        }
        if (OptionHelper.isNullOrEmpty(asKey)) {
            this.addError("[as] missing");
            ++errorCount;
        }
        if (errorCount != 0) {
            return;
        }
        try {
            javax.naming.Context ctx = JNDIUtil.getInitialContext();
            String envEntryValue = JNDIUtil.lookupString(ctx, envEntryName);
            if (OptionHelper.isNullOrEmpty(envEntryValue)) {
                this.addError("[" + envEntryName + "] has null or empty value");
            } else {
                this.addInfo("Setting variable [" + asKey + "] to [" + envEntryValue + "] in [" + (Object)((Object)scope) + "] scope");
                ModelUtil.setProperty(mic, asKey, envEntryValue, scope);
            }
        }
        catch (NamingException e) {
            this.addError("Failed to lookup JNDI env-entry [" + envEntryName + "]");
        }
    }
}

