/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.metrics;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import org.apache.rocketmq.client.java.metrics.HistogramEnum;
import org.apache.rocketmq.client.java.metrics.Metric;
import org.apache.rocketmq.client.java.misc.ClientId;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.shaded.com.google.common.base.MoreObjects;
import org.apache.rocketmq.shaded.com.google.common.base.Preconditions;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import org.apache.rocketmq.shaded.io.opentelemetry.api.metrics.Meter;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.SdkMeterProvider;
import org.apache.rocketmq.shaded.org.slf4j.Logger;
import org.apache.rocketmq.shaded.org.slf4j.LoggerFactory;

public class ClientMeter {
    private static final Logger log = LoggerFactory.getLogger(ClientMeter.class);
    private final boolean enabled;
    private final Meter meter;
    private final Endpoints endpoints;
    private final SdkMeterProvider provider;
    private final ClientId clientId;
    private final ConcurrentMap<String, DoubleHistogram> histogramMap;

    public ClientMeter(Meter meter, Endpoints endpoints, SdkMeterProvider provider, ClientId clientId) {
        this.enabled = true;
        this.meter = Preconditions.checkNotNull(meter, "meter should not be null");
        this.endpoints = Preconditions.checkNotNull(endpoints, "endpoints should not be null");
        this.provider = Preconditions.checkNotNull(provider, "provider should not be null");
        this.clientId = Preconditions.checkNotNull(clientId, "clientId should not be null");
        this.histogramMap = new ConcurrentHashMap<String, DoubleHistogram>();
    }

    private ClientMeter(ClientId clientId) {
        this.enabled = false;
        this.meter = null;
        this.endpoints = null;
        this.provider = null;
        this.clientId = Preconditions.checkNotNull(clientId, "clientId should not be null");
        this.histogramMap = new ConcurrentHashMap<String, DoubleHistogram>();
    }

    static ClientMeter disabledInstance(ClientId clientId) {
        return new ClientMeter(clientId);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void record(HistogramEnum histogramEnum, Attributes attributes, double value) {
        DoubleHistogram histogram = this.histogramMap.computeIfAbsent(histogramEnum.getName(), name -> this.enabled ? this.meter.histogramBuilder(histogramEnum.getName()).build() : null);
        if (null == histogram) {
            return;
        }
        histogram.record(value, attributes);
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        log.info("Begin to shutdown client meter, clientId={}, endpoints={}", (Object)this.clientId, (Object)this.endpoints);
        CountDownLatch latch = new CountDownLatch(1);
        this.provider.shutdown().whenComplete(latch::countDown);
        try {
            latch.await();
            log.info("Shutdown client meter successfully, clientId={}, endpoints={}", (Object)this.clientId, (Object)this.endpoints);
        }
        catch (Throwable t2) {
            log.error("Failed to shutdown message meter, clientId={}, endpoints={}", this.clientId, this.endpoints, t2);
        }
    }

    public boolean satisfy(Metric metric) {
        if (this.enabled && metric.isOn() && this.endpoints.equals(metric.getEndpoints())) {
            return true;
        }
        return !this.enabled && !metric.isOn();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("enabled", this.enabled).add("meter", this.meter).add("endpoints", this.endpoints).add("provider", this.provider).add("histogramMap", this.histogramMap).toString();
    }
}

