// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v5.29.3
// source: apache/rocketmq/v2/definition.proto

package v2

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type TransactionResolution int32

const (
	TransactionResolution_TRANSACTION_RESOLUTION_UNSPECIFIED TransactionResolution = 0
	TransactionResolution_COMMIT                             TransactionResolution = 1
	TransactionResolution_ROLLBACK                           TransactionResolution = 2
)

// Enum value maps for TransactionResolution.
var (
	TransactionResolution_name = map[int32]string{
		0: "TRANSACTION_RESOLUTION_UNSPECIFIED",
		1: "COMMIT",
		2: "ROLLBACK",
	}
	TransactionResolution_value = map[string]int32{
		"TRANSACTION_RESOLUTION_UNSPECIFIED": 0,
		"COMMIT":                             1,
		"ROLLBACK":                           2,
	}
)

func (x TransactionResolution) Enum() *TransactionResolution {
	p := new(TransactionResolution)
	*p = x
	return p
}

func (x TransactionResolution) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransactionResolution) Descriptor() protoreflect.EnumDescriptor {
	return file_apache_rocketmq_v2_definition_proto_enumTypes[0].Descriptor()
}

func (TransactionResolution) Type() protoreflect.EnumType {
	return &file_apache_rocketmq_v2_definition_proto_enumTypes[0]
}

func (x TransactionResolution) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransactionResolution.Descriptor instead.
func (TransactionResolution) EnumDescriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{0}
}

type TransactionSource int32

const (
	TransactionSource_SOURCE_UNSPECIFIED  TransactionSource = 0
	TransactionSource_SOURCE_CLIENT       TransactionSource = 1
	TransactionSource_SOURCE_SERVER_CHECK TransactionSource = 2
)

// Enum value maps for TransactionSource.
var (
	TransactionSource_name = map[int32]string{
		0: "SOURCE_UNSPECIFIED",
		1: "SOURCE_CLIENT",
		2: "SOURCE_SERVER_CHECK",
	}
	TransactionSource_value = map[string]int32{
		"SOURCE_UNSPECIFIED":  0,
		"SOURCE_CLIENT":       1,
		"SOURCE_SERVER_CHECK": 2,
	}
)

func (x TransactionSource) Enum() *TransactionSource {
	p := new(TransactionSource)
	*p = x
	return p
}

func (x TransactionSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransactionSource) Descriptor() protoreflect.EnumDescriptor {
	return file_apache_rocketmq_v2_definition_proto_enumTypes[1].Descriptor()
}

func (TransactionSource) Type() protoreflect.EnumType {
	return &file_apache_rocketmq_v2_definition_proto_enumTypes[1]
}

func (x TransactionSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransactionSource.Descriptor instead.
func (TransactionSource) EnumDescriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{1}
}

type Permission int32

const (
	Permission_PERMISSION_UNSPECIFIED Permission = 0
	Permission_NONE                   Permission = 1
	Permission_READ                   Permission = 2
	Permission_WRITE                  Permission = 3
	Permission_READ_WRITE             Permission = 4
)

// Enum value maps for Permission.
var (
	Permission_name = map[int32]string{
		0: "PERMISSION_UNSPECIFIED",
		1: "NONE",
		2: "READ",
		3: "WRITE",
		4: "READ_WRITE",
	}
	Permission_value = map[string]int32{
		"PERMISSION_UNSPECIFIED": 0,
		"NONE":                   1,
		"READ":                   2,
		"WRITE":                  3,
		"READ_WRITE":             4,
	}
)

func (x Permission) Enum() *Permission {
	p := new(Permission)
	*p = x
	return p
}

func (x Permission) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Permission) Descriptor() protoreflect.EnumDescriptor {
	return file_apache_rocketmq_v2_definition_proto_enumTypes[2].Descriptor()
}

func (Permission) Type() protoreflect.EnumType {
	return &file_apache_rocketmq_v2_definition_proto_enumTypes[2]
}

func (x Permission) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Permission.Descriptor instead.
func (Permission) EnumDescriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{2}
}

type FilterType int32

const (
	FilterType_FILTER_TYPE_UNSPECIFIED FilterType = 0
	FilterType_TAG                     FilterType = 1
	FilterType_SQL                     FilterType = 2
)

// Enum value maps for FilterType.
var (
	FilterType_name = map[int32]string{
		0: "FILTER_TYPE_UNSPECIFIED",
		1: "TAG",
		2: "SQL",
	}
	FilterType_value = map[string]int32{
		"FILTER_TYPE_UNSPECIFIED": 0,
		"TAG":                     1,
		"SQL":                     2,
	}
)

func (x FilterType) Enum() *FilterType {
	p := new(FilterType)
	*p = x
	return p
}

func (x FilterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FilterType) Descriptor() protoreflect.EnumDescriptor {
	return file_apache_rocketmq_v2_definition_proto_enumTypes[3].Descriptor()
}

func (FilterType) Type() protoreflect.EnumType {
	return &file_apache_rocketmq_v2_definition_proto_enumTypes[3]
}

func (x FilterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FilterType.Descriptor instead.
func (FilterType) EnumDescriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{3}
}

type AddressScheme int32

const (
	AddressScheme_ADDRESS_SCHEME_UNSPECIFIED AddressScheme = 0
	AddressScheme_IPv4                       AddressScheme = 1
	AddressScheme_IPv6                       AddressScheme = 2
	AddressScheme_DOMAIN_NAME                AddressScheme = 3
)

// Enum value maps for AddressScheme.
var (
	AddressScheme_name = map[int32]string{
		0: "ADDRESS_SCHEME_UNSPECIFIED",
		1: "IPv4",
		2: "IPv6",
		3: "DOMAIN_NAME",
	}
	AddressScheme_value = map[string]int32{
		"ADDRESS_SCHEME_UNSPECIFIED": 0,
		"IPv4":                       1,
		"IPv6":                       2,
		"DOMAIN_NAME":                3,
	}
)

func (x AddressScheme) Enum() *AddressScheme {
	p := new(AddressScheme)
	*p = x
	return p
}

func (x AddressScheme) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AddressScheme) Descriptor() protoreflect.EnumDescriptor {
	return file_apache_rocketmq_v2_definition_proto_enumTypes[4].Descriptor()
}

func (AddressScheme) Type() protoreflect.EnumType {
	return &file_apache_rocketmq_v2_definition_proto_enumTypes[4]
}

func (x AddressScheme) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AddressScheme.Descriptor instead.
func (AddressScheme) EnumDescriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{4}
}

type MessageType int32

const (
	MessageType_MESSAGE_TYPE_UNSPECIFIED MessageType = 0
	MessageType_NORMAL                   MessageType = 1
	// Sequenced message
	MessageType_FIFO MessageType = 2
	// Messages that are delivered after the specified duration.
	MessageType_DELAY MessageType = 3
	// Messages that are transactional. Only committed messages are delivered to
	// subscribers.
	MessageType_TRANSACTION MessageType = 4
)

// Enum value maps for MessageType.
var (
	MessageType_name = map[int32]string{
		0: "MESSAGE_TYPE_UNSPECIFIED",
		1: "NORMAL",
		2: "FIFO",
		3: "DELAY",
		4: "TRANSACTION",
	}
	MessageType_value = map[string]int32{
		"MESSAGE_TYPE_UNSPECIFIED": 0,
		"NORMAL":                   1,
		"FIFO":                     2,
		"DELAY":                    3,
		"TRANSACTION":              4,
	}
)

func (x MessageType) Enum() *MessageType {
	p := new(MessageType)
	*p = x
	return p
}

func (x MessageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MessageType) Descriptor() protoreflect.EnumDescriptor {
	return file_apache_rocketmq_v2_definition_proto_enumTypes[5].Descriptor()
}

func (MessageType) Type() protoreflect.EnumType {
	return &file_apache_rocketmq_v2_definition_proto_enumTypes[5]
}

func (x MessageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MessageType.Descriptor instead.
func (MessageType) EnumDescriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{5}
}

type DigestType int32

const (
	DigestType_DIGEST_TYPE_UNSPECIFIED DigestType = 0
	// CRC algorithm achieves goal of detecting random data error with lowest
	// computation overhead.
	DigestType_CRC32 DigestType = 1
	// MD5 algorithm achieves good balance between collision rate and computation
	// overhead.
	DigestType_MD5 DigestType = 2
	// SHA-family has substantially fewer collision with fair amount of
	// computation.
	DigestType_SHA1 DigestType = 3
)

// Enum value maps for DigestType.
var (
	DigestType_name = map[int32]string{
		0: "DIGEST_TYPE_UNSPECIFIED",
		1: "CRC32",
		2: "MD5",
		3: "SHA1",
	}
	DigestType_value = map[string]int32{
		"DIGEST_TYPE_UNSPECIFIED": 0,
		"CRC32":                   1,
		"MD5":                     2,
		"SHA1":                    3,
	}
)

func (x DigestType) Enum() *DigestType {
	p := new(DigestType)
	*p = x
	return p
}

func (x DigestType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DigestType) Descriptor() protoreflect.EnumDescriptor {
	return file_apache_rocketmq_v2_definition_proto_enumTypes[6].Descriptor()
}

func (DigestType) Type() protoreflect.EnumType {
	return &file_apache_rocketmq_v2_definition_proto_enumTypes[6]
}

func (x DigestType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DigestType.Descriptor instead.
func (DigestType) EnumDescriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{6}
}

type ClientType int32

const (
	ClientType_CLIENT_TYPE_UNSPECIFIED ClientType = 0
	ClientType_PRODUCER                ClientType = 1
	ClientType_PUSH_CONSUMER           ClientType = 2
	ClientType_SIMPLE_CONSUMER         ClientType = 3
	ClientType_PULL_CONSUMER           ClientType = 4
)

// Enum value maps for ClientType.
var (
	ClientType_name = map[int32]string{
		0: "CLIENT_TYPE_UNSPECIFIED",
		1: "PRODUCER",
		2: "PUSH_CONSUMER",
		3: "SIMPLE_CONSUMER",
		4: "PULL_CONSUMER",
	}
	ClientType_value = map[string]int32{
		"CLIENT_TYPE_UNSPECIFIED": 0,
		"PRODUCER":                1,
		"PUSH_CONSUMER":           2,
		"SIMPLE_CONSUMER":         3,
		"PULL_CONSUMER":           4,
	}
)

func (x ClientType) Enum() *ClientType {
	p := new(ClientType)
	*p = x
	return p
}

func (x ClientType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ClientType) Descriptor() protoreflect.EnumDescriptor {
	return file_apache_rocketmq_v2_definition_proto_enumTypes[7].Descriptor()
}

func (ClientType) Type() protoreflect.EnumType {
	return &file_apache_rocketmq_v2_definition_proto_enumTypes[7]
}

func (x ClientType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ClientType.Descriptor instead.
func (ClientType) EnumDescriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{7}
}

type Encoding int32

const (
	Encoding_ENCODING_UNSPECIFIED Encoding = 0
	Encoding_IDENTITY             Encoding = 1
	Encoding_GZIP                 Encoding = 2
)

// Enum value maps for Encoding.
var (
	Encoding_name = map[int32]string{
		0: "ENCODING_UNSPECIFIED",
		1: "IDENTITY",
		2: "GZIP",
	}
	Encoding_value = map[string]int32{
		"ENCODING_UNSPECIFIED": 0,
		"IDENTITY":             1,
		"GZIP":                 2,
	}
)

func (x Encoding) Enum() *Encoding {
	p := new(Encoding)
	*p = x
	return p
}

func (x Encoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Encoding) Descriptor() protoreflect.EnumDescriptor {
	return file_apache_rocketmq_v2_definition_proto_enumTypes[8].Descriptor()
}

func (Encoding) Type() protoreflect.EnumType {
	return &file_apache_rocketmq_v2_definition_proto_enumTypes[8]
}

func (x Encoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Encoding.Descriptor instead.
func (Encoding) EnumDescriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{8}
}

type Code int32

const (
	Code_CODE_UNSPECIFIED Code = 0
	// Generic code for success.
	Code_OK Code = 20000
	// Generic code for multiple return results.
	Code_MULTIPLE_RESULTS Code = 30000
	// Generic code for bad request, indicating that required fields or headers are missing.
	Code_BAD_REQUEST Code = 40000
	// Format of access point is illegal.
	Code_ILLEGAL_ACCESS_POINT Code = 40001
	// Format of topic is illegal.
	Code_ILLEGAL_TOPIC Code = 40002
	// Format of consumer group is illegal.
	Code_ILLEGAL_CONSUMER_GROUP Code = 40003
	// Format of message tag is illegal.
	Code_ILLEGAL_MESSAGE_TAG Code = 40004
	// Format of message key is illegal.
	Code_ILLEGAL_MESSAGE_KEY Code = 40005
	// Format of message group is illegal.
	Code_ILLEGAL_MESSAGE_GROUP Code = 40006
	// Format of message property key is illegal.
	Code_ILLEGAL_MESSAGE_PROPERTY_KEY Code = 40007
	// Transaction id is invalid.
	Code_INVALID_TRANSACTION_ID Code = 40008
	// Format of message id is illegal.
	Code_ILLEGAL_MESSAGE_ID Code = 40009
	// Format of filter expression is illegal.
	Code_ILLEGAL_FILTER_EXPRESSION Code = 40010
	// The invisible time of request is invalid.
	Code_ILLEGAL_INVISIBLE_TIME Code = 40011
	// The delivery timestamp of message is invalid.
	Code_ILLEGAL_DELIVERY_TIME Code = 40012
	// Receipt handle of message is invalid.
	Code_INVALID_RECEIPT_HANDLE Code = 40013
	// Message property conflicts with its type.
	Code_MESSAGE_PROPERTY_CONFLICT_WITH_TYPE Code = 40014
	// Client type could not be recognized.
	Code_UNRECOGNIZED_CLIENT_TYPE Code = 40015
	// Message is corrupted.
	Code_MESSAGE_CORRUPTED Code = 40016
	// Request is rejected due to missing of x-mq-client-id header.
	Code_CLIENT_ID_REQUIRED Code = 40017
	// Polling time is illegal.
	Code_ILLEGAL_POLLING_TIME Code = 40018
	// Offset is illegal.
	Code_ILLEGAL_OFFSET Code = 40019
	// Generic code indicates that the client request lacks valid authentication
	// credentials for the requested resource.
	Code_UNAUTHORIZED Code = 40100
	// Generic code indicates that the account is suspended due to overdue of payment.
	Code_PAYMENT_REQUIRED Code = 40200
	// Generic code for the case that user does not have the permission to operate.
	Code_FORBIDDEN Code = 40300
	// Generic code for resource not found.
	Code_NOT_FOUND Code = 40400
	// Message not found from server.
	Code_MESSAGE_NOT_FOUND Code = 40401
	// Topic resource does not exist.
	Code_TOPIC_NOT_FOUND Code = 40402
	// Consumer group resource does not exist.
	Code_CONSUMER_GROUP_NOT_FOUND Code = 40403
	// Offset not found from server.
	Code_OFFSET_NOT_FOUND Code = 40404
	// Generic code representing client side timeout when connecting to, reading data from, or write data to server.
	Code_REQUEST_TIMEOUT Code = 40800
	// Generic code represents that the request entity is larger than limits defined by server.
	Code_PAYLOAD_TOO_LARGE Code = 41300
	// Message body size exceeds the threshold.
	Code_MESSAGE_BODY_TOO_LARGE Code = 41301
	// Message body is empty.
	Code_MESSAGE_BODY_EMPTY Code = 41302
	// Generic code for use cases where pre-conditions are not met.
	// For example, if a producer instance is used to publish messages without prior start() invocation,
	// this error code will be raised.
	Code_PRECONDITION_FAILED Code = 42800
	// Generic code indicates that too many requests are made in short period of duration.
	// Requests are throttled.
	Code_TOO_MANY_REQUESTS Code = 42900
	// Generic code for the case that the server is unwilling to process the request because its header fields are too large.
	// The request may be resubmitted after reducing the size of the request header fields.
	Code_REQUEST_HEADER_FIELDS_TOO_LARGE Code = 43100
	// Message properties total size exceeds the threshold.
	Code_MESSAGE_PROPERTIES_TOO_LARGE Code = 43101
	// Generic code indicates that server/client encountered an unexpected
	// condition that prevented it from fulfilling the request.
	Code_INTERNAL_ERROR Code = 50000
	// Code indicates that the server encountered an unexpected condition
	// that prevented it from fulfilling the request.
	// This error response is a generic "catch-all" response.
	// Usually, this indicates the server cannot find a better alternative
	// error code to response. Sometimes, server administrators log error
	// responses like the 500 status code with more details about the request
	// to prevent the error from happening again in the future.
	//
	// See https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/500
	Code_INTERNAL_SERVER_ERROR Code = 50001
	// The HA-mechanism is not working now.
	Code_HA_NOT_AVAILABLE Code = 50002
	// Generic code means that the server or client does not support the
	// functionality required to fulfill the request.
	Code_NOT_IMPLEMENTED Code = 50100
	// Generic code represents that the server, which acts as a gateway or proxy,
	// does not get an satisfied response in time from its upstream servers.
	// See https://developer.mozilla.org/en-US/docs/Web/HTTP/Status/504
	Code_PROXY_TIMEOUT Code = 50400
	// Message persistence timeout.
	Code_MASTER_PERSISTENCE_TIMEOUT Code = 50401
	// Slave persistence timeout.
	Code_SLAVE_PERSISTENCE_TIMEOUT Code = 50402
	// Generic code for unsupported operation.
	Code_UNSUPPORTED Code = 50500
	// Operation is not allowed in current version.
	Code_VERSION_UNSUPPORTED Code = 50501
	// Not allowed to verify message. Chances are that you are verifying
	// a FIFO message, as is violating FIFO semantics.
	Code_VERIFY_FIFO_MESSAGE_UNSUPPORTED Code = 50502
	// Generic code for failed message consumption.
	Code_FAILED_TO_CONSUME_MESSAGE Code = 60000
)

// Enum value maps for Code.
var (
	Code_name = map[int32]string{
		0:     "CODE_UNSPECIFIED",
		20000: "OK",
		30000: "MULTIPLE_RESULTS",
		40000: "BAD_REQUEST",
		40001: "ILLEGAL_ACCESS_POINT",
		40002: "ILLEGAL_TOPIC",
		40003: "ILLEGAL_CONSUMER_GROUP",
		40004: "ILLEGAL_MESSAGE_TAG",
		40005: "ILLEGAL_MESSAGE_KEY",
		40006: "ILLEGAL_MESSAGE_GROUP",
		40007: "ILLEGAL_MESSAGE_PROPERTY_KEY",
		40008: "INVALID_TRANSACTION_ID",
		40009: "ILLEGAL_MESSAGE_ID",
		40010: "ILLEGAL_FILTER_EXPRESSION",
		40011: "ILLEGAL_INVISIBLE_TIME",
		40012: "ILLEGAL_DELIVERY_TIME",
		40013: "INVALID_RECEIPT_HANDLE",
		40014: "MESSAGE_PROPERTY_CONFLICT_WITH_TYPE",
		40015: "UNRECOGNIZED_CLIENT_TYPE",
		40016: "MESSAGE_CORRUPTED",
		40017: "CLIENT_ID_REQUIRED",
		40018: "ILLEGAL_POLLING_TIME",
		40019: "ILLEGAL_OFFSET",
		40100: "UNAUTHORIZED",
		40200: "PAYMENT_REQUIRED",
		40300: "FORBIDDEN",
		40400: "NOT_FOUND",
		40401: "MESSAGE_NOT_FOUND",
		40402: "TOPIC_NOT_FOUND",
		40403: "CONSUMER_GROUP_NOT_FOUND",
		40404: "OFFSET_NOT_FOUND",
		40800: "REQUEST_TIMEOUT",
		41300: "PAYLOAD_TOO_LARGE",
		41301: "MESSAGE_BODY_TOO_LARGE",
		41302: "MESSAGE_BODY_EMPTY",
		42800: "PRECONDITION_FAILED",
		42900: "TOO_MANY_REQUESTS",
		43100: "REQUEST_HEADER_FIELDS_TOO_LARGE",
		43101: "MESSAGE_PROPERTIES_TOO_LARGE",
		50000: "INTERNAL_ERROR",
		50001: "INTERNAL_SERVER_ERROR",
		50002: "HA_NOT_AVAILABLE",
		50100: "NOT_IMPLEMENTED",
		50400: "PROXY_TIMEOUT",
		50401: "MASTER_PERSISTENCE_TIMEOUT",
		50402: "SLAVE_PERSISTENCE_TIMEOUT",
		50500: "UNSUPPORTED",
		50501: "VERSION_UNSUPPORTED",
		50502: "VERIFY_FIFO_MESSAGE_UNSUPPORTED",
		60000: "FAILED_TO_CONSUME_MESSAGE",
	}
	Code_value = map[string]int32{
		"CODE_UNSPECIFIED":                    0,
		"OK":                                  20000,
		"MULTIPLE_RESULTS":                    30000,
		"BAD_REQUEST":                         40000,
		"ILLEGAL_ACCESS_POINT":                40001,
		"ILLEGAL_TOPIC":                       40002,
		"ILLEGAL_CONSUMER_GROUP":              40003,
		"ILLEGAL_MESSAGE_TAG":                 40004,
		"ILLEGAL_MESSAGE_KEY":                 40005,
		"ILLEGAL_MESSAGE_GROUP":               40006,
		"ILLEGAL_MESSAGE_PROPERTY_KEY":        40007,
		"INVALID_TRANSACTION_ID":              40008,
		"ILLEGAL_MESSAGE_ID":                  40009,
		"ILLEGAL_FILTER_EXPRESSION":           40010,
		"ILLEGAL_INVISIBLE_TIME":              40011,
		"ILLEGAL_DELIVERY_TIME":               40012,
		"INVALID_RECEIPT_HANDLE":              40013,
		"MESSAGE_PROPERTY_CONFLICT_WITH_TYPE": 40014,
		"UNRECOGNIZED_CLIENT_TYPE":            40015,
		"MESSAGE_CORRUPTED":                   40016,
		"CLIENT_ID_REQUIRED":                  40017,
		"ILLEGAL_POLLING_TIME":                40018,
		"ILLEGAL_OFFSET":                      40019,
		"UNAUTHORIZED":                        40100,
		"PAYMENT_REQUIRED":                    40200,
		"FORBIDDEN":                           40300,
		"NOT_FOUND":                           40400,
		"MESSAGE_NOT_FOUND":                   40401,
		"TOPIC_NOT_FOUND":                     40402,
		"CONSUMER_GROUP_NOT_FOUND":            40403,
		"OFFSET_NOT_FOUND":                    40404,
		"REQUEST_TIMEOUT":                     40800,
		"PAYLOAD_TOO_LARGE":                   41300,
		"MESSAGE_BODY_TOO_LARGE":              41301,
		"MESSAGE_BODY_EMPTY":                  41302,
		"PRECONDITION_FAILED":                 42800,
		"TOO_MANY_REQUESTS":                   42900,
		"REQUEST_HEADER_FIELDS_TOO_LARGE":     43100,
		"MESSAGE_PROPERTIES_TOO_LARGE":        43101,
		"INTERNAL_ERROR":                      50000,
		"INTERNAL_SERVER_ERROR":               50001,
		"HA_NOT_AVAILABLE":                    50002,
		"NOT_IMPLEMENTED":                     50100,
		"PROXY_TIMEOUT":                       50400,
		"MASTER_PERSISTENCE_TIMEOUT":          50401,
		"SLAVE_PERSISTENCE_TIMEOUT":           50402,
		"UNSUPPORTED":                         50500,
		"VERSION_UNSUPPORTED":                 50501,
		"VERIFY_FIFO_MESSAGE_UNSUPPORTED":     50502,
		"FAILED_TO_CONSUME_MESSAGE":           60000,
	}
)

func (x Code) Enum() *Code {
	p := new(Code)
	*p = x
	return p
}

func (x Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Code) Descriptor() protoreflect.EnumDescriptor {
	return file_apache_rocketmq_v2_definition_proto_enumTypes[9].Descriptor()
}

func (Code) Type() protoreflect.EnumType {
	return &file_apache_rocketmq_v2_definition_proto_enumTypes[9]
}

func (x Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Code.Descriptor instead.
func (Code) EnumDescriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{9}
}

type Language int32

const (
	Language_LANGUAGE_UNSPECIFIED Language = 0
	Language_JAVA                 Language = 1
	Language_CPP                  Language = 2
	Language_DOT_NET              Language = 3
	Language_GOLANG               Language = 4
	Language_RUST                 Language = 5
	Language_PYTHON               Language = 6
	Language_PHP                  Language = 7
	Language_NODE_JS              Language = 8
	Language_RUBY                 Language = 9
	Language_OBJECTIVE_C          Language = 10
	Language_DART                 Language = 11
	Language_KOTLIN               Language = 12
)

// Enum value maps for Language.
var (
	Language_name = map[int32]string{
		0:  "LANGUAGE_UNSPECIFIED",
		1:  "JAVA",
		2:  "CPP",
		3:  "DOT_NET",
		4:  "GOLANG",
		5:  "RUST",
		6:  "PYTHON",
		7:  "PHP",
		8:  "NODE_JS",
		9:  "RUBY",
		10: "OBJECTIVE_C",
		11: "DART",
		12: "KOTLIN",
	}
	Language_value = map[string]int32{
		"LANGUAGE_UNSPECIFIED": 0,
		"JAVA":                 1,
		"CPP":                  2,
		"DOT_NET":              3,
		"GOLANG":               4,
		"RUST":                 5,
		"PYTHON":               6,
		"PHP":                  7,
		"NODE_JS":              8,
		"RUBY":                 9,
		"OBJECTIVE_C":          10,
		"DART":                 11,
		"KOTLIN":               12,
	}
)

func (x Language) Enum() *Language {
	p := new(Language)
	*p = x
	return p
}

func (x Language) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Language) Descriptor() protoreflect.EnumDescriptor {
	return file_apache_rocketmq_v2_definition_proto_enumTypes[10].Descriptor()
}

func (Language) Type() protoreflect.EnumType {
	return &file_apache_rocketmq_v2_definition_proto_enumTypes[10]
}

func (x Language) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Language.Descriptor instead.
func (Language) EnumDescriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{10}
}

type QueryOffsetPolicy int32

const (
	// Use this option if client wishes to playback all existing messages.
	QueryOffsetPolicy_BEGINNING QueryOffsetPolicy = 0
	// Use this option if client wishes to skip all existing messages.
	QueryOffsetPolicy_END QueryOffsetPolicy = 1
	// Use this option if time-based seek is targeted.
	QueryOffsetPolicy_TIMESTAMP QueryOffsetPolicy = 2
)

// Enum value maps for QueryOffsetPolicy.
var (
	QueryOffsetPolicy_name = map[int32]string{
		0: "BEGINNING",
		1: "END",
		2: "TIMESTAMP",
	}
	QueryOffsetPolicy_value = map[string]int32{
		"BEGINNING": 0,
		"END":       1,
		"TIMESTAMP": 2,
	}
)

func (x QueryOffsetPolicy) Enum() *QueryOffsetPolicy {
	p := new(QueryOffsetPolicy)
	*p = x
	return p
}

func (x QueryOffsetPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QueryOffsetPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_apache_rocketmq_v2_definition_proto_enumTypes[11].Descriptor()
}

func (QueryOffsetPolicy) Type() protoreflect.EnumType {
	return &file_apache_rocketmq_v2_definition_proto_enumTypes[11]
}

func (x QueryOffsetPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QueryOffsetPolicy.Descriptor instead.
func (QueryOffsetPolicy) EnumDescriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{11}
}

type FilterExpression struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          FilterType             `protobuf:"varint,1,opt,name=type,proto3,enum=apache.rocketmq.v2.FilterType" json:"type,omitempty"`
	Expression    string                 `protobuf:"bytes,2,opt,name=expression,proto3" json:"expression,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FilterExpression) Reset() {
	*x = FilterExpression{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FilterExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FilterExpression) ProtoMessage() {}

func (x *FilterExpression) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FilterExpression.ProtoReflect.Descriptor instead.
func (*FilterExpression) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{0}
}

func (x *FilterExpression) GetType() FilterType {
	if x != nil {
		return x.Type
	}
	return FilterType_FILTER_TYPE_UNSPECIFIED
}

func (x *FilterExpression) GetExpression() string {
	if x != nil {
		return x.Expression
	}
	return ""
}

type RetryPolicy struct {
	state       protoimpl.MessageState `protogen:"open.v1"`
	MaxAttempts int32                  `protobuf:"varint,1,opt,name=max_attempts,json=maxAttempts,proto3" json:"max_attempts,omitempty"`
	// Types that are valid to be assigned to Strategy:
	//
	//	*RetryPolicy_ExponentialBackoff
	//	*RetryPolicy_CustomizedBackoff
	Strategy      isRetryPolicy_Strategy `protobuf_oneof:"strategy"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RetryPolicy) Reset() {
	*x = RetryPolicy{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetryPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryPolicy) ProtoMessage() {}

func (x *RetryPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryPolicy.ProtoReflect.Descriptor instead.
func (*RetryPolicy) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{1}
}

func (x *RetryPolicy) GetMaxAttempts() int32 {
	if x != nil {
		return x.MaxAttempts
	}
	return 0
}

func (x *RetryPolicy) GetStrategy() isRetryPolicy_Strategy {
	if x != nil {
		return x.Strategy
	}
	return nil
}

func (x *RetryPolicy) GetExponentialBackoff() *ExponentialBackoff {
	if x != nil {
		if x, ok := x.Strategy.(*RetryPolicy_ExponentialBackoff); ok {
			return x.ExponentialBackoff
		}
	}
	return nil
}

func (x *RetryPolicy) GetCustomizedBackoff() *CustomizedBackoff {
	if x != nil {
		if x, ok := x.Strategy.(*RetryPolicy_CustomizedBackoff); ok {
			return x.CustomizedBackoff
		}
	}
	return nil
}

type isRetryPolicy_Strategy interface {
	isRetryPolicy_Strategy()
}

type RetryPolicy_ExponentialBackoff struct {
	ExponentialBackoff *ExponentialBackoff `protobuf:"bytes,2,opt,name=exponential_backoff,json=exponentialBackoff,proto3,oneof"`
}

type RetryPolicy_CustomizedBackoff struct {
	CustomizedBackoff *CustomizedBackoff `protobuf:"bytes,3,opt,name=customized_backoff,json=customizedBackoff,proto3,oneof"`
}

func (*RetryPolicy_ExponentialBackoff) isRetryPolicy_Strategy() {}

func (*RetryPolicy_CustomizedBackoff) isRetryPolicy_Strategy() {}

// https://en.wikipedia.org/wiki/Exponential_backoff
type ExponentialBackoff struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Initial       *durationpb.Duration   `protobuf:"bytes,1,opt,name=initial,proto3" json:"initial,omitempty"`
	Max           *durationpb.Duration   `protobuf:"bytes,2,opt,name=max,proto3" json:"max,omitempty"`
	Multiplier    float32                `protobuf:"fixed32,3,opt,name=multiplier,proto3" json:"multiplier,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExponentialBackoff) Reset() {
	*x = ExponentialBackoff{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExponentialBackoff) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExponentialBackoff) ProtoMessage() {}

func (x *ExponentialBackoff) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExponentialBackoff.ProtoReflect.Descriptor instead.
func (*ExponentialBackoff) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{2}
}

func (x *ExponentialBackoff) GetInitial() *durationpb.Duration {
	if x != nil {
		return x.Initial
	}
	return nil
}

func (x *ExponentialBackoff) GetMax() *durationpb.Duration {
	if x != nil {
		return x.Max
	}
	return nil
}

func (x *ExponentialBackoff) GetMultiplier() float32 {
	if x != nil {
		return x.Multiplier
	}
	return 0
}

type CustomizedBackoff struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// To support classic backoff strategy which is arbitrary defined by end users.
	// Typical values are: `1s 5s 10s 30s 1m 2m 3m 4m 5m 6m 7m 8m 9m 10m 20m 30m 1h 2h`
	Next          []*durationpb.Duration `protobuf:"bytes,1,rep,name=next,proto3" json:"next,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CustomizedBackoff) Reset() {
	*x = CustomizedBackoff{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomizedBackoff) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomizedBackoff) ProtoMessage() {}

func (x *CustomizedBackoff) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomizedBackoff.ProtoReflect.Descriptor instead.
func (*CustomizedBackoff) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{3}
}

func (x *CustomizedBackoff) GetNext() []*durationpb.Duration {
	if x != nil {
		return x.Next
	}
	return nil
}

type Resource struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	ResourceNamespace string                 `protobuf:"bytes,1,opt,name=resource_namespace,json=resourceNamespace,proto3" json:"resource_namespace,omitempty"`
	// Resource name identifier, which remains unique within the abstract resource
	// namespace.
	Name          string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Resource) Reset() {
	*x = Resource{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{4}
}

func (x *Resource) GetResourceNamespace() string {
	if x != nil {
		return x.ResourceNamespace
	}
	return ""
}

func (x *Resource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type SubscriptionEntry struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Topic         *Resource              `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	Expression    *FilterExpression      `protobuf:"bytes,2,opt,name=expression,proto3" json:"expression,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SubscriptionEntry) Reset() {
	*x = SubscriptionEntry{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SubscriptionEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SubscriptionEntry) ProtoMessage() {}

func (x *SubscriptionEntry) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SubscriptionEntry.ProtoReflect.Descriptor instead.
func (*SubscriptionEntry) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{5}
}

func (x *SubscriptionEntry) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *SubscriptionEntry) GetExpression() *FilterExpression {
	if x != nil {
		return x.Expression
	}
	return nil
}

type Address struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Host          string                 `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	Port          int32                  `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Address) Reset() {
	*x = Address{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Address) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Address) ProtoMessage() {}

func (x *Address) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Address.ProtoReflect.Descriptor instead.
func (*Address) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{6}
}

func (x *Address) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *Address) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

type Endpoints struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Scheme        AddressScheme          `protobuf:"varint,1,opt,name=scheme,proto3,enum=apache.rocketmq.v2.AddressScheme" json:"scheme,omitempty"`
	Addresses     []*Address             `protobuf:"bytes,2,rep,name=addresses,proto3" json:"addresses,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Endpoints) Reset() {
	*x = Endpoints{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Endpoints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Endpoints) ProtoMessage() {}

func (x *Endpoints) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Endpoints.ProtoReflect.Descriptor instead.
func (*Endpoints) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{7}
}

func (x *Endpoints) GetScheme() AddressScheme {
	if x != nil {
		return x.Scheme
	}
	return AddressScheme_ADDRESS_SCHEME_UNSPECIFIED
}

func (x *Endpoints) GetAddresses() []*Address {
	if x != nil {
		return x.Addresses
	}
	return nil
}

type Broker struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the broker
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Broker index. Canonically, index = 0 implies that the broker is playing
	// leader role while brokers with index > 0 play follower role.
	Id int32 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	// Address of the broker, complying with the following scheme
	// 1. dns:[//authority/]host[:port]
	// 2. ipv4:address[:port][,address[:port],...] – IPv4 addresses
	// 3. ipv6:address[:port][,address[:port],...] – IPv6 addresses
	Endpoints     *Endpoints `protobuf:"bytes,3,opt,name=endpoints,proto3" json:"endpoints,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Broker) Reset() {
	*x = Broker{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Broker) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Broker) ProtoMessage() {}

func (x *Broker) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Broker.ProtoReflect.Descriptor instead.
func (*Broker) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{8}
}

func (x *Broker) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Broker) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Broker) GetEndpoints() *Endpoints {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

type MessageQueue struct {
	state              protoimpl.MessageState `protogen:"open.v1"`
	Topic              *Resource              `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	Id                 int32                  `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	Permission         Permission             `protobuf:"varint,3,opt,name=permission,proto3,enum=apache.rocketmq.v2.Permission" json:"permission,omitempty"`
	Broker             *Broker                `protobuf:"bytes,4,opt,name=broker,proto3" json:"broker,omitempty"`
	AcceptMessageTypes []MessageType          `protobuf:"varint,5,rep,packed,name=accept_message_types,json=acceptMessageTypes,proto3,enum=apache.rocketmq.v2.MessageType" json:"accept_message_types,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *MessageQueue) Reset() {
	*x = MessageQueue{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageQueue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageQueue) ProtoMessage() {}

func (x *MessageQueue) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageQueue.ProtoReflect.Descriptor instead.
func (*MessageQueue) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{9}
}

func (x *MessageQueue) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *MessageQueue) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *MessageQueue) GetPermission() Permission {
	if x != nil {
		return x.Permission
	}
	return Permission_PERMISSION_UNSPECIFIED
}

func (x *MessageQueue) GetBroker() *Broker {
	if x != nil {
		return x.Broker
	}
	return nil
}

func (x *MessageQueue) GetAcceptMessageTypes() []MessageType {
	if x != nil {
		return x.AcceptMessageTypes
	}
	return nil
}

// When publishing messages to or subscribing messages from brokers, clients
// shall include or validate digests of message body to ensure data integrity.
//
// For message publishing, when an invalid digest were detected, brokers need
// respond client with BAD_REQUEST.
//
// For messages subscription, when an invalid digest were detected, consumers
// need to handle this case according to message type:
// 1) Standard messages should be negatively acknowledged instantly, causing
// immediate re-delivery; 2) FIFO messages require special RPC, to re-fetch
// previously acquired messages batch;
type Digest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          DigestType             `protobuf:"varint,1,opt,name=type,proto3,enum=apache.rocketmq.v2.DigestType" json:"type,omitempty"`
	Checksum      string                 `protobuf:"bytes,2,opt,name=checksum,proto3" json:"checksum,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Digest) Reset() {
	*x = Digest{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Digest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Digest) ProtoMessage() {}

func (x *Digest) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Digest.ProtoReflect.Descriptor instead.
func (*Digest) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{10}
}

func (x *Digest) GetType() DigestType {
	if x != nil {
		return x.Type
	}
	return DigestType_DIGEST_TYPE_UNSPECIFIED
}

func (x *Digest) GetChecksum() string {
	if x != nil {
		return x.Checksum
	}
	return ""
}

type SystemProperties struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Tag, which is optional.
	Tag *string `protobuf:"bytes,1,opt,name=tag,proto3,oneof" json:"tag,omitempty"`
	// Message keys
	Keys []string `protobuf:"bytes,2,rep,name=keys,proto3" json:"keys,omitempty"`
	// Message identifier, client-side generated, remains unique.
	// if message_id is empty, the send message request will be aborted with
	// status `INVALID_ARGUMENT`
	MessageId string `protobuf:"bytes,3,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	// Message body digest
	BodyDigest *Digest `protobuf:"bytes,4,opt,name=body_digest,json=bodyDigest,proto3" json:"body_digest,omitempty"`
	// Message body encoding. Candidate options are identity, gzip, snappy etc.
	BodyEncoding Encoding `protobuf:"varint,5,opt,name=body_encoding,json=bodyEncoding,proto3,enum=apache.rocketmq.v2.Encoding" json:"body_encoding,omitempty"`
	// Message type, normal, FIFO or transactional.
	MessageType MessageType `protobuf:"varint,6,opt,name=message_type,json=messageType,proto3,enum=apache.rocketmq.v2.MessageType" json:"message_type,omitempty"`
	// Message born time-point.
	BornTimestamp *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=born_timestamp,json=bornTimestamp,proto3" json:"born_timestamp,omitempty"`
	// Message born host. Valid options are IPv4, IPv6 or client host domain name.
	BornHost string `protobuf:"bytes,8,opt,name=born_host,json=bornHost,proto3" json:"born_host,omitempty"`
	// Time-point at which the message is stored in the broker, which is absent
	// for message publishing.
	StoreTimestamp *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=store_timestamp,json=storeTimestamp,proto3,oneof" json:"store_timestamp,omitempty"`
	// The broker that stores this message. It may be broker name, IP or arbitrary
	// identifier that uniquely identify the server.
	StoreHost string `protobuf:"bytes,10,opt,name=store_host,json=storeHost,proto3" json:"store_host,omitempty"`
	// Time-point at which broker delivers to clients, which is optional.
	DeliveryTimestamp *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=delivery_timestamp,json=deliveryTimestamp,proto3,oneof" json:"delivery_timestamp,omitempty"`
	// If a message is acquired by way of POP, this field holds the receipt,
	// which is absent for message publishing.
	// Clients use the receipt to acknowledge or negatively acknowledge the
	// message.
	ReceiptHandle *string `protobuf:"bytes,12,opt,name=receipt_handle,json=receiptHandle,proto3,oneof" json:"receipt_handle,omitempty"`
	// Message queue identifier in which a message is physically stored.
	QueueId int32 `protobuf:"varint,13,opt,name=queue_id,json=queueId,proto3" json:"queue_id,omitempty"`
	// Message-queue offset at which a message is stored, which is absent for
	// message publishing.
	QueueOffset *int64 `protobuf:"varint,14,opt,name=queue_offset,json=queueOffset,proto3,oneof" json:"queue_offset,omitempty"`
	// Period of time servers would remain invisible once a message is acquired.
	InvisibleDuration *durationpb.Duration `protobuf:"bytes,15,opt,name=invisible_duration,json=invisibleDuration,proto3,oneof" json:"invisible_duration,omitempty"`
	// Business code may failed to process messages for the moment. Hence, clients
	// may request servers to deliver them again using certain back-off strategy,
	// the attempt is 1 not 0 if message is delivered first time, and it is absent
	// for message publishing.
	DeliveryAttempt *int32 `protobuf:"varint,16,opt,name=delivery_attempt,json=deliveryAttempt,proto3,oneof" json:"delivery_attempt,omitempty"`
	// Define the group name of message in the same topic, which is optional.
	MessageGroup *string `protobuf:"bytes,17,opt,name=message_group,json=messageGroup,proto3,oneof" json:"message_group,omitempty"`
	// Trace context for each message, which is optional.
	TraceContext *string `protobuf:"bytes,18,opt,name=trace_context,json=traceContext,proto3,oneof" json:"trace_context,omitempty"`
	// If a transactional message stay unresolved for more than
	// `transaction_orphan_threshold`, it would be regarded as an
	// orphan. Servers that manages orphan messages would pick up
	// a capable publisher to resolve
	OrphanedTransactionRecoveryDuration *durationpb.Duration `protobuf:"bytes,19,opt,name=orphaned_transaction_recovery_duration,json=orphanedTransactionRecoveryDuration,proto3,oneof" json:"orphaned_transaction_recovery_duration,omitempty"`
	// Information to identify whether this message is from dead letter queue.
	DeadLetterQueue *DeadLetterQueue `protobuf:"bytes,20,opt,name=dead_letter_queue,json=deadLetterQueue,proto3,oneof" json:"dead_letter_queue,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *SystemProperties) Reset() {
	*x = SystemProperties{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SystemProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SystemProperties) ProtoMessage() {}

func (x *SystemProperties) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SystemProperties.ProtoReflect.Descriptor instead.
func (*SystemProperties) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{11}
}

func (x *SystemProperties) GetTag() string {
	if x != nil && x.Tag != nil {
		return *x.Tag
	}
	return ""
}

func (x *SystemProperties) GetKeys() []string {
	if x != nil {
		return x.Keys
	}
	return nil
}

func (x *SystemProperties) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

func (x *SystemProperties) GetBodyDigest() *Digest {
	if x != nil {
		return x.BodyDigest
	}
	return nil
}

func (x *SystemProperties) GetBodyEncoding() Encoding {
	if x != nil {
		return x.BodyEncoding
	}
	return Encoding_ENCODING_UNSPECIFIED
}

func (x *SystemProperties) GetMessageType() MessageType {
	if x != nil {
		return x.MessageType
	}
	return MessageType_MESSAGE_TYPE_UNSPECIFIED
}

func (x *SystemProperties) GetBornTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.BornTimestamp
	}
	return nil
}

func (x *SystemProperties) GetBornHost() string {
	if x != nil {
		return x.BornHost
	}
	return ""
}

func (x *SystemProperties) GetStoreTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.StoreTimestamp
	}
	return nil
}

func (x *SystemProperties) GetStoreHost() string {
	if x != nil {
		return x.StoreHost
	}
	return ""
}

func (x *SystemProperties) GetDeliveryTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.DeliveryTimestamp
	}
	return nil
}

func (x *SystemProperties) GetReceiptHandle() string {
	if x != nil && x.ReceiptHandle != nil {
		return *x.ReceiptHandle
	}
	return ""
}

func (x *SystemProperties) GetQueueId() int32 {
	if x != nil {
		return x.QueueId
	}
	return 0
}

func (x *SystemProperties) GetQueueOffset() int64 {
	if x != nil && x.QueueOffset != nil {
		return *x.QueueOffset
	}
	return 0
}

func (x *SystemProperties) GetInvisibleDuration() *durationpb.Duration {
	if x != nil {
		return x.InvisibleDuration
	}
	return nil
}

func (x *SystemProperties) GetDeliveryAttempt() int32 {
	if x != nil && x.DeliveryAttempt != nil {
		return *x.DeliveryAttempt
	}
	return 0
}

func (x *SystemProperties) GetMessageGroup() string {
	if x != nil && x.MessageGroup != nil {
		return *x.MessageGroup
	}
	return ""
}

func (x *SystemProperties) GetTraceContext() string {
	if x != nil && x.TraceContext != nil {
		return *x.TraceContext
	}
	return ""
}

func (x *SystemProperties) GetOrphanedTransactionRecoveryDuration() *durationpb.Duration {
	if x != nil {
		return x.OrphanedTransactionRecoveryDuration
	}
	return nil
}

func (x *SystemProperties) GetDeadLetterQueue() *DeadLetterQueue {
	if x != nil {
		return x.DeadLetterQueue
	}
	return nil
}

type DeadLetterQueue struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Original topic for this DLQ message.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Original message id for this DLQ message.
	MessageId     string `protobuf:"bytes,2,opt,name=message_id,json=messageId,proto3" json:"message_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeadLetterQueue) Reset() {
	*x = DeadLetterQueue{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeadLetterQueue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeadLetterQueue) ProtoMessage() {}

func (x *DeadLetterQueue) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeadLetterQueue.ProtoReflect.Descriptor instead.
func (*DeadLetterQueue) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{12}
}

func (x *DeadLetterQueue) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *DeadLetterQueue) GetMessageId() string {
	if x != nil {
		return x.MessageId
	}
	return ""
}

type Message struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Topic *Resource              `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// User defined key-value pairs.
	// If user_properties contain the reserved keys by RocketMQ,
	// the send message request will be aborted with status `INVALID_ARGUMENT`.
	// See below links for the reserved keys
	// https://github.com/apache/rocketmq/blob/master/common/src/main/java/org/apache/rocketmq/common/message/MessageConst.java#L58
	UserProperties   map[string]string `protobuf:"bytes,2,rep,name=user_properties,json=userProperties,proto3" json:"user_properties,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	SystemProperties *SystemProperties `protobuf:"bytes,3,opt,name=system_properties,json=systemProperties,proto3" json:"system_properties,omitempty"`
	Body             []byte            `protobuf:"bytes,4,opt,name=body,proto3" json:"body,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Message) Reset() {
	*x = Message{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Message) ProtoMessage() {}

func (x *Message) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Message.ProtoReflect.Descriptor instead.
func (*Message) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{13}
}

func (x *Message) GetTopic() *Resource {
	if x != nil {
		return x.Topic
	}
	return nil
}

func (x *Message) GetUserProperties() map[string]string {
	if x != nil {
		return x.UserProperties
	}
	return nil
}

func (x *Message) GetSystemProperties() *SystemProperties {
	if x != nil {
		return x.SystemProperties
	}
	return nil
}

func (x *Message) GetBody() []byte {
	if x != nil {
		return x.Body
	}
	return nil
}

type Assignment struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	MessageQueue  *MessageQueue          `protobuf:"bytes,1,opt,name=message_queue,json=messageQueue,proto3" json:"message_queue,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Assignment) Reset() {
	*x = Assignment{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Assignment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Assignment) ProtoMessage() {}

func (x *Assignment) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Assignment.ProtoReflect.Descriptor instead.
func (*Assignment) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{14}
}

func (x *Assignment) GetMessageQueue() *MessageQueue {
	if x != nil {
		return x.MessageQueue
	}
	return nil
}

type Status struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Code          Code                   `protobuf:"varint,1,opt,name=code,proto3,enum=apache.rocketmq.v2.Code" json:"code,omitempty"`
	Message       string                 `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Status) Reset() {
	*x = Status{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status) ProtoMessage() {}

func (x *Status) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status.ProtoReflect.Descriptor instead.
func (*Status) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{15}
}

func (x *Status) GetCode() Code {
	if x != nil {
		return x.Code
	}
	return Code_CODE_UNSPECIFIED
}

func (x *Status) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// User Agent
type UA struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// SDK language
	Language Language `protobuf:"varint,1,opt,name=language,proto3,enum=apache.rocketmq.v2.Language" json:"language,omitempty"`
	// SDK version
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Platform details, including OS name, version, arch etc.
	Platform string `protobuf:"bytes,3,opt,name=platform,proto3" json:"platform,omitempty"`
	// Hostname of the node
	Hostname      string `protobuf:"bytes,4,opt,name=hostname,proto3" json:"hostname,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UA) Reset() {
	*x = UA{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UA) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UA) ProtoMessage() {}

func (x *UA) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UA.ProtoReflect.Descriptor instead.
func (*UA) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{16}
}

func (x *UA) GetLanguage() Language {
	if x != nil {
		return x.Language
	}
	return Language_LANGUAGE_UNSPECIFIED
}

func (x *UA) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *UA) GetPlatform() string {
	if x != nil {
		return x.Platform
	}
	return ""
}

func (x *UA) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

type Settings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configurations for all clients.
	ClientType  *ClientType `protobuf:"varint,1,opt,name=client_type,json=clientType,proto3,enum=apache.rocketmq.v2.ClientType,oneof" json:"client_type,omitempty"`
	AccessPoint *Endpoints  `protobuf:"bytes,2,opt,name=access_point,json=accessPoint,proto3,oneof" json:"access_point,omitempty"`
	// If publishing of messages encounters throttling or server internal errors,
	// publishers should implement automatic retries after progressive longer
	// back-offs for consecutive errors.
	//
	// When processing message fails, `backoff_policy` describes an interval
	// after which the message should be available to consume again.
	//
	// For FIFO messages, the interval should be relatively small because
	// messages of the same message group would not be readily available until
	// the prior one depletes its lifecycle.
	BackoffPolicy *RetryPolicy `protobuf:"bytes,3,opt,name=backoff_policy,json=backoffPolicy,proto3,oneof" json:"backoff_policy,omitempty"`
	// Request timeout for RPCs excluding long-polling.
	RequestTimeout *durationpb.Duration `protobuf:"bytes,4,opt,name=request_timeout,json=requestTimeout,proto3,oneof" json:"request_timeout,omitempty"`
	// Types that are valid to be assigned to PubSub:
	//
	//	*Settings_Publishing
	//	*Settings_Subscription
	PubSub isSettings_PubSub `protobuf_oneof:"pub_sub"`
	// User agent details
	UserAgent     *UA     `protobuf:"bytes,7,opt,name=user_agent,json=userAgent,proto3" json:"user_agent,omitempty"`
	Metric        *Metric `protobuf:"bytes,8,opt,name=metric,proto3" json:"metric,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Settings) Reset() {
	*x = Settings{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Settings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Settings) ProtoMessage() {}

func (x *Settings) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Settings.ProtoReflect.Descriptor instead.
func (*Settings) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{17}
}

func (x *Settings) GetClientType() ClientType {
	if x != nil && x.ClientType != nil {
		return *x.ClientType
	}
	return ClientType_CLIENT_TYPE_UNSPECIFIED
}

func (x *Settings) GetAccessPoint() *Endpoints {
	if x != nil {
		return x.AccessPoint
	}
	return nil
}

func (x *Settings) GetBackoffPolicy() *RetryPolicy {
	if x != nil {
		return x.BackoffPolicy
	}
	return nil
}

func (x *Settings) GetRequestTimeout() *durationpb.Duration {
	if x != nil {
		return x.RequestTimeout
	}
	return nil
}

func (x *Settings) GetPubSub() isSettings_PubSub {
	if x != nil {
		return x.PubSub
	}
	return nil
}

func (x *Settings) GetPublishing() *Publishing {
	if x != nil {
		if x, ok := x.PubSub.(*Settings_Publishing); ok {
			return x.Publishing
		}
	}
	return nil
}

func (x *Settings) GetSubscription() *Subscription {
	if x != nil {
		if x, ok := x.PubSub.(*Settings_Subscription); ok {
			return x.Subscription
		}
	}
	return nil
}

func (x *Settings) GetUserAgent() *UA {
	if x != nil {
		return x.UserAgent
	}
	return nil
}

func (x *Settings) GetMetric() *Metric {
	if x != nil {
		return x.Metric
	}
	return nil
}

type isSettings_PubSub interface {
	isSettings_PubSub()
}

type Settings_Publishing struct {
	Publishing *Publishing `protobuf:"bytes,5,opt,name=publishing,proto3,oneof"`
}

type Settings_Subscription struct {
	Subscription *Subscription `protobuf:"bytes,6,opt,name=subscription,proto3,oneof"`
}

func (*Settings_Publishing) isSettings_PubSub() {}

func (*Settings_Subscription) isSettings_PubSub() {}

type Publishing struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Publishing settings below here is appointed by client, thus it is
	// unnecessary for server to push at present.
	//
	// List of topics to which messages will publish to.
	Topics []*Resource `protobuf:"bytes,1,rep,name=topics,proto3" json:"topics,omitempty"`
	// If the message body size exceeds `max_body_size`, broker servers would
	// reject the request. As a result, it is advisable that Producer performs
	// client-side check validation.
	MaxBodySize int32 `protobuf:"varint,2,opt,name=max_body_size,json=maxBodySize,proto3" json:"max_body_size,omitempty"`
	// When `validate_message_type` flag set `false`, no need to validate message's type
	// with messageQueue's `accept_message_types` before publishing.
	ValidateMessageType bool `protobuf:"varint,3,opt,name=validate_message_type,json=validateMessageType,proto3" json:"validate_message_type,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *Publishing) Reset() {
	*x = Publishing{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Publishing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Publishing) ProtoMessage() {}

func (x *Publishing) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Publishing.ProtoReflect.Descriptor instead.
func (*Publishing) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{18}
}

func (x *Publishing) GetTopics() []*Resource {
	if x != nil {
		return x.Topics
	}
	return nil
}

func (x *Publishing) GetMaxBodySize() int32 {
	if x != nil {
		return x.MaxBodySize
	}
	return 0
}

func (x *Publishing) GetValidateMessageType() bool {
	if x != nil {
		return x.ValidateMessageType
	}
	return false
}

type Subscription struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Subscription settings below here is appointed by client, thus it is
	// unnecessary for server to push at present.
	//
	// Consumer group.
	Group *Resource `protobuf:"bytes,1,opt,name=group,proto3,oneof" json:"group,omitempty"`
	// Subscription for consumer.
	Subscriptions []*SubscriptionEntry `protobuf:"bytes,2,rep,name=subscriptions,proto3" json:"subscriptions,omitempty"`
	// Subscription settings below here are from server, it is essential for
	// server to push.
	//
	// When FIFO flag is `true`, messages of the same message group are processed
	// in first-in-first-out manner.
	//
	// Brokers will not deliver further messages of the same group until prior
	// ones are completely acknowledged.
	Fifo *bool `protobuf:"varint,3,opt,name=fifo,proto3,oneof" json:"fifo,omitempty"`
	// Message receive batch size here is essential for push consumer.
	ReceiveBatchSize *int32 `protobuf:"varint,4,opt,name=receive_batch_size,json=receiveBatchSize,proto3,oneof" json:"receive_batch_size,omitempty"`
	// Long-polling timeout for `ReceiveMessageRequest`, which is essential for
	// push consumer.
	LongPollingTimeout *durationpb.Duration `protobuf:"bytes,5,opt,name=long_polling_timeout,json=longPollingTimeout,proto3,oneof" json:"long_polling_timeout,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *Subscription) Reset() {
	*x = Subscription{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Subscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription) ProtoMessage() {}

func (x *Subscription) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription.ProtoReflect.Descriptor instead.
func (*Subscription) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{19}
}

func (x *Subscription) GetGroup() *Resource {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *Subscription) GetSubscriptions() []*SubscriptionEntry {
	if x != nil {
		return x.Subscriptions
	}
	return nil
}

func (x *Subscription) GetFifo() bool {
	if x != nil && x.Fifo != nil {
		return *x.Fifo
	}
	return false
}

func (x *Subscription) GetReceiveBatchSize() int32 {
	if x != nil && x.ReceiveBatchSize != nil {
		return *x.ReceiveBatchSize
	}
	return 0
}

func (x *Subscription) GetLongPollingTimeout() *durationpb.Duration {
	if x != nil {
		return x.LongPollingTimeout
	}
	return nil
}

type Metric struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Indicates that if client should export local metrics to server.
	On bool `protobuf:"varint,1,opt,name=on,proto3" json:"on,omitempty"`
	// The endpoint that client metrics should be exported to, which is required if the switch is on.
	Endpoints     *Endpoints `protobuf:"bytes,2,opt,name=endpoints,proto3,oneof" json:"endpoints,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Metric) Reset() {
	*x = Metric{}
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Metric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metric) ProtoMessage() {}

func (x *Metric) ProtoReflect() protoreflect.Message {
	mi := &file_apache_rocketmq_v2_definition_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Metric.ProtoReflect.Descriptor instead.
func (*Metric) Descriptor() ([]byte, []int) {
	return file_apache_rocketmq_v2_definition_proto_rawDescGZIP(), []int{20}
}

func (x *Metric) GetOn() bool {
	if x != nil {
		return x.On
	}
	return false
}

func (x *Metric) GetEndpoints() *Endpoints {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

var File_apache_rocketmq_v2_definition_proto protoreflect.FileDescriptor

const file_apache_rocketmq_v2_definition_proto_rawDesc = "" +
	"\n" +
	"#apache/rocketmq/v2/definition.proto\x12\x12apache.rocketmq.v2\x1a\x1fgoogle/protobuf/timestamp.proto\x1a\x1egoogle/protobuf/duration.proto\"f\n" +
	"\x10FilterExpression\x122\n" +
	"\x04type\x18\x01 \x01(\x0e2\x1e.apache.rocketmq.v2.FilterTypeR\x04type\x12\x1e\n" +
	"\n" +
	"expression\x18\x02 \x01(\tR\n" +
	"expression\"\xef\x01\n" +
	"\vRetryPolicy\x12!\n" +
	"\fmax_attempts\x18\x01 \x01(\x05R\vmaxAttempts\x12Y\n" +
	"\x13exponential_backoff\x18\x02 \x01(\v2&.apache.rocketmq.v2.ExponentialBackoffH\x00R\x12exponentialBackoff\x12V\n" +
	"\x12customized_backoff\x18\x03 \x01(\v2%.apache.rocketmq.v2.CustomizedBackoffH\x00R\x11customizedBackoffB\n" +
	"\n" +
	"\bstrategy\"\x96\x01\n" +
	"\x12ExponentialBackoff\x123\n" +
	"\ainitial\x18\x01 \x01(\v2\x19.google.protobuf.DurationR\ainitial\x12+\n" +
	"\x03max\x18\x02 \x01(\v2\x19.google.protobuf.DurationR\x03max\x12\x1e\n" +
	"\n" +
	"multiplier\x18\x03 \x01(\x02R\n" +
	"multiplier\"B\n" +
	"\x11CustomizedBackoff\x12-\n" +
	"\x04next\x18\x01 \x03(\v2\x19.google.protobuf.DurationR\x04next\"M\n" +
	"\bResource\x12-\n" +
	"\x12resource_namespace\x18\x01 \x01(\tR\x11resourceNamespace\x12\x12\n" +
	"\x04name\x18\x02 \x01(\tR\x04name\"\x8d\x01\n" +
	"\x11SubscriptionEntry\x122\n" +
	"\x05topic\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05topic\x12D\n" +
	"\n" +
	"expression\x18\x02 \x01(\v2$.apache.rocketmq.v2.FilterExpressionR\n" +
	"expression\"1\n" +
	"\aAddress\x12\x12\n" +
	"\x04host\x18\x01 \x01(\tR\x04host\x12\x12\n" +
	"\x04port\x18\x02 \x01(\x05R\x04port\"\x81\x01\n" +
	"\tEndpoints\x129\n" +
	"\x06scheme\x18\x01 \x01(\x0e2!.apache.rocketmq.v2.AddressSchemeR\x06scheme\x129\n" +
	"\taddresses\x18\x02 \x03(\v2\x1b.apache.rocketmq.v2.AddressR\taddresses\"i\n" +
	"\x06Broker\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x0e\n" +
	"\x02id\x18\x02 \x01(\x05R\x02id\x12;\n" +
	"\tendpoints\x18\x03 \x01(\v2\x1d.apache.rocketmq.v2.EndpointsR\tendpoints\"\x99\x02\n" +
	"\fMessageQueue\x122\n" +
	"\x05topic\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05topic\x12\x0e\n" +
	"\x02id\x18\x02 \x01(\x05R\x02id\x12>\n" +
	"\n" +
	"permission\x18\x03 \x01(\x0e2\x1e.apache.rocketmq.v2.PermissionR\n" +
	"permission\x122\n" +
	"\x06broker\x18\x04 \x01(\v2\x1a.apache.rocketmq.v2.BrokerR\x06broker\x12Q\n" +
	"\x14accept_message_types\x18\x05 \x03(\x0e2\x1f.apache.rocketmq.v2.MessageTypeR\x12acceptMessageTypes\"X\n" +
	"\x06Digest\x122\n" +
	"\x04type\x18\x01 \x01(\x0e2\x1e.apache.rocketmq.v2.DigestTypeR\x04type\x12\x1a\n" +
	"\bchecksum\x18\x02 \x01(\tR\bchecksum\"\xae\n" +
	"\n" +
	"\x10SystemProperties\x12\x15\n" +
	"\x03tag\x18\x01 \x01(\tH\x00R\x03tag\x88\x01\x01\x12\x12\n" +
	"\x04keys\x18\x02 \x03(\tR\x04keys\x12\x1d\n" +
	"\n" +
	"message_id\x18\x03 \x01(\tR\tmessageId\x12;\n" +
	"\vbody_digest\x18\x04 \x01(\v2\x1a.apache.rocketmq.v2.DigestR\n" +
	"bodyDigest\x12A\n" +
	"\rbody_encoding\x18\x05 \x01(\x0e2\x1c.apache.rocketmq.v2.EncodingR\fbodyEncoding\x12B\n" +
	"\fmessage_type\x18\x06 \x01(\x0e2\x1f.apache.rocketmq.v2.MessageTypeR\vmessageType\x12A\n" +
	"\x0eborn_timestamp\x18\a \x01(\v2\x1a.google.protobuf.TimestampR\rbornTimestamp\x12\x1b\n" +
	"\tborn_host\x18\b \x01(\tR\bbornHost\x12H\n" +
	"\x0fstore_timestamp\x18\t \x01(\v2\x1a.google.protobuf.TimestampH\x01R\x0estoreTimestamp\x88\x01\x01\x12\x1d\n" +
	"\n" +
	"store_host\x18\n" +
	" \x01(\tR\tstoreHost\x12N\n" +
	"\x12delivery_timestamp\x18\v \x01(\v2\x1a.google.protobuf.TimestampH\x02R\x11deliveryTimestamp\x88\x01\x01\x12*\n" +
	"\x0ereceipt_handle\x18\f \x01(\tH\x03R\rreceiptHandle\x88\x01\x01\x12\x19\n" +
	"\bqueue_id\x18\r \x01(\x05R\aqueueId\x12&\n" +
	"\fqueue_offset\x18\x0e \x01(\x03H\x04R\vqueueOffset\x88\x01\x01\x12M\n" +
	"\x12invisible_duration\x18\x0f \x01(\v2\x19.google.protobuf.DurationH\x05R\x11invisibleDuration\x88\x01\x01\x12.\n" +
	"\x10delivery_attempt\x18\x10 \x01(\x05H\x06R\x0fdeliveryAttempt\x88\x01\x01\x12(\n" +
	"\rmessage_group\x18\x11 \x01(\tH\aR\fmessageGroup\x88\x01\x01\x12(\n" +
	"\rtrace_context\x18\x12 \x01(\tH\bR\ftraceContext\x88\x01\x01\x12s\n" +
	"&orphaned_transaction_recovery_duration\x18\x13 \x01(\v2\x19.google.protobuf.DurationH\tR#orphanedTransactionRecoveryDuration\x88\x01\x01\x12T\n" +
	"\x11dead_letter_queue\x18\x14 \x01(\v2#.apache.rocketmq.v2.DeadLetterQueueH\n" +
	"R\x0fdeadLetterQueue\x88\x01\x01B\x06\n" +
	"\x04_tagB\x12\n" +
	"\x10_store_timestampB\x15\n" +
	"\x13_delivery_timestampB\x11\n" +
	"\x0f_receipt_handleB\x0f\n" +
	"\r_queue_offsetB\x15\n" +
	"\x13_invisible_durationB\x13\n" +
	"\x11_delivery_attemptB\x10\n" +
	"\x0e_message_groupB\x10\n" +
	"\x0e_trace_contextB)\n" +
	"'_orphaned_transaction_recovery_durationB\x14\n" +
	"\x12_dead_letter_queue\"F\n" +
	"\x0fDeadLetterQueue\x12\x14\n" +
	"\x05topic\x18\x01 \x01(\tR\x05topic\x12\x1d\n" +
	"\n" +
	"message_id\x18\x02 \x01(\tR\tmessageId\"\xc1\x02\n" +
	"\aMessage\x122\n" +
	"\x05topic\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceR\x05topic\x12X\n" +
	"\x0fuser_properties\x18\x02 \x03(\v2/.apache.rocketmq.v2.Message.UserPropertiesEntryR\x0euserProperties\x12Q\n" +
	"\x11system_properties\x18\x03 \x01(\v2$.apache.rocketmq.v2.SystemPropertiesR\x10systemProperties\x12\x12\n" +
	"\x04body\x18\x04 \x01(\fR\x04body\x1aA\n" +
	"\x13UserPropertiesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"S\n" +
	"\n" +
	"Assignment\x12E\n" +
	"\rmessage_queue\x18\x01 \x01(\v2 .apache.rocketmq.v2.MessageQueueR\fmessageQueue\"P\n" +
	"\x06Status\x12,\n" +
	"\x04code\x18\x01 \x01(\x0e2\x18.apache.rocketmq.v2.CodeR\x04code\x12\x18\n" +
	"\amessage\x18\x02 \x01(\tR\amessage\"\x90\x01\n" +
	"\x02UA\x128\n" +
	"\blanguage\x18\x01 \x01(\x0e2\x1c.apache.rocketmq.v2.LanguageR\blanguage\x12\x18\n" +
	"\aversion\x18\x02 \x01(\tR\aversion\x12\x1a\n" +
	"\bplatform\x18\x03 \x01(\tR\bplatform\x12\x1a\n" +
	"\bhostname\x18\x04 \x01(\tR\bhostname\"\xf5\x04\n" +
	"\bSettings\x12D\n" +
	"\vclient_type\x18\x01 \x01(\x0e2\x1e.apache.rocketmq.v2.ClientTypeH\x01R\n" +
	"clientType\x88\x01\x01\x12E\n" +
	"\faccess_point\x18\x02 \x01(\v2\x1d.apache.rocketmq.v2.EndpointsH\x02R\vaccessPoint\x88\x01\x01\x12K\n" +
	"\x0ebackoff_policy\x18\x03 \x01(\v2\x1f.apache.rocketmq.v2.RetryPolicyH\x03R\rbackoffPolicy\x88\x01\x01\x12G\n" +
	"\x0frequest_timeout\x18\x04 \x01(\v2\x19.google.protobuf.DurationH\x04R\x0erequestTimeout\x88\x01\x01\x12@\n" +
	"\n" +
	"publishing\x18\x05 \x01(\v2\x1e.apache.rocketmq.v2.PublishingH\x00R\n" +
	"publishing\x12F\n" +
	"\fsubscription\x18\x06 \x01(\v2 .apache.rocketmq.v2.SubscriptionH\x00R\fsubscription\x125\n" +
	"\n" +
	"user_agent\x18\a \x01(\v2\x16.apache.rocketmq.v2.UAR\tuserAgent\x122\n" +
	"\x06metric\x18\b \x01(\v2\x1a.apache.rocketmq.v2.MetricR\x06metricB\t\n" +
	"\apub_subB\x0e\n" +
	"\f_client_typeB\x0f\n" +
	"\r_access_pointB\x11\n" +
	"\x0f_backoff_policyB\x12\n" +
	"\x10_request_timeout\"\x9a\x01\n" +
	"\n" +
	"Publishing\x124\n" +
	"\x06topics\x18\x01 \x03(\v2\x1c.apache.rocketmq.v2.ResourceR\x06topics\x12\"\n" +
	"\rmax_body_size\x18\x02 \x01(\x05R\vmaxBodySize\x122\n" +
	"\x15validate_message_type\x18\x03 \x01(\bR\x13validateMessageType\"\xf5\x02\n" +
	"\fSubscription\x127\n" +
	"\x05group\x18\x01 \x01(\v2\x1c.apache.rocketmq.v2.ResourceH\x00R\x05group\x88\x01\x01\x12K\n" +
	"\rsubscriptions\x18\x02 \x03(\v2%.apache.rocketmq.v2.SubscriptionEntryR\rsubscriptions\x12\x17\n" +
	"\x04fifo\x18\x03 \x01(\bH\x01R\x04fifo\x88\x01\x01\x121\n" +
	"\x12receive_batch_size\x18\x04 \x01(\x05H\x02R\x10receiveBatchSize\x88\x01\x01\x12P\n" +
	"\x14long_polling_timeout\x18\x05 \x01(\v2\x19.google.protobuf.DurationH\x03R\x12longPollingTimeout\x88\x01\x01B\b\n" +
	"\x06_groupB\a\n" +
	"\x05_fifoB\x15\n" +
	"\x13_receive_batch_sizeB\x17\n" +
	"\x15_long_polling_timeout\"h\n" +
	"\x06Metric\x12\x0e\n" +
	"\x02on\x18\x01 \x01(\bR\x02on\x12@\n" +
	"\tendpoints\x18\x02 \x01(\v2\x1d.apache.rocketmq.v2.EndpointsH\x00R\tendpoints\x88\x01\x01B\f\n" +
	"\n" +
	"_endpoints*Y\n" +
	"\x15TransactionResolution\x12&\n" +
	"\"TRANSACTION_RESOLUTION_UNSPECIFIED\x10\x00\x12\n" +
	"\n" +
	"\x06COMMIT\x10\x01\x12\f\n" +
	"\bROLLBACK\x10\x02*W\n" +
	"\x11TransactionSource\x12\x16\n" +
	"\x12SOURCE_UNSPECIFIED\x10\x00\x12\x11\n" +
	"\rSOURCE_CLIENT\x10\x01\x12\x17\n" +
	"\x13SOURCE_SERVER_CHECK\x10\x02*W\n" +
	"\n" +
	"Permission\x12\x1a\n" +
	"\x16PERMISSION_UNSPECIFIED\x10\x00\x12\b\n" +
	"\x04NONE\x10\x01\x12\b\n" +
	"\x04READ\x10\x02\x12\t\n" +
	"\x05WRITE\x10\x03\x12\x0e\n" +
	"\n" +
	"READ_WRITE\x10\x04*;\n" +
	"\n" +
	"FilterType\x12\x1b\n" +
	"\x17FILTER_TYPE_UNSPECIFIED\x10\x00\x12\a\n" +
	"\x03TAG\x10\x01\x12\a\n" +
	"\x03SQL\x10\x02*T\n" +
	"\rAddressScheme\x12\x1e\n" +
	"\x1aADDRESS_SCHEME_UNSPECIFIED\x10\x00\x12\b\n" +
	"\x04IPv4\x10\x01\x12\b\n" +
	"\x04IPv6\x10\x02\x12\x0f\n" +
	"\vDOMAIN_NAME\x10\x03*]\n" +
	"\vMessageType\x12\x1c\n" +
	"\x18MESSAGE_TYPE_UNSPECIFIED\x10\x00\x12\n" +
	"\n" +
	"\x06NORMAL\x10\x01\x12\b\n" +
	"\x04FIFO\x10\x02\x12\t\n" +
	"\x05DELAY\x10\x03\x12\x0f\n" +
	"\vTRANSACTION\x10\x04*G\n" +
	"\n" +
	"DigestType\x12\x1b\n" +
	"\x17DIGEST_TYPE_UNSPECIFIED\x10\x00\x12\t\n" +
	"\x05CRC32\x10\x01\x12\a\n" +
	"\x03MD5\x10\x02\x12\b\n" +
	"\x04SHA1\x10\x03*r\n" +
	"\n" +
	"ClientType\x12\x1b\n" +
	"\x17CLIENT_TYPE_UNSPECIFIED\x10\x00\x12\f\n" +
	"\bPRODUCER\x10\x01\x12\x11\n" +
	"\rPUSH_CONSUMER\x10\x02\x12\x13\n" +
	"\x0fSIMPLE_CONSUMER\x10\x03\x12\x11\n" +
	"\rPULL_CONSUMER\x10\x04*<\n" +
	"\bEncoding\x12\x18\n" +
	"\x14ENCODING_UNSPECIFIED\x10\x00\x12\f\n" +
	"\bIDENTITY\x10\x01\x12\b\n" +
	"\x04GZIP\x10\x02*\xc6\n" +
	"\n" +
	"\x04Code\x12\x14\n" +
	"\x10CODE_UNSPECIFIED\x10\x00\x12\b\n" +
	"\x02OK\x10\xa0\x9c\x01\x12\x16\n" +
	"\x10MULTIPLE_RESULTS\x10\xb0\xea\x01\x12\x11\n" +
	"\vBAD_REQUEST\x10\xc0\xb8\x02\x12\x1a\n" +
	"\x14ILLEGAL_ACCESS_POINT\x10\xc1\xb8\x02\x12\x13\n" +
	"\rILLEGAL_TOPIC\x10¸\x02\x12\x1c\n" +
	"\x16ILLEGAL_CONSUMER_GROUP\x10ø\x02\x12\x19\n" +
	"\x13ILLEGAL_MESSAGE_TAG\x10ĸ\x02\x12\x19\n" +
	"\x13ILLEGAL_MESSAGE_KEY\x10Ÿ\x02\x12\x1b\n" +
	"\x15ILLEGAL_MESSAGE_GROUP\x10Ƹ\x02\x12\"\n" +
	"\x1cILLEGAL_MESSAGE_PROPERTY_KEY\x10Ǹ\x02\x12\x1c\n" +
	"\x16INVALID_TRANSACTION_ID\x10ȸ\x02\x12\x18\n" +
	"\x12ILLEGAL_MESSAGE_ID\x10ɸ\x02\x12\x1f\n" +
	"\x19ILLEGAL_FILTER_EXPRESSION\x10ʸ\x02\x12\x1c\n" +
	"\x16ILLEGAL_INVISIBLE_TIME\x10˸\x02\x12\x1b\n" +
	"\x15ILLEGAL_DELIVERY_TIME\x10̸\x02\x12\x1c\n" +
	"\x16INVALID_RECEIPT_HANDLE\x10\u0378\x02\x12)\n" +
	"#MESSAGE_PROPERTY_CONFLICT_WITH_TYPE\x10θ\x02\x12\x1e\n" +
	"\x18UNRECOGNIZED_CLIENT_TYPE\x10ϸ\x02\x12\x17\n" +
	"\x11MESSAGE_CORRUPTED\x10и\x02\x12\x18\n" +
	"\x12CLIENT_ID_REQUIRED\x10Ѹ\x02\x12\x1a\n" +
	"\x14ILLEGAL_POLLING_TIME\x10Ҹ\x02\x12\x14\n" +
	"\x0eILLEGAL_OFFSET\x10Ӹ\x02\x12\x12\n" +
	"\fUNAUTHORIZED\x10\xa4\xb9\x02\x12\x16\n" +
	"\x10PAYMENT_REQUIRED\x10\x88\xba\x02\x12\x0f\n" +
	"\tFORBIDDEN\x10\xec\xba\x02\x12\x0f\n" +
	"\tNOT_FOUND\x10л\x02\x12\x17\n" +
	"\x11MESSAGE_NOT_FOUND\x10ѻ\x02\x12\x15\n" +
	"\x0fTOPIC_NOT_FOUND\x10һ\x02\x12\x1e\n" +
	"\x18CONSUMER_GROUP_NOT_FOUND\x10ӻ\x02\x12\x16\n" +
	"\x10OFFSET_NOT_FOUND\x10Ի\x02\x12\x15\n" +
	"\x0fREQUEST_TIMEOUT\x10\xe0\xbe\x02\x12\x17\n" +
	"\x11PAYLOAD_TOO_LARGE\x10\xd4\xc2\x02\x12\x1c\n" +
	"\x16MESSAGE_BODY_TOO_LARGE\x10\xd5\xc2\x02\x12\x18\n" +
	"\x12MESSAGE_BODY_EMPTY\x10\xd6\xc2\x02\x12\x19\n" +
	"\x13PRECONDITION_FAILED\x10\xb0\xce\x02\x12\x17\n" +
	"\x11TOO_MANY_REQUESTS\x10\x94\xcf\x02\x12%\n" +
	"\x1fREQUEST_HEADER_FIELDS_TOO_LARGE\x10\xdc\xd0\x02\x12\"\n" +
	"\x1cMESSAGE_PROPERTIES_TOO_LARGE\x10\xdd\xd0\x02\x12\x14\n" +
	"\x0eINTERNAL_ERROR\x10І\x03\x12\x1b\n" +
	"\x15INTERNAL_SERVER_ERROR\x10ц\x03\x12\x16\n" +
	"\x10HA_NOT_AVAILABLE\x10҆\x03\x12\x15\n" +
	"\x0fNOT_IMPLEMENTED\x10\xb4\x87\x03\x12\x13\n" +
	"\rPROXY_TIMEOUT\x10\xe0\x89\x03\x12 \n" +
	"\x1aMASTER_PERSISTENCE_TIMEOUT\x10\xe1\x89\x03\x12\x1f\n" +
	"\x19SLAVE_PERSISTENCE_TIMEOUT\x10\xe2\x89\x03\x12\x11\n" +
	"\vUNSUPPORTED\x10Ċ\x03\x12\x19\n" +
	"\x13VERSION_UNSUPPORTED\x10Ŋ\x03\x12%\n" +
	"\x1fVERIFY_FIFO_MESSAGE_UNSUPPORTED\x10Ɗ\x03\x12\x1f\n" +
	"\x19FAILED_TO_CONSUME_MESSAGE\x10\xe0\xd4\x03*\xad\x01\n" +
	"\bLanguage\x12\x18\n" +
	"\x14LANGUAGE_UNSPECIFIED\x10\x00\x12\b\n" +
	"\x04JAVA\x10\x01\x12\a\n" +
	"\x03CPP\x10\x02\x12\v\n" +
	"\aDOT_NET\x10\x03\x12\n" +
	"\n" +
	"\x06GOLANG\x10\x04\x12\b\n" +
	"\x04RUST\x10\x05\x12\n" +
	"\n" +
	"\x06PYTHON\x10\x06\x12\a\n" +
	"\x03PHP\x10\a\x12\v\n" +
	"\aNODE_JS\x10\b\x12\b\n" +
	"\x04RUBY\x10\t\x12\x0f\n" +
	"\vOBJECTIVE_C\x10\n" +
	"\x12\b\n" +
	"\x04DART\x10\v\x12\n" +
	"\n" +
	"\x06KOTLIN\x10\f*:\n" +
	"\x11QueryOffsetPolicy\x12\r\n" +
	"\tBEGINNING\x10\x00\x12\a\n" +
	"\x03END\x10\x01\x12\r\n" +
	"\tTIMESTAMP\x10\x02BO\n" +
	"\x12apache.rocketmq.v2B\bMQDomainP\x01Z\x12apache/rocketmq/v2\xa0\x01\x01\xd8\x01\x01\xaa\x02\x12Apache.Rocketmq.V2b\x06proto3"

var (
	file_apache_rocketmq_v2_definition_proto_rawDescOnce sync.Once
	file_apache_rocketmq_v2_definition_proto_rawDescData []byte
)

func file_apache_rocketmq_v2_definition_proto_rawDescGZIP() []byte {
	file_apache_rocketmq_v2_definition_proto_rawDescOnce.Do(func() {
		file_apache_rocketmq_v2_definition_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_apache_rocketmq_v2_definition_proto_rawDesc), len(file_apache_rocketmq_v2_definition_proto_rawDesc)))
	})
	return file_apache_rocketmq_v2_definition_proto_rawDescData
}

var file_apache_rocketmq_v2_definition_proto_enumTypes = make([]protoimpl.EnumInfo, 12)
var file_apache_rocketmq_v2_definition_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_apache_rocketmq_v2_definition_proto_goTypes = []any{
	(TransactionResolution)(0),    // 0: apache.rocketmq.v2.TransactionResolution
	(TransactionSource)(0),        // 1: apache.rocketmq.v2.TransactionSource
	(Permission)(0),               // 2: apache.rocketmq.v2.Permission
	(FilterType)(0),               // 3: apache.rocketmq.v2.FilterType
	(AddressScheme)(0),            // 4: apache.rocketmq.v2.AddressScheme
	(MessageType)(0),              // 5: apache.rocketmq.v2.MessageType
	(DigestType)(0),               // 6: apache.rocketmq.v2.DigestType
	(ClientType)(0),               // 7: apache.rocketmq.v2.ClientType
	(Encoding)(0),                 // 8: apache.rocketmq.v2.Encoding
	(Code)(0),                     // 9: apache.rocketmq.v2.Code
	(Language)(0),                 // 10: apache.rocketmq.v2.Language
	(QueryOffsetPolicy)(0),        // 11: apache.rocketmq.v2.QueryOffsetPolicy
	(*FilterExpression)(nil),      // 12: apache.rocketmq.v2.FilterExpression
	(*RetryPolicy)(nil),           // 13: apache.rocketmq.v2.RetryPolicy
	(*ExponentialBackoff)(nil),    // 14: apache.rocketmq.v2.ExponentialBackoff
	(*CustomizedBackoff)(nil),     // 15: apache.rocketmq.v2.CustomizedBackoff
	(*Resource)(nil),              // 16: apache.rocketmq.v2.Resource
	(*SubscriptionEntry)(nil),     // 17: apache.rocketmq.v2.SubscriptionEntry
	(*Address)(nil),               // 18: apache.rocketmq.v2.Address
	(*Endpoints)(nil),             // 19: apache.rocketmq.v2.Endpoints
	(*Broker)(nil),                // 20: apache.rocketmq.v2.Broker
	(*MessageQueue)(nil),          // 21: apache.rocketmq.v2.MessageQueue
	(*Digest)(nil),                // 22: apache.rocketmq.v2.Digest
	(*SystemProperties)(nil),      // 23: apache.rocketmq.v2.SystemProperties
	(*DeadLetterQueue)(nil),       // 24: apache.rocketmq.v2.DeadLetterQueue
	(*Message)(nil),               // 25: apache.rocketmq.v2.Message
	(*Assignment)(nil),            // 26: apache.rocketmq.v2.Assignment
	(*Status)(nil),                // 27: apache.rocketmq.v2.Status
	(*UA)(nil),                    // 28: apache.rocketmq.v2.UA
	(*Settings)(nil),              // 29: apache.rocketmq.v2.Settings
	(*Publishing)(nil),            // 30: apache.rocketmq.v2.Publishing
	(*Subscription)(nil),          // 31: apache.rocketmq.v2.Subscription
	(*Metric)(nil),                // 32: apache.rocketmq.v2.Metric
	nil,                           // 33: apache.rocketmq.v2.Message.UserPropertiesEntry
	(*durationpb.Duration)(nil),   // 34: google.protobuf.Duration
	(*timestamppb.Timestamp)(nil), // 35: google.protobuf.Timestamp
}
var file_apache_rocketmq_v2_definition_proto_depIdxs = []int32{
	3,  // 0: apache.rocketmq.v2.FilterExpression.type:type_name -> apache.rocketmq.v2.FilterType
	14, // 1: apache.rocketmq.v2.RetryPolicy.exponential_backoff:type_name -> apache.rocketmq.v2.ExponentialBackoff
	15, // 2: apache.rocketmq.v2.RetryPolicy.customized_backoff:type_name -> apache.rocketmq.v2.CustomizedBackoff
	34, // 3: apache.rocketmq.v2.ExponentialBackoff.initial:type_name -> google.protobuf.Duration
	34, // 4: apache.rocketmq.v2.ExponentialBackoff.max:type_name -> google.protobuf.Duration
	34, // 5: apache.rocketmq.v2.CustomizedBackoff.next:type_name -> google.protobuf.Duration
	16, // 6: apache.rocketmq.v2.SubscriptionEntry.topic:type_name -> apache.rocketmq.v2.Resource
	12, // 7: apache.rocketmq.v2.SubscriptionEntry.expression:type_name -> apache.rocketmq.v2.FilterExpression
	4,  // 8: apache.rocketmq.v2.Endpoints.scheme:type_name -> apache.rocketmq.v2.AddressScheme
	18, // 9: apache.rocketmq.v2.Endpoints.addresses:type_name -> apache.rocketmq.v2.Address
	19, // 10: apache.rocketmq.v2.Broker.endpoints:type_name -> apache.rocketmq.v2.Endpoints
	16, // 11: apache.rocketmq.v2.MessageQueue.topic:type_name -> apache.rocketmq.v2.Resource
	2,  // 12: apache.rocketmq.v2.MessageQueue.permission:type_name -> apache.rocketmq.v2.Permission
	20, // 13: apache.rocketmq.v2.MessageQueue.broker:type_name -> apache.rocketmq.v2.Broker
	5,  // 14: apache.rocketmq.v2.MessageQueue.accept_message_types:type_name -> apache.rocketmq.v2.MessageType
	6,  // 15: apache.rocketmq.v2.Digest.type:type_name -> apache.rocketmq.v2.DigestType
	22, // 16: apache.rocketmq.v2.SystemProperties.body_digest:type_name -> apache.rocketmq.v2.Digest
	8,  // 17: apache.rocketmq.v2.SystemProperties.body_encoding:type_name -> apache.rocketmq.v2.Encoding
	5,  // 18: apache.rocketmq.v2.SystemProperties.message_type:type_name -> apache.rocketmq.v2.MessageType
	35, // 19: apache.rocketmq.v2.SystemProperties.born_timestamp:type_name -> google.protobuf.Timestamp
	35, // 20: apache.rocketmq.v2.SystemProperties.store_timestamp:type_name -> google.protobuf.Timestamp
	35, // 21: apache.rocketmq.v2.SystemProperties.delivery_timestamp:type_name -> google.protobuf.Timestamp
	34, // 22: apache.rocketmq.v2.SystemProperties.invisible_duration:type_name -> google.protobuf.Duration
	34, // 23: apache.rocketmq.v2.SystemProperties.orphaned_transaction_recovery_duration:type_name -> google.protobuf.Duration
	24, // 24: apache.rocketmq.v2.SystemProperties.dead_letter_queue:type_name -> apache.rocketmq.v2.DeadLetterQueue
	16, // 25: apache.rocketmq.v2.Message.topic:type_name -> apache.rocketmq.v2.Resource
	33, // 26: apache.rocketmq.v2.Message.user_properties:type_name -> apache.rocketmq.v2.Message.UserPropertiesEntry
	23, // 27: apache.rocketmq.v2.Message.system_properties:type_name -> apache.rocketmq.v2.SystemProperties
	21, // 28: apache.rocketmq.v2.Assignment.message_queue:type_name -> apache.rocketmq.v2.MessageQueue
	9,  // 29: apache.rocketmq.v2.Status.code:type_name -> apache.rocketmq.v2.Code
	10, // 30: apache.rocketmq.v2.UA.language:type_name -> apache.rocketmq.v2.Language
	7,  // 31: apache.rocketmq.v2.Settings.client_type:type_name -> apache.rocketmq.v2.ClientType
	19, // 32: apache.rocketmq.v2.Settings.access_point:type_name -> apache.rocketmq.v2.Endpoints
	13, // 33: apache.rocketmq.v2.Settings.backoff_policy:type_name -> apache.rocketmq.v2.RetryPolicy
	34, // 34: apache.rocketmq.v2.Settings.request_timeout:type_name -> google.protobuf.Duration
	30, // 35: apache.rocketmq.v2.Settings.publishing:type_name -> apache.rocketmq.v2.Publishing
	31, // 36: apache.rocketmq.v2.Settings.subscription:type_name -> apache.rocketmq.v2.Subscription
	28, // 37: apache.rocketmq.v2.Settings.user_agent:type_name -> apache.rocketmq.v2.UA
	32, // 38: apache.rocketmq.v2.Settings.metric:type_name -> apache.rocketmq.v2.Metric
	16, // 39: apache.rocketmq.v2.Publishing.topics:type_name -> apache.rocketmq.v2.Resource
	16, // 40: apache.rocketmq.v2.Subscription.group:type_name -> apache.rocketmq.v2.Resource
	17, // 41: apache.rocketmq.v2.Subscription.subscriptions:type_name -> apache.rocketmq.v2.SubscriptionEntry
	34, // 42: apache.rocketmq.v2.Subscription.long_polling_timeout:type_name -> google.protobuf.Duration
	19, // 43: apache.rocketmq.v2.Metric.endpoints:type_name -> apache.rocketmq.v2.Endpoints
	44, // [44:44] is the sub-list for method output_type
	44, // [44:44] is the sub-list for method input_type
	44, // [44:44] is the sub-list for extension type_name
	44, // [44:44] is the sub-list for extension extendee
	0,  // [0:44] is the sub-list for field type_name
}

func init() { file_apache_rocketmq_v2_definition_proto_init() }
func file_apache_rocketmq_v2_definition_proto_init() {
	if File_apache_rocketmq_v2_definition_proto != nil {
		return
	}
	file_apache_rocketmq_v2_definition_proto_msgTypes[1].OneofWrappers = []any{
		(*RetryPolicy_ExponentialBackoff)(nil),
		(*RetryPolicy_CustomizedBackoff)(nil),
	}
	file_apache_rocketmq_v2_definition_proto_msgTypes[11].OneofWrappers = []any{}
	file_apache_rocketmq_v2_definition_proto_msgTypes[17].OneofWrappers = []any{
		(*Settings_Publishing)(nil),
		(*Settings_Subscription)(nil),
	}
	file_apache_rocketmq_v2_definition_proto_msgTypes[19].OneofWrappers = []any{}
	file_apache_rocketmq_v2_definition_proto_msgTypes[20].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_apache_rocketmq_v2_definition_proto_rawDesc), len(file_apache_rocketmq_v2_definition_proto_rawDesc)),
			NumEnums:      12,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_apache_rocketmq_v2_definition_proto_goTypes,
		DependencyIndexes: file_apache_rocketmq_v2_definition_proto_depIdxs,
		EnumInfos:         file_apache_rocketmq_v2_definition_proto_enumTypes,
		MessageInfos:      file_apache_rocketmq_v2_definition_proto_msgTypes,
	}.Build()
	File_apache_rocketmq_v2_definition_proto = out.File
	file_apache_rocketmq_v2_definition_proto_goTypes = nil
	file_apache_rocketmq_v2_definition_proto_depIdxs = nil
}
