/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferUtils;
import org.apache.qpid.protonj2.buffer.impl.ProtonByteArrayBufferAllocator;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ScanningContext;
import org.apache.qpid.protonj2.codec.decoders.StreamScanningContext;
import org.apache.qpid.protonj2.types.Symbol;

public class ProtonScanningContext<Type>
implements ScanningContext<Type>,
StreamScanningContext<Type> {
    private final Class<?> expectedType;
    private final List<Type> entries;
    private final List<ProtonBuffer> encodedEntries;
    private final boolean[] matched;
    private int matches;

    public ProtonScanningContext(Class<?> expectedType, Type entry, ProtonBuffer encodedEntry) {
        this.expectedType = expectedType;
        this.entries = Collections.singletonList(entry);
        this.encodedEntries = Collections.singletonList(encodedEntry);
        this.matched = new boolean[this.entries.size()];
        Arrays.fill(this.matched, false);
    }

    public ProtonScanningContext(Class<?> expectedType, List<Type> entries, List<ProtonBuffer> encodedEntries) {
        this.expectedType = expectedType;
        this.entries = entries;
        this.encodedEntries = encodedEntries;
        this.matched = new boolean[entries.size()];
        Arrays.fill(this.matched, false);
    }

    @Override
    public void reset() {
        this.matches = 0;
        Arrays.fill(this.matched, false);
    }

    @Override
    public boolean isComplete() {
        return this.matches == this.matched.length;
    }

    @Override
    public boolean matches(TypeDecoder<?> typeDecoder, ProtonBuffer candidate, int candidateLength, Consumer<Type> matchConsumer) {
        if (this.isComplete() || !this.expectedType.equals(typeDecoder.getTypeClass())) {
            return false;
        }
        for (int i = 0; i < this.matched.length; ++i) {
            if (this.matched[i] || !ProtonBufferUtils.equals(this.encodedEntries.get(i), 0, candidate, candidate.getReadOffset(), candidateLength)) continue;
            this.matched[i] = true;
            if (matchConsumer != null) {
                matchConsumer.accept(this.entries.get(i));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matches(StreamTypeDecoder<?> typeDecoder, InputStream stream, int encodedSize, Consumer<Type> matchConsumer) {
        if (!stream.markSupported()) {
            throw new UnsupportedOperationException("Type scanner requires a stream with mark and reset support");
        }
        if (this.isComplete() || !this.expectedType.equals(typeDecoder.getTypeClass())) {
            return false;
        }
        try {
            for (int i = 0; i < this.matched.length; ++i) {
                if (this.matched[i]) continue;
                ProtonBuffer candidate = this.encodedEntries.get(i);
                boolean matchFound = true;
                if (candidate.getReadableBytes() != encodedSize) continue;
                stream.mark(encodedSize);
                try {
                    for (int j = 0; j < encodedSize; ++j) {
                        if (candidate.getByte(j) == stream.read()) continue;
                        matchFound = false;
                        break;
                    }
                }
                finally {
                    stream.reset();
                }
                if (!matchFound) continue;
                this.matched[i] = true;
                if (matchConsumer != null) {
                    matchConsumer.accept(this.entries.get(i));
                }
                return true;
            }
        }
        catch (IOException ex) {
            throw new DecodeException("Error while scanning input stream", ex);
        }
        return false;
    }

    public static ProtonScanningContext<String> createStringScanContext(String ... entries) {
        Objects.requireNonNull(entries, "The entries to search for cannot be null");
        return ProtonScanningContext.internalCreateStringScanContext(Arrays.asList(entries));
    }

    public static ProtonScanningContext<String> createStringScanContext(Collection<String> entries) {
        Objects.requireNonNull(entries, "The entries to search for cannot be null");
        return ProtonScanningContext.internalCreateStringScanContext(new ArrayList<String>(entries));
    }

    public static ProtonScanningContext<Symbol> createSymbolScanContext(Symbol ... entries) {
        Objects.requireNonNull(entries, "The entries to search for cannot be null");
        return ProtonScanningContext.internalCreateSymbolScanContext(Arrays.asList(entries));
    }

    public static ProtonScanningContext<Symbol> createSymbolScanContext(Collection<Symbol> entries) {
        Objects.requireNonNull(entries, "The entries to search for cannot be null");
        return ProtonScanningContext.internalCreateSymbolScanContext(new ArrayList<Symbol>(entries));
    }

    private static ProtonScanningContext<String> internalCreateStringScanContext(List<String> entries) {
        Objects.requireNonNull(entries, "The entries to search for cannot be null");
        ArrayList<ProtonBuffer> encodedentries = new ArrayList<ProtonBuffer>(entries.size());
        entries.forEach(key -> encodedentries.add(ProtonByteArrayBufferAllocator.wrapped(key.getBytes(StandardCharsets.UTF_8)).convertToReadOnly()));
        return new ProtonScanningContext<String>(String.class, entries, encodedentries);
    }

    private static ProtonScanningContext<Symbol> internalCreateSymbolScanContext(List<Symbol> entries) {
        Objects.requireNonNull(entries, "The entries to search for cannot be null");
        ArrayList<ProtonBuffer> encodedentries = new ArrayList<ProtonBuffer>(entries.size());
        entries.forEach(key -> encodedentries.add(key.toASCII()));
        return new ProtonScanningContext<Symbol>(Symbol.class, entries, encodedentries);
    }
}

