/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.registry;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.RegistryClientIDResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.api.entity.FlowRegistryClientsEntity;

public class GetRegistryClientId
extends AbstractNiFiCommand<RegistryClientIDResult> {
    public GetRegistryClientId() {
        super("get-reg-client-id", RegistryClientIDResult.class);
    }

    @Override
    public String getDescription() {
        return "Returns the id of the first registry client found with the given name.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.REGISTRY_CLIENT_NAME.createOption());
    }

    @Override
    public RegistryClientIDResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, CommandException, MissingOptionException {
        String regClientName = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_NAME);
        FlowRegistryClientsEntity registries = client.getControllerClient().getRegistryClients();
        FlowRegistryClientDTO registry = null;
        if (!StringUtils.isBlank((CharSequence)regClientName)) {
            registry = registries.getRegistries().stream().map(r -> r.getComponent()).filter(r -> r.getName().equalsIgnoreCase(regClientName.trim())).findFirst().orElse(null);
        }
        if (registry == null) {
            throw new NiFiClientException("No registry client exists with the name '" + regClientName + "'");
        }
        return new RegistryClientIDResult(this.getResultType(properties), registry);
    }
}

