/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.client.impl;

import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;

public class CRUDJerseyClient<T extends ComponentEntity>
extends AbstractJerseyClient {
    private final WebTarget creationTarget;
    private final WebTarget accessTarget;
    private final Class<T> entityType;
    private final String componentType;

    public CRUDJerseyClient(WebTarget creationTarget, WebTarget accessTarget, RequestConfig requestConfig, Class<T> entityType, String componentType) {
        super(requestConfig);
        this.entityType = entityType;
        this.componentType = componentType;
        this.creationTarget = creationTarget;
        this.accessTarget = accessTarget;
    }

    protected T createComponent(String parentGroupdId, T entity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)parentGroupdId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null");
        }
        return (T)this.executeAction("Error creating " + this.componentType, () -> {
            WebTarget target = this.creationTarget.resolveTemplate("pgId", (Object)parentGroupdId);
            return (ComponentEntity)this.getRequestBuilder(target).post(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), this.entityType);
        });
    }

    protected T getComponent(String id) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException(this.componentType + " ID cannot be null");
        }
        return (T)this.executeAction("Error retrieving status of " + this.componentType, () -> {
            WebTarget target = this.accessTarget.resolveTemplate("id", (Object)id);
            return (ComponentEntity)this.getRequestBuilder(target).get(this.entityType);
        });
    }

    protected T updateComponent(T entity) throws NiFiClientException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException(this.componentType + " entity cannot be null");
        }
        return (T)this.executeAction("Error updating " + this.componentType, () -> {
            WebTarget target = this.accessTarget.resolveTemplate("id", (Object)entity.getId());
            return (ComponentEntity)this.getRequestBuilder(target).put(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), this.entityType);
        });
    }

    public T deleteComponent(T entity) throws NiFiClientException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException(this.componentType + " entity cannot be null");
        }
        if (entity.getId() == null) {
            throw new IllegalArgumentException(this.componentType + " ID cannot be null");
        }
        RevisionDTO revision = entity.getRevision();
        if (revision == null) {
            throw new IllegalArgumentException("Revision cannot be null");
        }
        return (T)this.executeAction("Error deleting " + this.componentType, () -> {
            WebTarget target = this.accessTarget.queryParam("version", new Object[]{revision.getVersion()}).queryParam("clientId", new Object[]{revision.getClientId()}).resolveTemplate("id", (Object)entity.getId());
            if (entity.isDisconnectedNodeAcknowledged() == Boolean.TRUE) {
                target = target.queryParam("disconnectedNodeAcknowledged", new Object[]{"true"});
            }
            return (ComponentEntity)this.getRequestBuilder(target).delete(this.entityType);
        });
    }
}

