/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.implspi;

import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class ContextProvider {
    private static final AtomicReference<Lookup.Result<ContextProvider>> impls = new AtomicReference();

    @NonNull
    public static Lookup getContext(@NonNull FileObject file) {
        Parameters.notNull("file", file);
        for (ContextProvider contextProvider : ContextProvider.getImpls()) {
            Lookup res = contextProvider.findContext(file);
            if (res == null) continue;
            return res;
        }
        throw new IllegalStateException("Missing DefaultContextProvider");
    }

    @NonNull
    public static Lookup getContext(@NonNull URL url) {
        Parameters.notNull("url", url);
        for (ContextProvider contextProvider : ContextProvider.getImpls()) {
            Lookup res = contextProvider.findContext(url);
            if (res == null) continue;
            return res;
        }
        throw new IllegalStateException("Missing DefaultContextProvider");
    }

    @CheckForNull
    protected abstract Lookup findContext(@NonNull FileObject var1);

    @CheckForNull
    protected abstract Lookup findContext(@NonNull URL var1);

    @NonNull
    private static Iterable<? extends ContextProvider> getImpls() {
        ProxyLookup lkp;
        Lookup.Result<ContextProvider> res = impls.get();
        if (res == null && !impls.compareAndSet(null, res = (lkp = new ProxyLookup(Lookup.getDefault(), Lookups.singleton(new DefaultContextProvider()))).lookupResult(ContextProvider.class))) {
            res = impls.get();
        }
        return res.allInstances();
    }

    private static final class DefaultContextProvider
    extends ContextProvider {
        private DefaultContextProvider() {
        }

        @Override
        @CheckForNull
        protected Lookup findContext(@NonNull FileObject file) {
            return Lookup.getDefault();
        }

        @Override
        @CheckForNull
        protected Lookup findContext(@NonNull URL url) {
            return Lookup.getDefault();
        }
    }
}

