/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jpt.sun.source.util.TreePath;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.ElementFilter;
import jpt30.lang.model.util.Types;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.netbeans.spi.java.hints.MatcherUtilities;
import org.openide.util.NbBundle;

public class ThrowableInitCause {
    public static final boolean STRICT_DEFAULT = false;
    public static final String STRICT_KEY = "strict";

    public static ErrorDescription expression(HintContext ctx) {
        return ThrowableInitCause.initCause(ctx, false);
    }

    public static ErrorDescription variable(HintContext ctx) {
        return ThrowableInitCause.initCause(ctx, true);
    }

    private static ErrorDescription initCause(HintContext ctx, boolean toThrow) {
        String target;
        TypeElement throwable = ctx.getInfo().getElements().getTypeElement("java.lang.Throwable");
        if (throwable == null) {
            return null;
        }
        TreePath exc = ctx.getVariables().get("$exc");
        TypeMirror excType = ctx.getInfo().getTrees().getTypeMirror(exc);
        Types t = ctx.getInfo().getTypes();
        if (!t.isSubtype(t.erasure(excType), t.erasure(throwable.asType()))) {
            return null;
        }
        Element el = t.asElement(excType);
        if (el == null || el.getKind() != ElementKind.CLASS) {
            return null;
        }
        LinkedList<TypeMirror> constrParams = new LinkedList<TypeMirror>();
        TreePath str = ctx.getVariables().get("$str");
        if (str != null && (MatcherUtilities.matches(ctx, str, "$del.toString()") || MatcherUtilities.matches(ctx, str, "$del.getMessage()") && !ctx.getPreferences().getBoolean(STRICT_KEY, false) || MatcherUtilities.matches(ctx, str, "$del.getLocalizedMessage()") && !ctx.getPreferences().getBoolean(STRICT_KEY, false)) || str == null && !ctx.getPreferences().getBoolean(STRICT_KEY, false)) {
            target = "new $exc($del)";
        } else {
            TypeElement jlString = ctx.getInfo().getElements().getTypeElement("java.lang.String");
            if (jlString == null) {
                return null;
            }
            constrParams.add(jlString.asType());
            target = str != null ? "new $exc($str, $del)" : "new $exc(null, $del)";
        }
        if (toThrow) {
            target = "throw " + target + ";";
        }
        TreePath del = ctx.getVariables().get("$del");
        TypeMirror delType = ctx.getInfo().getTrees().getTypeMirror(del);
        constrParams.add(delType);
        if (!ThrowableInitCause.findConstructor(el, t, constrParams)) {
            return null;
        }
        String fixDisplayName = NbBundle.getMessage(ThrowableInitCause.class, "FIX_ThrowableInitCause");
        String displayName = NbBundle.getMessage(ThrowableInitCause.class, "ERR_ThrowableInitCause");
        TreePath toUnderline = ctx.getVariables().get("$excVar");
        if (toUnderline == null) {
            toUnderline = ctx.getPath();
        }
        return ErrorDescriptionFactory.forTree(ctx, toUnderline, displayName, JavaFixUtilities.rewriteFix(ctx, fixDisplayName, ctx.getPath(), target));
    }

    private static boolean findConstructor(Element el, Types t, List<TypeMirror> paramTypes) {
        boolean found = false;
        block0: for (ExecutableElement ee : ElementFilter.constructorsIn(el.getEnclosedElements())) {
            if (ee.isVarArgs() || ee.getParameters().size() != paramTypes.size()) continue;
            Iterator<? extends VariableElement> p = ee.getParameters().iterator();
            Iterator<TypeMirror> expectedType = paramTypes.iterator();
            while (p.hasNext() && expectedType.hasNext()) {
                if (t.isAssignable(expectedType.next(), p.next().asType())) continue;
                continue block0;
            }
            found = true;
            break;
        }
        return found;
    }
}

