/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.classfile;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt.sun.source.tree.AnnotationTree;
import jpt.sun.source.tree.AssignmentTree;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.DirectiveTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.LiteralTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.ModifiersTree;
import jpt.sun.source.tree.ModuleTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.TypeParameterTree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.tools.classfile.Attribute;
import jpt.sun.tools.classfile.ClassFile;
import jpt.sun.tools.classfile.Code_attribute;
import jpt.sun.tools.classfile.ConstantPoolException;
import jpt.sun.tools.classfile.Instruction;
import jpt.sun.tools.classfile.Method;
import jpt.sun.tools.classfile.Opcode;
import jpt.sun.tools.classfile.SourceFile_attribute;
import jpt.sun.tools.javac.code.Symbol;
import jpt.sun.tools.javap.ClassWriter;
import jpt.sun.tools.javap.CodeWriter;
import jpt.sun.tools.javap.ConstantWriter;
import jpt.sun.tools.javap.Context;
import jpt.sun.tools.javap.Messages;
import jpt30.lang.model.element.AnnotationMirror;
import jpt30.lang.model.element.AnnotationValue;
import jpt30.lang.model.element.AnnotationValueVisitor;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.ModuleElement;
import jpt30.lang.model.element.PackageElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.TypeParameterElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.AbstractElementVisitor9;
import jpt30.tools.JavaFileObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.query.CommentSet;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class CodeGenerator {
    private static final Logger LOG = Logger.getLogger(CodeGenerator.class.getName());
    private static final Set<ElementKind> UNUSABLE_KINDS = EnumSet.of(ElementKind.PACKAGE);
    private static final byte VERSION = 2;
    private static final String HASH_ATTRIBUTE_NAME = "origin-hash";
    private static final String DISABLE_ERRORS = "disable-java-errors";
    static final String CLASSFILE_ROOT = "classfile-root";
    static final String CLASSFILE_BINNAME = "classfile-binaryName";
    static final String CLASSFILE_SOURCEFILE = "classfile-sourcefile";
    private static final Map<List<ElementKind>, Set<Modifier>> IMPLICIT_MODIFIERS = new HashMap<List<ElementKind>, Set<Modifier>>();

    public static FileObject generateCode(ClasspathInfo cpInfo, ElementHandle<? extends Element> toOpenHandle) {
        return CodeGenerator.generateCode(cpInfo, toOpenHandle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject generateCode(final ClasspathInfo cpInfo, final ElementHandle<? extends Element> toOpenHandle, final boolean[] trySourceAttr) {
        if (UNUSABLE_KINDS.contains((Object)toOpenHandle.getKind())) {
            return null;
        }
        try {
            FileObject file = FileUtil.createMemoryFileSystem().getRoot().createData(toOpenHandle.getKind() == ElementKind.MODULE ? "module-info.java" : "test.java");
            try (OutputStream out = file.getOutputStream();){
                FileUtil.copy(new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8)), out);
            }
            JavaSource js = JavaSource.create(cpInfo, file);
            final FileObject[] result = new FileObject[1];
            final boolean[] sourceGenerated = new boolean[1];
            final URL[] classfileRoot = new URL[1];
            final String[] binaryName = new String[1];
            ModificationResult r = js.runModificationTask(new Task<WorkingCopy>(){

                @Override
                public void run(WorkingCopy wc) throws Exception {
                    FileObject root;
                    FileObject resource;
                    String binName;
                    wc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    Object toOpen = toOpenHandle.resolve(wc);
                    if (toOpen != null && toOpen.getKind() == ElementKind.MODULE) {
                        binName = "module-info";
                        JavaFileObject jfo = ((Symbol.ModuleSymbol)toOpen).module_info.classfile;
                        FileObject fileObject = resource = jfo != null ? URLMapper.findFileObject(jfo.toUri().toURL()) : null;
                        if (resource == null) {
                            LOG.info("Cannot find resource for module: " + ((ModuleElement)toOpen).getQualifiedName());
                            return;
                        }
                        root = resource.getParent();
                    } else {
                        FileObject found;
                        String name;
                        TypeElement te;
                        ClassPath cp = ClassPathSupport.createProxyClassPath(cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT), cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE), cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE));
                        TypeElement typeElement = te = toOpen != null ? wc.getElementUtilities().outermostTypeElement((Element)toOpen) : null;
                        if (trySourceAttr != null && (name = SourceUtils.findSourceFileName(toOpen)) != null && (found = SourceUtils.getFile(toOpenHandle, cpInfo, name)) != null) {
                            result[0] = found;
                            trySourceAttr[0] = true;
                            return;
                        }
                        if (te == null) {
                            LOG.info("Cannot resolve element: " + toOpenHandle.toString() + " on classpath: " + cp.toString());
                            return;
                        }
                        binName = te.getQualifiedName().toString().replace('.', '/');
                        String resourceName = binName + ".class";
                        resource = cp.findResource(resourceName);
                        if (resource == null) {
                            LOG.info("Cannot find resource: " + resourceName + " on classpath: " + cp.toString());
                            return;
                        }
                        root = cp.findOwnerRoot(resource);
                        if (root == null) {
                            LOG.info("Cannot find owner of: " + FileUtil.getFileDisplayName(resource) + " on classpath: " + cp.toString());
                            return;
                        }
                        toOpen = te;
                    }
                    classfileRoot[0] = root.toURL();
                    binaryName[0] = binName;
                    File sourceRoot = new File(JavaIndex.getIndex(root.toURL()), "gensrc");
                    FileObject sourceRootFO = FileUtil.createFolder(sourceRoot);
                    if (sourceRootFO == null) {
                        LOG.info("Cannot create folder: " + sourceRoot);
                        return;
                    }
                    String path = binName + ".java";
                    FileObject source = sourceRootFO.getFileObject(path);
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    md.update((byte)2);
                    byte[] hashBytes = md.digest(resource.asBytes());
                    StringBuilder hashBuilder = new StringBuilder();
                    for (byte b : hashBytes) {
                        hashBuilder.append(String.format("%02X", b));
                    }
                    String hash = hashBuilder.toString();
                    if (source != null) {
                        result[0] = source;
                        String existingHash = (String)source.getAttribute(CodeGenerator.HASH_ATTRIBUTE_NAME);
                        if (hash.equals(existingHash)) {
                            LOG.fine(FileUtil.getFileDisplayName(source) + " is up to date, reusing from cache.");
                            return;
                        }
                    }
                    String[] betterName = new String[]{null};
                    CompilationUnitTree cut = CodeGenerator.generateCode(wc, toOpen, betterName);
                    wc.rewrite(wc.getCompilationUnit(), cut);
                    if (source == null) {
                        result[0] = FileUtil.createData(sourceRootFO, path);
                        LOG.fine(FileUtil.getFileDisplayName(result[0]) + " does not exist, creating.");
                    } else {
                        LOG.fine(FileUtil.getFileDisplayName(source) + " is not up to date, regenerating.");
                    }
                    result[0].setAttribute(CodeGenerator.HASH_ATTRIBUTE_NAME, hash);
                    if (betterName[0] != null) {
                        result[0].setAttribute(CodeGenerator.CLASSFILE_SOURCEFILE, betterName[0]);
                    }
                    sourceGenerated[0] = true;
                }
            });
            if (sourceGenerated[0]) {
                File resultFile = FileUtil.toFile(result[0]);
                if (resultFile != null && !resultFile.canWrite()) {
                    resultFile.setWritable(true);
                }
                out = result[0].getOutputStream();
                try {
                    FileUtil.copy(new ByteArrayInputStream(r.getResultingSource(file).getBytes(StandardCharsets.UTF_8)), out);
                }
                finally {
                    out.close();
                }
                if (resultFile != null) {
                    resultFile.setReadOnly();
                    result[0].setAttribute(DISABLE_ERRORS, true);
                    result[0].setAttribute(CLASSFILE_ROOT, classfileRoot[0]);
                    result[0].setAttribute(CLASSFILE_BINNAME, binaryName[0]);
                }
            }
            return result[0];
        }
        catch (IOException ex) {
            Exceptions.printStackTrace(ex);
            return null;
        }
    }

    static CompilationUnitTree generateCode(WorkingCopy wc, Element te, String[] name) {
        TreeMaker make = wc.getTreeMaker();
        TreeBuilder b = new TreeBuilder(make, wc);
        Tree clazz = (Tree)b.visit(te);
        CompilationUnitTree cut = make.CompilationUnit(te.getKind() == ElementKind.MODULE ? null : make.Identifier(((PackageElement)te.getEnclosingElement()).getQualifiedName()), Collections.emptyList(), Collections.singletonList(clazz), wc.getCompilationUnit().getSourceFile());
        name[0] = b.sourceFileName;
        return cut;
    }

    private CodeGenerator() {
    }

    static {
        IMPLICIT_MODIFIERS.put(Arrays.asList(ElementKind.ENUM), EnumSet.of(Modifier.STATIC, Modifier.ABSTRACT, Modifier.FINAL));
        IMPLICIT_MODIFIERS.put(Arrays.asList(ElementKind.ANNOTATION_TYPE), EnumSet.of(Modifier.STATIC, Modifier.ABSTRACT));
        IMPLICIT_MODIFIERS.put(Arrays.asList(ElementKind.METHOD, ElementKind.ANNOTATION_TYPE), EnumSet.of(Modifier.ABSTRACT));
        IMPLICIT_MODIFIERS.put(Arrays.asList(ElementKind.METHOD, ElementKind.INTERFACE), EnumSet.of(Modifier.ABSTRACT));
    }

    private static final class TreeBuilder
    extends AbstractElementVisitor9<Tree, Void> {
        private final TreeMaker make;
        private final WorkingCopy wc;
        private ClassFile cf;
        private Map<String, Method> sig2Method;
        String sourceFileName;

        public TreeBuilder(TreeMaker make, WorkingCopy wc) {
            this.make = make;
            this.wc = wc;
        }

        @Override
        public Tree visitPackage(PackageElement e, Void p) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Tree visitModule(ModuleElement e, Void p) {
            ModifiersTree mods = this.make.Modifiers(e.getModifiers());
            ModuleTree.ModuleKind kind = this.wc.getElementUtilities().isOpen(e) ? ModuleTree.ModuleKind.OPEN : ModuleTree.ModuleKind.STRONG;
            LinkedList<DirectiveTree> directives = new LinkedList<DirectiveTree>();
            for (ModuleElement.Directive directive : e.getDirectives()) {
                switch (directive.getKind()) {
                    case EXPORTS: {
                        ModuleElement.ExportsDirective expDirective = (ModuleElement.ExportsDirective)directive;
                        directives.add(this.make.Exports(this.make.QualIdent(expDirective.getPackage()), this.constructModuleList(expDirective.getTargetModules())));
                        break;
                    }
                    case OPENS: {
                        ModuleElement.OpensDirective opensDirective = (ModuleElement.OpensDirective)directive;
                        directives.add(this.make.Opens(this.make.QualIdent(opensDirective.getPackage()), this.constructModuleList(opensDirective.getTargetModules())));
                        break;
                    }
                    case PROVIDES: {
                        ModuleElement.ProvidesDirective provDirective = (ModuleElement.ProvidesDirective)directive;
                        directives.add(this.make.Provides(this.make.QualIdent(provDirective.getService()), this.constructTypeList(provDirective.getImplementations())));
                        break;
                    }
                    case REQUIRES: {
                        ModuleElement.RequiresDirective reqDirective = (ModuleElement.RequiresDirective)directive;
                        directives.add(this.make.Requires(reqDirective.isTransitive(), reqDirective.isStatic(), this.make.QualIdent(reqDirective.getDependency().getQualifiedName().toString())));
                        break;
                    }
                    case USES: {
                        ModuleElement.UsesDirective usesDirective = (ModuleElement.UsesDirective)directive;
                        directives.add(this.make.Uses(this.make.QualIdent(usesDirective.getService())));
                    }
                }
            }
            return this.addDeprecated(e, this.make.Module(mods, kind, this.make.QualIdent(e.getQualifiedName().toString()), directives));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Tree visitType(TypeElement e, Void p) {
            ClassFile oldCf = this.cf;
            Map<String, Method> oldMethods = this.sig2Method;
            this.cf = null;
            this.sig2Method = new HashMap<String, Method>();
            try {
                block24: {
                    try {
                        JavaFileObject classfile = ((Symbol.ClassSymbol)e).classfile;
                        if (classfile == null || classfile.getKind() != JavaFileObject.Kind.CLASS) break block24;
                        try (InputStream in = classfile.openInputStream();){
                            this.cf = ClassFile.read(in);
                            Attribute classTree = this.cf.getAttribute("SourceFile");
                            if (classTree instanceof SourceFile_attribute) {
                                Method[] sfa = (Method[])classTree;
                                this.sourceFileName = sfa.getSourceFile(this.cf.constant_pool);
                            }
                            for (Method m : this.cf.methods) {
                                this.sig2Method.put(this.cf.constant_pool.getUTF8Value(m.name_index) + ":" + this.cf.constant_pool.getUTF8Value(m.descriptor.index), m);
                            }
                        }
                    }
                    catch (ConstantPoolException ex) {
                        Exceptions.printStackTrace(ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace(ex);
                    }
                }
                LinkedList<Tree> members = new LinkedList<Tree>();
                for (Element element : e.getEnclosedElements()) {
                    Tree member;
                    if (element.getKind() == ElementKind.RECORD_COMPONENT || (member = (Tree)this.visit(element)) == null) continue;
                    members.add(member);
                }
                ModifiersTree mods = this.computeMods(e);
                switch (e.getKind()) {
                    case CLASS: {
                        ClassTree classTree = this.addDeprecated(e, this.make.Class(mods, e.getSimpleName(), this.constructTypeParams(e.getTypeParameters()), this.computeSuper(e.getSuperclass()), this.computeSuper(e.getInterfaces()), this.computeSuper(e.getPermittedSubclasses()), members));
                        return classTree;
                    }
                    case INTERFACE: {
                        ClassTree classTree = this.addDeprecated(e, this.make.Interface(mods, e.getSimpleName(), this.constructTypeParams(e.getTypeParameters()), this.computeSuper(e.getInterfaces()), this.computeSuper(e.getPermittedSubclasses()), members));
                        return classTree;
                    }
                    case ENUM: {
                        ClassTree classTree = this.addDeprecated(e, this.make.Enum(mods, e.getSimpleName(), this.computeSuper(e.getInterfaces()), members));
                        return classTree;
                    }
                    case RECORD: {
                        ClassTree classTree = this.addDeprecated(e, this.make.Class(mods, e.getSimpleName(), this.constructTypeParams(e.getTypeParameters()), null, this.computeSuper(e.getInterfaces()), List.of(), members));
                        return classTree;
                    }
                    case ANNOTATION_TYPE: {
                        ClassTree classTree = this.addDeprecated(e, this.make.AnnotationType(mods, e.getSimpleName(), members));
                        return classTree;
                    }
                }
                throw new UnsupportedOperationException();
            }
            finally {
                this.cf = oldCf;
                this.sig2Method = oldMethods;
            }
        }

        private ModifiersTree computeMods(Element e) {
            Set<Modifier> implicitModifiers = IMPLICIT_MODIFIERS.get(Arrays.asList(e.getKind()));
            if (implicitModifiers == null) {
                implicitModifiers = IMPLICIT_MODIFIERS.get(Arrays.asList(e.getKind(), e.getEnclosingElement().getKind()));
            }
            EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
            modifiers.addAll(e.getModifiers());
            if (implicitModifiers != null) {
                modifiers.removeAll(implicitModifiers);
            }
            LinkedList<AnnotationTree> annotations = new LinkedList<AnnotationTree>();
            for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
                annotations.add(this.computeAnnotationTree(annotationMirror));
            }
            return this.make.Modifiers(modifiers, annotations);
        }

        private <T extends Tree> T addDeprecated(Element e, T orig) {
            if (this.wc.getElements().isDeprecated(e)) {
                // empty if block
            }
            return orig;
        }

        private AnnotationTree computeAnnotationTree(AnnotationMirror am) {
            LinkedList<AssignmentTree> params = new LinkedList<AssignmentTree>();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : am.getElementValues().entrySet()) {
                ExpressionTree val = this.createTreeForAnnotationValue(this.make, entry.getValue());
                if (val == null) {
                    LOG.log(Level.WARNING, "Cannot create annotation for: {0}", entry.getValue());
                    continue;
                }
                AssignmentTree vt = this.make.Assignment(this.make.Identifier(entry.getKey().getSimpleName()), val);
                params.add(vt);
            }
            return this.make.Annotation(this.make.Type(am.getAnnotationType()), params);
        }

        private Tree computeSuper(TypeMirror superClass) {
            if (superClass == null) {
                return null;
            }
            if (superClass.getKind() == TypeKind.NONE) {
                return null;
            }
            TypeElement jlObject = this.wc.getElements().getTypeElement("java.lang.Object");
            if (jlObject != null && this.wc.getTypes().isSameType(superClass, jlObject.asType())) {
                return null;
            }
            return this.make.Type(superClass);
        }

        private List<Tree> computeSuper(List<? extends TypeMirror> superTypes) {
            LinkedList<Tree> sup = new LinkedList<Tree>();
            if (superTypes != null) {
                for (TypeMirror typeMirror : superTypes) {
                    sup.add(this.make.Type(typeMirror));
                }
            }
            return sup;
        }

        private List<? extends TypeParameterTree> constructTypeParams(List<? extends TypeParameterElement> params) {
            LinkedList<TypeParameterTree> result = new LinkedList<TypeParameterTree>();
            for (TypeParameterElement typeParameterElement : params) {
                result.add((TypeParameterTree)this.visit(typeParameterElement));
            }
            return result;
        }

        private List<? extends ExpressionTree> constructModuleList(List<? extends ModuleElement> params) {
            LinkedList<ExpressionTree> result = new LinkedList<ExpressionTree>();
            if (params != null) {
                for (ModuleElement moduleElement : params) {
                    result.add(this.make.QualIdent(moduleElement.getQualifiedName().toString()));
                }
            }
            return result;
        }

        private List<? extends ExpressionTree> constructTypeList(List<? extends TypeElement> params) {
            LinkedList<ExpressionTree> result = new LinkedList<ExpressionTree>();
            for (TypeElement typeElement : params) {
                result.add(this.make.QualIdent(typeElement));
            }
            return result;
        }

        @Override
        public Tree visitVariable(VariableElement e, Void p) {
            if (e.getKind() == ElementKind.ENUM_CONSTANT) {
                int mods = 16384;
                ModifiersTree modifiers = this.make.Modifiers(mods, Collections.emptyList());
                return this.make.Variable(modifiers, e.getSimpleName().toString(), this.make.Identifier(e.getEnclosingElement().getSimpleName().toString()), null);
            }
            ModifiersTree mods = this.computeMods(e);
            LiteralTree init = e.getConstantValue() != null ? this.make.Literal(e.getConstantValue()) : null;
            return this.addDeprecated(e, this.make.Variable(mods, e.getSimpleName(), this.make.Type(e.asType()), init));
        }

        @Override
        public Tree visitExecutable(ExecutableElement e, Void p) {
            Attribute code;
            if (e.getKind() == ElementKind.STATIC_INIT || e.getKind() == ElementKind.INSTANCE_INIT) {
                return null;
            }
            if (this.wc.getElementUtilities().isSynthetic(e)) {
                return null;
            }
            if (e.getEnclosingElement().getKind() == ElementKind.ENUM) {
                TypeMirror param;
                if ("values".equals(e.getSimpleName().toString()) && e.getParameters().isEmpty()) {
                    return null;
                }
                if ("valueOf".equals(e.getSimpleName().toString()) && e.getParameters().size() == 1 && (param = e.getParameters().get(0).asType()).getKind() == TypeKind.DECLARED && "java.lang.String".equals(((TypeElement)((DeclaredType)param).asElement()).getQualifiedName().toString())) {
                    return null;
                }
            }
            ModifiersTree mods = this.computeMods(e);
            Tree returnValue = e.getReturnType() != null ? this.make.Type(e.getReturnType()) : null;
            LinkedList<VariableTree> parameters = new LinkedList<VariableTree>();
            for (VariableElement variableElement : e.getParameters()) {
                parameters.add((VariableTree)this.visit(variableElement));
            }
            LinkedList<ExpressionTree> throwsList = new LinkedList<ExpressionTree>();
            for (TypeMirror typeMirror : e.getThrownTypes()) {
                throwsList.add((ExpressionTree)this.make.Type(typeMirror));
            }
            if (e.getModifiers().contains((Object)Modifier.ABSTRACT) || e.getModifiers().contains((Object)Modifier.NATIVE)) {
                ExpressionTree expressionTree = this.createTreeForAnnotationValue(this.make, e.getDefaultValue());
                return this.addDeprecated(e, this.make.Method(mods, (CharSequence)e.getSimpleName(), returnValue, this.constructTypeParams(e.getTypeParameters()), parameters, throwsList, (BlockTree)null, expressionTree));
            }
            MethodTree methodTree = this.make.Method(mods, (CharSequence)e.getSimpleName(), returnValue, this.constructTypeParams(e.getTypeParameters()), parameters, throwsList, "{ }", null);
            String[] stringArray = SourceUtils.getJVMSignature(ElementHandle.create(e));
            Method m = this.sig2Method.get(stringArray[1] + ":" + stringArray[2]);
            CommentHandlerService handler = CommentHandlerService.instance(JavaSourceAccessor.getINSTANCE().getJavacTask(this.wc).getContext());
            CommentSet set = handler.getComments(methodTree.getBody());
            if (m != null && (code = m.attributes.get("Code")) instanceof Code_attribute) {
                Context ctx = new Context();
                StringWriter decompiled = new StringWriter();
                PrintWriter w = new PrintWriter(decompiled);
                ctx.put(PrintWriter.class, w);
                ctx.put(Messages.class, new Messages(){

                    @Override
                    public String getMessage(String key, Object ... args) {
                        return "";
                    }

                    @Override
                    public String getMessage(Locale locale, String key, Object ... args) {
                        return "";
                    }
                });
                ctx.put(ClassWriter.class, new ClassWriter(ctx){
                    {
                        super(context);
                        this.setClassFile(cf);
                    }
                });
                ctx.put(CodeWriter.class, new ConvenientCodeWriter(ctx));
                CodeWriter codeWriter = CodeWriter.instance(ctx);
                codeWriter.writeInstrs((Code_attribute)code);
                codeWriter.writeExceptionTable((Code_attribute)code);
                w.println();
                w.close();
                set.addComment(CommentSet.RelativePosition.INNER, Comment.create(Comment.Style.LINE, "<editor-fold defaultstate=\"collapsed\" desc=\"Compiled Code\">"));
                set.addComment(CommentSet.RelativePosition.INNER, Comment.create(decompiled.toString()));
                set.addComment(CommentSet.RelativePosition.INNER, Comment.create(Comment.Style.LINE, "</editor-fold>"));
            }
            if (!set.hasComments()) {
                set.addComment(CommentSet.RelativePosition.INNER, Comment.create(Comment.Style.LINE, "compiled code"));
            }
            return this.addDeprecated(e, methodTree);
        }

        @Override
        public Tree visitTypeParameter(TypeParameterElement e, Void p) {
            LinkedList<ExpressionTree> bounds = new LinkedList<ExpressionTree>();
            for (TypeMirror typeMirror : e.getBounds()) {
                bounds.add((ExpressionTree)this.make.Type(typeMirror));
            }
            return this.make.TypeParameter(e.getSimpleName(), bounds);
        }

        private ExpressionTree createTreeForAnnotationValue(final TreeMaker make, AnnotationValue def) {
            if (def == null) {
                return null;
            }
            return def.accept(new AnnotationValueVisitor<ExpressionTree, Void>(){

                @Override
                public ExpressionTree visit(AnnotationValue av, Void p) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public ExpressionTree visit(AnnotationValue av) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                @Override
                public ExpressionTree visitBoolean(boolean b, Void p) {
                    return make.Literal(b);
                }

                @Override
                public ExpressionTree visitByte(byte b, Void p) {
                    return make.Literal(b);
                }

                @Override
                public ExpressionTree visitChar(char c, Void p) {
                    return make.Literal(Character.valueOf(c));
                }

                @Override
                public ExpressionTree visitDouble(double d, Void p) {
                    return make.Literal(d);
                }

                @Override
                public ExpressionTree visitFloat(float f, Void p) {
                    return make.Literal(Float.valueOf(f));
                }

                @Override
                public ExpressionTree visitInt(int i, Void p) {
                    return make.Literal(i);
                }

                @Override
                public ExpressionTree visitLong(long i, Void p) {
                    return make.Literal(i);
                }

                @Override
                public ExpressionTree visitShort(short s, Void p) {
                    return make.Literal(s);
                }

                @Override
                public ExpressionTree visitString(String s, Void p) {
                    return make.Literal(s);
                }

                @Override
                public ExpressionTree visitType(TypeMirror t, Void p) {
                    return make.MemberSelect((ExpressionTree)make.Type(t), "class");
                }

                @Override
                public ExpressionTree visitEnumConstant(VariableElement c, Void p) {
                    return make.QualIdent(c);
                }

                @Override
                public ExpressionTree visitAnnotation(AnnotationMirror a, Void p) {
                    return this.computeAnnotationTree(a);
                }

                @Override
                public ExpressionTree visitArray(List<? extends AnnotationValue> vals, Void p) {
                    LinkedList<ExpressionTree> values = new LinkedList<ExpressionTree>();
                    for (AnnotationValue annotationValue : vals) {
                        ExpressionTree val = this.createTreeForAnnotationValue(make, annotationValue);
                        if (val == null) {
                            LOG.log(Level.WARNING, "Cannot create annotation for: {0}", annotationValue);
                            continue;
                        }
                        values.add(val);
                    }
                    return make.NewArray(null, Collections.emptyList(), values);
                }

                @Override
                public ExpressionTree visitUnknown(AnnotationValue av, Void p) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            }, null);
        }
    }

    private static final class ConvenientCodeWriter
    extends CodeWriter {
        private final ConstantWriter constantWriter;
        private static final Set<Opcode> INSTRUCTION_WITH_REFERENCE = EnumSet.of(Opcode.LDC, new Opcode[]{Opcode.LDC_W, Opcode.LDC2_W, Opcode.GETSTATIC, Opcode.PUTSTATIC, Opcode.GETFIELD, Opcode.PUTFIELD, Opcode.INVOKEVIRTUAL, Opcode.INVOKESPECIAL, Opcode.INVOKESTATIC, Opcode.INVOKEINTERFACE, Opcode.NEW, Opcode.ANEWARRAY, Opcode.CHECKCAST, Opcode.INSTANCEOF});

        public ConvenientCodeWriter(Context context) {
            super(context);
            this.constantWriter = ConstantWriter.instance(context);
        }

        @Override
        public void writeInstr(Instruction instr) {
            super.writeInstr(instr);
        }
    }
}

