/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.Dependency;
import org.apache.maven.api.Node;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.impl.AbstractNode;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.MappedList;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;

public class DefaultNode
extends AbstractNode {
    @Nonnull
    protected final InternalSession session;
    @Nonnull
    protected final DependencyNode node;
    protected final boolean verbose;

    public DefaultNode(@Nonnull InternalSession session, @Nonnull DependencyNode node, boolean verbose) {
        this.session = session;
        this.node = node;
        this.verbose = verbose;
    }

    @Override
    DependencyNode getDependencyNode() {
        return this.node;
    }

    public Artifact getArtifact() {
        return this.node.getArtifact() != null ? this.session.getArtifact(this.node.getArtifact()) : null;
    }

    public Dependency getDependency() {
        return this.node.getDependency() != null ? this.session.getDependency(this.node.getDependency()) : null;
    }

    public List<Node> getChildren() {
        return new MappedList<Node, DependencyNode>(this.node.getChildren(), n -> this.session.getNode((DependencyNode)n, this.verbose));
    }

    public List<RemoteRepository> getRemoteRepositories() {
        return new MappedList<RemoteRepository, org.eclipse.aether.repository.RemoteRepository>(this.node.getRepositories(), this.session::getRemoteRepository);
    }

    public Optional<RemoteRepository> getRepository() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public String asString() {
        String originalScope;
        String preManagedScope;
        String nodeString = super.asString();
        if (!this.verbose) {
            return nodeString;
        }
        DependencyNode node = this.getDependencyNode();
        ArrayList<String> details = new ArrayList<String>();
        DependencyNode winner = (DependencyNode)node.getData().get("conflict.winner");
        String winnerVersion = winner != null ? winner.getArtifact().getBaseVersion() : null;
        boolean included = winnerVersion == null;
        String preManagedVersion = DependencyManagerUtils.getPremanagedVersion((DependencyNode)node);
        if (preManagedVersion != null) {
            details.add("version managed from " + preManagedVersion);
        }
        if ((preManagedScope = DependencyManagerUtils.getPremanagedScope((DependencyNode)node)) != null) {
            details.add("scope managed from " + preManagedScope);
        }
        if ((originalScope = (String)node.getData().get("conflict.originalScope")) != null && !originalScope.equals(node.getDependency().getScope())) {
            details.add("scope updated from " + originalScope);
        }
        if (!included) {
            if (Objects.equals(winnerVersion, node.getArtifact().getVersion())) {
                details.add("omitted for duplicate");
            } else {
                details.add("omitted for conflict with " + winnerVersion);
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (included) {
            buffer.append(nodeString);
            if (!details.isEmpty()) {
                buffer.append(" (");
                DefaultNode.join(buffer, details, "; ");
                buffer.append(")");
            }
        } else {
            buffer.append("(");
            buffer.append(nodeString);
            if (!details.isEmpty()) {
                buffer.append(" - ");
                DefaultNode.join(buffer, details, "; ");
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    private static void join(StringBuilder buffer, List<String> details, String separator) {
        boolean first = true;
        for (String detail : details) {
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(detail);
        }
    }
}

