/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.logging;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Objects;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.cli.Logger;

public class SystemLogger
implements Logger {
    private final PrintWriter out;
    private final Logger.Level threshold;

    public SystemLogger(@Nullable OutputStream out) {
        this(out, null);
    }

    public SystemLogger(@Nullable OutputStream out, @Nullable Logger.Level threshold) {
        this.out = new PrintWriter(this.toPsOrDef(out, System.err), true);
        this.threshold = Objects.requireNonNullElse(threshold, Logger.Level.INFO);
    }

    private PrintStream toPsOrDef(OutputStream outputStream, PrintStream def) {
        if (outputStream == null) {
            return def;
        }
        if (outputStream instanceof PrintStream) {
            PrintStream ps = (PrintStream)outputStream;
            return ps;
        }
        return new PrintStream(outputStream, true);
    }

    public void log(Logger.Level level, String message, Throwable error) {
        Objects.requireNonNull(level, "level");
        Objects.requireNonNull(message, "message");
        if (level.ordinal() >= this.threshold.ordinal()) {
            this.out.println("[" + level.name() + "] " + message);
            if (error != null) {
                error.printStackTrace(this.out);
            }
        }
    }
}

