/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.util.Bits;

class MergeReaderWrapper
extends LeafReader {
    final CodecReader in;
    final FieldsProducer fields;
    final NormsProducer norms;
    final DocValuesProducer docValues;
    final StoredFieldsReader store;
    final TermVectorsReader vectors;

    MergeReaderWrapper(CodecReader in) throws IOException {
        this.in = in;
        FieldsProducer fields = in.getPostingsReader();
        if (fields != null) {
            fields = fields.getMergeInstance();
        }
        this.fields = fields;
        NormsProducer norms = in.getNormsReader();
        if (norms != null) {
            norms = norms.getMergeInstance();
        }
        this.norms = norms;
        DocValuesProducer docValues = in.getDocValuesReader();
        if (docValues != null) {
            docValues = docValues.getMergeInstance();
        }
        this.docValues = docValues;
        StoredFieldsReader store = in.getFieldsReader();
        if (store != null) {
            store = store.getMergeInstance();
        }
        this.store = store;
        TermVectorsReader vectors = in.getTermVectorsReader();
        if (vectors != null) {
            vectors = vectors.getMergeInstance();
        }
        this.vectors = vectors;
    }

    public Terms terms(String field) throws IOException {
        this.ensureOpen();
        if (this.fields == null) {
            return null;
        }
        return this.fields.terms(field);
    }

    public NumericDocValues getNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.NUMERIC) {
            return null;
        }
        return this.docValues.getNumeric(fi);
    }

    public BinaryDocValues getBinaryDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.BINARY) {
            return null;
        }
        return this.docValues.getBinary(fi);
    }

    public SortedDocValues getSortedDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.SORTED) {
            return null;
        }
        return this.docValues.getSorted(fi);
    }

    public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.SORTED_NUMERIC) {
            return null;
        }
        return this.docValues.getSortedNumeric(fi);
    }

    public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        if (fi.getDocValuesType() != DocValuesType.SORTED_SET) {
            return null;
        }
        return this.docValues.getSortedSet(fi);
    }

    public NumericDocValues getNormValues(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null || !fi.hasNorms()) {
            return null;
        }
        return this.norms.getNorms(fi);
    }

    public DocValuesSkipper getDocValuesSkipper(String field) throws IOException {
        this.ensureOpen();
        FieldInfo fi = this.getFieldInfos().fieldInfo(field);
        if (fi == null) {
            return null;
        }
        return this.docValues.getSkipper(fi);
    }

    public FieldInfos getFieldInfos() {
        return this.in.getFieldInfos();
    }

    public Bits getLiveDocs() {
        return this.in.getLiveDocs();
    }

    public void checkIntegrity() throws IOException {
        this.in.checkIntegrity();
    }

    public TermVectors termVectors() throws IOException {
        this.ensureOpen();
        if (this.vectors == null) {
            return TermVectors.EMPTY;
        }
        return this.vectors;
    }

    public PointValues getPointValues(String fieldName) throws IOException {
        return this.in.getPointValues(fieldName);
    }

    public FloatVectorValues getFloatVectorValues(String fieldName) throws IOException {
        return this.in.getFloatVectorValues(fieldName);
    }

    public ByteVectorValues getByteVectorValues(String fieldName) throws IOException {
        return this.in.getByteVectorValues(fieldName);
    }

    public void searchNearestVectors(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        this.in.searchNearestVectors(field, target, knnCollector, acceptDocs);
    }

    public void searchNearestVectors(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        this.in.searchNearestVectors(field, target, knnCollector, acceptDocs);
    }

    public int numDocs() {
        return this.in.numDocs();
    }

    public int maxDoc() {
        return this.in.maxDoc();
    }

    public StoredFields storedFields() throws IOException {
        this.ensureOpen();
        return this.store;
    }

    protected void doClose() throws IOException {
        this.in.close();
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return this.in.getCoreCacheHelper();
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    public String toString() {
        return "MergeReaderWrapper(" + String.valueOf(this.in) + ")";
    }

    public LeafMetaData getMetaData() {
        return this.in.getMetaData();
    }
}

