/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jmx.blueprint.codec;

import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.apache.aries.jmx.blueprint.BlueprintMetadataMBean;
import org.apache.aries.jmx.blueprint.codec.BPMetadata;
import org.apache.aries.jmx.blueprint.codec.BPNonNullMetadata;
import org.apache.aries.jmx.blueprint.codec.Util;
import org.osgi.service.blueprint.reflect.CollectionMetadata;
import org.osgi.service.blueprint.reflect.Metadata;

public class BPCollectionMetadata
implements BPNonNullMetadata {
    private String collectionClass;
    private String valueType;
    private BPMetadata[] values;

    public BPCollectionMetadata(CompositeData collection) {
        this.collectionClass = (String)collection.get("CollectionClass");
        this.valueType = (String)collection.get("ValueType");
        Byte[][] arrays = (Byte[][])collection.get("Values");
        this.values = new BPMetadata[arrays.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = Util.boxedBinary2BPMetadata(arrays[i]);
        }
    }

    public BPCollectionMetadata(CollectionMetadata collection) {
        this.collectionClass = collection.getCollectionClass().getCanonicalName();
        this.valueType = collection.getValueType();
        this.values = new BPMetadata[collection.getValues().size()];
        int i = 0;
        for (Object value : collection.getValues()) {
            this.values[i++] = Util.metadata2BPMetadata((Metadata)value);
        }
    }

    @Override
    public CompositeData asCompositeData() {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("CollectionClass", this.collectionClass);
        items.put("ValueType", this.valueType);
        Byte[][] arrays = new Byte[this.values.length][];
        for (int i = 0; i < arrays.length; ++i) {
            arrays[i] = Util.bpMetadata2BoxedBinary(this.values[i]);
        }
        items.put("Values", arrays);
        try {
            return new CompositeDataSupport(BlueprintMetadataMBean.COLLECTION_METADATA_TYPE, items);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCollectionClass() {
        return this.collectionClass;
    }

    public String getValueType() {
        return this.valueType;
    }

    public BPMetadata[] getValues() {
        return this.values;
    }
}

