/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionBuilder;
import org.apache.jena.query.QueryExecutionDatasetBuilder;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.ResultBinding;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecAdapter;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.QueryExecMod;
import org.apache.jena.sparql.exec.QueryExecutionBuilderAdapter;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.sparql.util.Symbol;

public class QueryExecBuilderAdapter
implements QueryExecBuilder {
    protected QueryExecutionBuilder builder;

    protected QueryExecBuilderAdapter(QueryExecutionBuilder builder) {
        this.builder = builder;
    }

    public static QueryExecBuilder adapt(QueryExecutionBuilder builder) {
        Objects.requireNonNull(builder);
        QueryExecBuilder result = builder instanceof QueryExecutionBuilderAdapter ? ((QueryExecutionBuilderAdapter)builder).getExecBuilder() : new QueryExecBuilderAdapter(builder);
        return result;
    }

    public QueryExecutionBuilder getExecBuilder() {
        return this.builder;
    }

    private static <T> Optional<T> tryCast(Class<T> clz, Object obj) {
        Optional result = clz.isInstance(obj) ? Optional.of(clz.cast(obj)) : Optional.empty();
        return result;
    }

    @Override
    public QueryExecMod initialTimeout(long timeout, TimeUnit timeUnit) {
        QueryExecBuilderAdapter.tryCast(QueryExecutionDatasetBuilder.class, this.builder).orElseThrow(() -> new UnsupportedOperationException("QueryExecBuilderAdapter.initialTimeout()")).initialTimeout(timeout, timeUnit);
        return this;
    }

    @Override
    public QueryExecMod overallTimeout(long timeout, TimeUnit timeUnit) {
        QueryExecBuilderAdapter.tryCast(QueryExecutionDatasetBuilder.class, this.builder).orElseThrow(() -> new UnsupportedOperationException("QueryExecBuilderAdapter.overallTimeout()")).overallTimeout(timeout, timeUnit);
        return this;
    }

    @Override
    public Context getContext() {
        throw new UnsupportedOperationException("QueryExecBuilderAdapter.getContext()");
    }

    @Override
    public QueryExecBuilder query(Query query) {
        this.builder = this.builder.query(query);
        return this;
    }

    @Override
    public QueryExecBuilder query(String queryString) {
        this.builder = this.builder.query(queryString);
        return this;
    }

    @Override
    public QueryExecBuilder query(String queryString, Syntax syntax) {
        this.builder = this.builder.query(queryString, syntax);
        return this;
    }

    @Override
    public QueryExecBuilder parseCheck(boolean parseCheck) {
        this.builder = this.builder.parseCheck(parseCheck);
        return this;
    }

    @Override
    public QueryExecBuilder set(Symbol symbol, Object value) {
        this.builder = this.builder.set(symbol, value);
        return this;
    }

    @Override
    public QueryExecBuilder set(Symbol symbol, boolean value) {
        this.builder = this.builder.set(symbol, value);
        return this;
    }

    @Override
    public QueryExecBuilder context(Context context2) {
        this.builder = this.builder.context(context2);
        return this;
    }

    @Override
    public QueryExecBuilder substitution(Binding binding) {
        this.builder = this.builder.substitution(new ResultBinding(null, binding));
        return this;
    }

    @Override
    public QueryExecBuilder substitution(Var var, Node value) {
        this.builder = this.builder.substitution(var.getName(), ModelUtils.convertGraphNodeToRDFNode(value));
        return this;
    }

    @Override
    public QueryExecBuilder timeout(long timeout, TimeUnit timeUnit) {
        this.builder = this.builder.timeout(timeout, timeUnit);
        return this;
    }

    @Override
    public QueryExecBuilder timeout(long timeout) {
        return this.timeout(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public QueryExec build() {
        QueryExecution qExec = this.builder.build();
        QueryExec result = QueryExecAdapter.adapt(qExec);
        return result;
    }
}

