/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.io.PrintWriter;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.OptTrace;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizableList;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.util.JBitSet;

public class DefaultOptTrace
implements OptTrace {
    private StringBuilder _buffer = new StringBuilder();

    @Override
    public void traceStartStatement(String string) {
        this.appendTraceString(string);
    }

    @Override
    public void traceStartQueryBlock(long l, int n, OptimizableList optimizableList) {
        this.appendTraceString("Optimization started at time " + l + " using optimizer " + n);
    }

    @Override
    public void traceEndQueryBlock() {
    }

    @Override
    public void traceTimeout(long l, CostEstimate costEstimate) {
        this.appendTraceString("Optimization time exceeded at time " + l + "\n" + String.valueOf(costEstimate));
    }

    @Override
    public void traceVacuous() {
        this.appendTraceString("No tables to optimize.");
    }

    @Override
    public void traceCompleteJoinOrder() {
        this.appendTraceString("We have a complete join order.");
    }

    @Override
    public void traceSortCost(CostEstimate costEstimate, CostEstimate costEstimate2) {
        this.appendTraceString("Cost of sorting is " + String.valueOf(costEstimate));
        this.appendTraceString("Total cost of non-sort-avoidance plan with sort cost added is " + String.valueOf(costEstimate2));
    }

    @Override
    public void traceNoBestPlan() {
        this.appendTraceString("No best plan found.");
    }

    @Override
    public void traceModifyingAccessPaths(int n) {
        this.appendTraceString("Modifying access paths using optimizer " + n);
    }

    @Override
    public void traceShortCircuiting(boolean bl, Optimizable optimizable, int n) {
        String string;
        String string2 = string = bl ? "time exceeded" : "cost";
        if (optimizable.getBestAccessPath().getCostEstimate() == null) {
            string = "no best plan found";
        }
        this.appendTraceString("Short circuiting based on " + string + " at join position " + n);
    }

    @Override
    public void traceSkippingJoinOrder(int n, int n2, int[] nArray, JBitSet jBitSet) {
        this.appendTraceString(this.reportJoinOrder("\n\nSkipping join order: ", true, n, n2, nArray, jBitSet));
    }

    @Override
    public void traceIllegalUserJoinOrder() {
        this.appendTraceString("User specified join order is not legal.");
    }

    @Override
    public void traceUserJoinOrderOptimized() {
        this.appendTraceString("User-specified join order has now been optimized.");
    }

    @Override
    public void traceJoinOrderConsideration(int n, int[] nArray, JBitSet jBitSet) {
        this.appendTraceString(this.reportJoinOrder("\n\nConsidering join order: ", false, 0, n, nArray, jBitSet));
    }

    @Override
    public void traceCostWithoutSortAvoidance(CostEstimate costEstimate) {
        this.appendTraceString("Total cost of non-sort-avoidance plan is " + String.valueOf(costEstimate));
    }

    @Override
    public void traceCostWithSortAvoidance(CostEstimate costEstimate) {
        this.appendTraceString("Total cost of sort avoidance plan is " + String.valueOf(costEstimate));
    }

    @Override
    public void traceCurrentPlanAvoidsSort(CostEstimate costEstimate, CostEstimate costEstimate2) {
        this.appendTraceString("Current plan is a sort avoidance plan.\n\tBest cost is : " + String.valueOf(costEstimate) + "\n\tThis cost is : " + String.valueOf(costEstimate2));
    }

    @Override
    public void traceCheapestPlanSoFar(int n, CostEstimate costEstimate) {
        this.appendTraceString("This is the cheapest plan so far.");
        this.appendTraceString("Plan is a " + (n == 1 ? "normal" : "sort avoidance") + " plan.");
        this.appendTraceString("Cost of cheapest plan is " + String.valueOf(costEstimate));
    }

    @Override
    public void traceSortNeededForOrdering(int n, RequiredRowOrdering requiredRowOrdering) {
        this.appendTraceString("Sort needed for ordering: " + (n != 2) + "\n\tRow ordering: " + String.valueOf(requiredRowOrdering));
    }

    @Override
    public void traceRememberingBestJoinOrder(int n, int[] nArray, int n2, CostEstimate costEstimate, JBitSet jBitSet) {
        this.appendTraceString(this.reportJoinOrder("\n\nRemembering join order as best: ", false, 0, n, nArray, jBitSet));
    }

    @Override
    public void traceSkippingBecauseTooMuchMemory(int n) {
        this.appendTraceString("Skipping access path due to excess memory usage, maximum is " + n);
    }

    @Override
    public void traceCostOfNScans(int n, double d, CostEstimate costEstimate) {
        this.appendTraceString("Cost of " + d + " scans is: " + String.valueOf(costEstimate) + " for table " + n);
    }

    @Override
    public void traceSkipUnmaterializableHashJoin() {
        this.appendTraceString("Skipping HASH JOIN because optimizable is not materializable");
    }

    @Override
    public void traceSkipHashJoinNoHashKeys() {
        this.appendTraceString("Skipping HASH JOIN because there are no hash key columns");
    }

    @Override
    public void traceHashKeyColumns(int[] nArray) {
        String string = "# hash key columns = " + nArray.length;
        for (int i = 0; i < nArray.length; ++i) {
            string = "\n" + string + "hashKeyColumns[" + i + "] = " + nArray[i];
        }
        this.appendTraceString(string);
    }

    @Override
    public void traceOptimizingJoinNode() {
        this.appendTraceString("Calling optimizeIt() for join node");
    }

    @Override
    public void traceConsideringJoinStrategy(JoinStrategy joinStrategy, int n) {
        this.appendTraceString("\nConsidering join strategy " + String.valueOf(joinStrategy) + " for table " + n);
    }

    @Override
    public void traceRememberingBestAccessPath(AccessPath accessPath, int n, int n2) {
        this.appendTraceString("Remembering access path " + String.valueOf(accessPath) + " as truly the best for table " + n + " for plan type " + (n2 == 1 ? " normal " : "sort avoidance") + "\n");
    }

    @Override
    public void traceNoMoreConglomerates(int n) {
        this.appendTraceString("No more conglomerates to consider for table " + n);
    }

    @Override
    public void traceConsideringConglomerate(ConglomerateDescriptor conglomerateDescriptor, int n) {
        this.appendTraceString("\nConsidering conglomerate " + this.reportConglomerateDescriptor(conglomerateDescriptor) + " for table " + n);
    }

    @Override
    public void traceScanningHeapWithUniqueKey() {
        this.appendTraceString("Scanning heap, but we have a full match on a unique key.");
    }

    @Override
    public void traceAddingUnorderedOptimizable(int n) {
        this.appendTraceString("Adding unordered optimizable, # of predicates = " + n);
    }

    @Override
    public void traceChangingAccessPathForTable(int n) {
        this.appendTraceString("Changing access path for table " + n);
    }

    @Override
    public void traceNoStartStopPosition() {
        this.appendTraceString("Lock mode set to MODE_TABLE because no start or stop position");
    }

    @Override
    public void traceNonCoveringIndexCost(double d, int n) {
        this.appendTraceString("Index does not cover query - cost including base row fetch is: " + d + " for table " + n);
    }

    @Override
    public void traceConstantStartStopPositions() {
        this.appendTraceString("Lock mode set to MODE_RECORD because all start and stop positions are constant");
    }

    @Override
    public void traceEstimatingCostOfConglomerate(ConglomerateDescriptor conglomerateDescriptor, int n) {
        String string = this.reportConglomerateDescriptor(conglomerateDescriptor);
        this.appendTraceString("Estimating cost of conglomerate: " + this.reportCostForTable(string, n));
    }

    @Override
    public void traceLookingForSpecifiedIndex(String string, int n) {
        this.appendTraceString("Looking for user-specified index: " + string + " for table " + n);
    }

    @Override
    public void traceSingleMatchedRowCost(double d, int n) {
        this.appendTraceString("Guaranteed to match a single row - cost is: " + d + " for table " + n);
    }

    @Override
    public void traceCostIncludingExtra1stColumnSelectivity(CostEstimate costEstimate, int n) {
        this.appendTraceString("Cost including extra first column selectivity is : " + String.valueOf(costEstimate) + " for table " + n);
    }

    @Override
    public void traceNextAccessPath(String string, int n) {
        this.appendTraceString("Calling nextAccessPath() for base table " + string + " with " + n + " predicates.");
    }

    @Override
    public void traceCostIncludingExtraStartStop(CostEstimate costEstimate, int n) {
        this.appendTraceString(this.reportCostIncluding("start/stop", costEstimate, n));
    }

    @Override
    public void traceCostIncludingExtraQualifierSelectivity(CostEstimate costEstimate, int n) {
        this.appendTraceString(this.reportCostIncluding("qualifier", costEstimate, n));
    }

    @Override
    public void traceCostIncludingExtraNonQualifierSelectivity(CostEstimate costEstimate, int n) {
        this.appendTraceString(this.reportCostIncluding("non-qualifier", costEstimate, n));
    }

    @Override
    public void traceCostOfNoncoveringIndex(CostEstimate costEstimate, int n) {
        this.appendTraceString("Index does not cover query: cost including row fetch is: " + this.reportCostForTable(costEstimate, n));
    }

    @Override
    public void traceRememberingJoinStrategy(JoinStrategy joinStrategy, int n) {
        this.appendTraceString("\nRemembering join strategy " + String.valueOf(joinStrategy) + " as best for table " + n);
    }

    @Override
    public void traceRememberingBestAccessPathSubstring(AccessPath accessPath, int n) {
        this.appendTraceString("in best access path");
    }

    @Override
    public void traceRememberingBestSortAvoidanceAccessPathSubstring(AccessPath accessPath, int n) {
        this.appendTraceString("in best sort avoidance access path");
    }

    @Override
    public void traceRememberingBestUnknownAccessPathSubstring(AccessPath accessPath, int n) {
        this.appendTraceString("in best unknown access path");
    }

    @Override
    public void traceCostOfConglomerateScan(int n, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, int n2, double d, int n3, double d2, int n4, double d3, int n5, double d4, int n6, double d5) {
        this.appendTraceString("Cost of conglomerate " + this.reportConglomerateDescriptor(conglomerateDescriptor) + " scan for table number " + n + " is : ");
        this.appendTraceString(costEstimate.toString());
        this.appendTraceString("\tNumber of extra first column predicates is : " + n2 + ", extra first column selectivity is : " + d);
        this.appendTraceString("\tNumber of extra start/stop predicates is : " + n3 + ", extra start/stop selectivity is : " + d2);
        this.appendTraceString("\tNumber of start/stop statistics predicates is : " + n4 + ", statistics start/stop selectivity is : " + d3);
        this.appendTraceString("\tNumber of extra qualifiers is : " + n5 + ", extra qualifier selectivity is : " + d4);
        this.appendTraceString("\tNumber of extra non-qualifiers is : " + n6 + ", extra non-qualifier selectivity is : " + d5);
    }

    @Override
    public void traceCostIncludingCompositeSelectivityFromStats(CostEstimate costEstimate, int n) {
        this.appendTraceString(this.reportCostIncluding("selectivity from statistics", costEstimate, n));
    }

    @Override
    public void traceCompositeSelectivityFromStatistics(double d) {
        this.appendTraceString("Selectivity from statistics found. It is " + d);
    }

    @Override
    public void traceCostIncludingStatsForIndex(CostEstimate costEstimate, int n) {
        this.appendTraceString(this.reportCostIncluding("statistics for index being considered", costEstimate, n));
    }

    @Override
    public void printToWriter(PrintWriter printWriter) {
        printWriter.println(this._buffer.toString());
    }

    private String reportJoinOrder(String string, boolean bl, int n, int n2, int[] nArray, JBitSet jBitSet) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        for (int i = 0; i <= n2; ++i) {
            stringBuilder.append(" ").append(nArray[i]);
        }
        if (bl) {
            stringBuilder.append(" ").append(n);
        }
        stringBuilder.append(" with assignedTableMap = ").append(jBitSet).append("\n\n");
        return stringBuilder.toString();
    }

    private String reportConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor) {
        Object object = "";
        String[] stringArray = conglomerateDescriptor.getColumnNames();
        if (conglomerateDescriptor.isIndex() && stringArray != null) {
            IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
            int[] nArray = indexRowGenerator.baseColumnPositions();
            object = ", key columns = {" + stringArray[nArray[0] - 1];
            for (int i = 1; i < nArray.length; ++i) {
                object = (String)object + ", " + stringArray[nArray[i] - 1];
            }
            object = (String)object + "}";
        }
        return "CD: conglomerateNumber = " + conglomerateDescriptor.getConglomerateNumber() + " name = " + conglomerateDescriptor.getConglomerateName() + " uuid = " + String.valueOf(conglomerateDescriptor.getUUID()) + " indexable = " + conglomerateDescriptor.isIndex() + (String)object;
    }

    private String reportCostForTable(Object object, int n) {
        return String.valueOf(object) + " for table " + n;
    }

    private String reportCostIncluding(String string, CostEstimate costEstimate, int n) {
        return "Cost including extra " + string + " start/stop selectivity is : " + this.reportCostForTable(costEstimate, n);
    }

    private void appendTraceString(String string) {
        this._buffer.append(string);
        this._buffer.append("\n");
    }
}

