/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.meta;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.openjpa.lib.meta.MetaDataIterator;
import org.apache.openjpa.lib.util.ClassUtil;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.MultiClassLoader;

public class ClassMetaDataIterator
implements MetaDataIterator {
    private final ClassLoader _loader;
    private final List<String> _locs;
    private int _loc = -1;
    private final List<URL> _urls = new ArrayList<URL>(3);
    private int _url = -1;

    public ClassMetaDataIterator(Class<?> cls, String suffix, boolean topDown) {
        this(cls, suffix, null, topDown);
    }

    public ClassMetaDataIterator(Class<?> cls, String suffix, ClassLoader loader, boolean topDown) {
        if (cls != null && (cls.isPrimitive() || cls.getName().startsWith("jakarta.") || cls.getName().startsWith("java.") || cls.getName().startsWith("javax."))) {
            this._loader = null;
            this._locs = Collections.emptyList();
            return;
        }
        if (loader == null) {
            ClassLoader clsLoader;
            MultiClassLoader multi = AccessController.doPrivileged(J2DoPrivHelper.newMultiClassLoaderAction());
            multi.addClassLoader(MultiClassLoader.SYSTEM_LOADER);
            multi.addClassLoader(MultiClassLoader.THREAD_LOADER);
            multi.addClassLoader(this.getClass().getClassLoader());
            if (cls != null && (clsLoader = AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(cls))) != null) {
                multi.addClassLoader(clsLoader);
            }
            loader = multi;
        }
        this._loader = loader;
        this._locs = new ArrayList<String>();
        this._locs.add("META-INF/package" + suffix);
        this._locs.add("WEB-INF/package" + suffix);
        this._locs.add("package" + suffix);
        if (!topDown) {
            this._locs.add("system" + suffix);
        }
        if (cls != null) {
            String pkg = ClassUtil.getPackageName(cls).replace('.', '/');
            if (pkg.length() > 0) {
                int idx;
                int start = 0;
                Object upPath = "";
                do {
                    Object path;
                    String pkgName;
                    if ((idx = pkg.indexOf(47, start)) == -1) {
                        pkgName = start == 0 ? pkg : pkg.substring(start);
                        path = pkg + "/";
                    } else {
                        pkgName = pkg.substring(start, idx);
                        path = pkg.substring(0, idx + 1);
                    }
                    this._locs.add((String)path + "package" + suffix);
                    this._locs.add((String)path + pkgName + suffix);
                    this._locs.add((String)upPath + pkgName + suffix);
                    if (idx == -1) {
                        this._locs.add((String)path + ClassUtil.getClassName(cls) + suffix);
                    }
                    start = idx + 1;
                    upPath = path;
                } while (idx != -1);
            } else {
                this._locs.add(cls.getName() + suffix);
            }
        }
        if (topDown) {
            this._locs.add("system" + suffix);
        } else {
            Collections.reverse(this._locs);
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        while (this._url + 1 >= this._urls.size()) {
            Enumeration<URL> e;
            if (++this._loc >= this._locs.size()) {
                return false;
            }
            this._url = -1;
            this._urls.clear();
            try {
                e = AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction(this._loader, this._locs.get(this._loc)));
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
            while (e.hasMoreElements()) {
                this._urls.add(e.nextElement());
            }
        }
        return true;
    }

    @Override
    public URL next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this._urls.get(++this._url);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this._url == -1 || this._url >= this._urls.size()) {
            throw new IllegalStateException();
        }
        try {
            return AccessController.doPrivileged(J2DoPrivHelper.openStreamAction(this._urls.get(this._url)));
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    @Override
    public File getFile() throws IOException {
        if (this._url == -1 || this._url >= this._urls.size()) {
            throw new IllegalStateException();
        }
        File file = new File(URLDecoder.decode(this._urls.get(this._url).getFile()));
        return AccessController.doPrivileged(J2DoPrivHelper.existsAction(file)) != false ? file : null;
    }

    @Override
    public void close() {
    }
}

