/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class LDAPConnectionPoolHealthCheckThread
extends Thread {
    @NotNull
    private final AtomicBoolean stopRequested;
    @NotNull
    private final AbstractConnectionPool pool;
    @NotNull
    private final LinkedBlockingQueue<Object> queue;
    @Nullable
    private volatile Thread thread;

    LDAPConnectionPoolHealthCheckThread(@NotNull AbstractConnectionPool pool) {
        this.setName("Health Check Thread for " + pool.toString());
        this.setDaemon(true);
        this.pool = pool;
        this.stopRequested = new AtomicBoolean(false);
        this.queue = new LinkedBlockingQueue(1);
        this.thread = null;
    }

    @Override
    public void run() {
        this.thread = Thread.currentThread();
        long lastCheckTime = System.currentTimeMillis();
        while (!this.stopRequested.get()) {
            long timeSinceLastCheck = System.currentTimeMillis() - lastCheckTime;
            if (timeSinceLastCheck >= this.pool.getHealthCheckIntervalMillis()) {
                try {
                    this.pool.doHealthCheck();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                try {
                    this.pool.getHealthCheck().performPoolMaintenance(this.pool);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
                lastCheckTime = System.currentTimeMillis();
                continue;
            }
            long sleepTime = Math.min(this.pool.getHealthCheckIntervalMillis() - timeSinceLastCheck, 30000L);
            try {
                this.queue.poll(sleepTime, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.thread = null;
    }

    void stopRunning(boolean wait) {
        block3: {
            Thread t;
            this.stopRequested.set(true);
            this.wakeUp();
            if (wait && (t = this.thread) != null) {
                try {
                    t.join();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    if (!(e instanceof InterruptedException)) break block3;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    void wakeUp() {
        this.queue.offer(new Object());
    }
}

