/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.DisabledJavaSerializer;
import org.apache.pekko.serialization.JavaSerializer$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.util.ClassLoaderObjectInputStream;
import scala.Function0;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.DynamicVariable;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005r!B\b\u0011\u0011\u0003Ib!B\u000e\u0011\u0011\u0003a\u0002\"B\u0012\u0002\t\u0003!\u0003bB\u0013\u0002\u0005\u0004%\tA\n\u0005\u0007'\u0006\u0001\u000b\u0011B\u0014\u0007\t%\n!A\u000b\u0005\u0006G\u0015!\ta\u000e\u0005\u0006q\u0015!\t!\u000f\u0004\u00057A\u0001A\u000b\u0003\u0005Y\u0011\t\u0015\r\u0011\"\u0001Z\u0011!Q\u0006B!A!\u0002\u0013\t\u0004\"B\u0012\t\t\u0003Y\u0006\"\u00020\t\t\u0003y\u0006\"B2\t\t\u0003!\u0007\"B7\t\t\u0003q\u0017A\u0004&bm\u0006\u001cVM]5bY&TXM\u001d\u0006\u0003#I\tQb]3sS\u0006d\u0017N_1uS>t'BA\n\u0015\u0003\u0015\u0001Xm[6p\u0015\t)b#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002/\u0005\u0019qN]4\u0004\u0001A\u0011!$A\u0007\u0002!\tq!*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0016\u00148CA\u0001\u001e!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!G\u0001\u000eGV\u0014(/\u001a8u'f\u001cH/Z7\u0016\u0003\u001d\u0002\"\u0001K\u0003\u000e\u0003\u0005\u0011QbQ;se\u0016tGoU=ti\u0016l7CA\u0003,!\ras&M\u0007\u0002[)\u0011afH\u0001\u0005kRLG.\u0003\u00021[\tyA)\u001f8b[&\u001cg+\u0019:jC\ndW\r\u0005\u00023k5\t1G\u0003\u00025%\u0005)\u0011m\u0019;pe&\u0011ag\r\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u000b\u0002O\u0005Iq/\u001b;i-\u0006dW/Z\u000b\u0003uu\"2a\u000f$I!\taT\b\u0004\u0001\u0005\u000by:!\u0019A \u0003\u0003M\u000b\"\u0001Q\"\u0011\u0005y\t\u0015B\u0001\" \u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\b#\n\u0005\u0015{\"aA!os\")qi\u0002a\u0001c\u0005)a/\u00197vK\")\u0011j\u0002a\u0001\u0015\u0006A1-\u00197mC\ndW\rE\u0002L#nj\u0011\u0001\u0014\u0006\u0003\u001b:\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqsJC\u0001Q\u0003\u0011Q\u0017M^1\n\u0005Ic%\u0001C\"bY2\f'\r\\3\u0002\u001d\r,(O]3oiNK8\u000f^3nAM\u0019\u0001\"H+\u0011\u0005i1\u0016BA,\u0011\u00059\u0011\u0015m]3TKJL\u0017\r\\5{KJ\faa]=ti\u0016lW#A\u0019\u0002\u000fML8\u000f^3nAQ\u0011A,\u0018\t\u00035!AQ\u0001W\u0006A\u0002E\nq\"\u001b8dYV$W-T1oS\u001a,7\u000f^\u000b\u0002AB\u0011a$Y\u0005\u0003E~\u0011qAQ8pY\u0016\fg.\u0001\u0005u_\nKg.\u0019:z)\t)7\u000eE\u0002\u001fM\"L!aZ\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005yI\u0017B\u00016 \u0005\u0011\u0011\u0015\u0010^3\t\u000b1l\u0001\u0019A\u000f\u0002\u0003=\f!B\u001a:p[\nKg.\u0019:z)\rir.\u001d\u0005\u0006a:\u0001\r!Z\u0001\u0006Ef$Xm\u001d\u0005\u0006e:\u0001\ra]\u0001\u0006G2\f'P\u001f\t\u0004=Q4\u0018BA; \u0005\u0019y\u0005\u000f^5p]B\u001aq/a\u0002\u0011\ta|\u0018Q\u0001\b\u0003sv\u0004\"A_\u0010\u000e\u0003mT!\u0001 \r\u0002\rq\u0012xn\u001c;?\u0013\tqx$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\t\u0019AA\u0003DY\u0006\u001c8O\u0003\u0002\u007f?A\u0019A(a\u0002\u0005\u0015\u0005%\u0011/!A\u0001\u0002\u000b\u0005qHA\u0002`I]BSADA\u0007\u0003?\u0001RAHA\b\u0003'I1!!\u0005 \u0005\u0019!\bN]8xgB!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a=\u000b!![8\n\t\u0005u\u0011q\u0003\u0002\u0019\u001d>$8+\u001a:jC2L'0\u00192mK\u0016C8-\u001a9uS>t7EAA\n\u0001")
public class JavaSerializer
implements BaseSerializer {
    private final ExtendedActorSystem system;
    private int identifier;

    public static CurrentSystem currentSystem() {
        return JavaSerializer$.MODULE$.currentSystem();
    }

    @Override
    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$(this);
    }

    @Override
    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$(this, bytes);
    }

    @Override
    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$(this, bytes, clazz);
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    @Override
    public ExtendedActorSystem system() {
        return this.system;
    }

    @Override
    public boolean includeManifest() {
        return false;
    }

    @Override
    public byte[] toBinary(Object o) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        JavaSerializer$.MODULE$.currentSystem().withValue(this.system(), (Function0)(JFunction0.mcV.sp & Serializable)() -> out.writeObject(o));
        out.close();
        return bos.toByteArray();
    }

    @Override
    public Object fromBinary(byte[] bytes, Option<Class<?>> clazz) throws NotSerializableException {
        ClassLoaderObjectInputStream in = new ClassLoaderObjectInputStream(this.system().dynamicAccess().classLoader(), new ByteArrayInputStream(bytes));
        Object obj = JavaSerializer$.MODULE$.currentSystem().withValue(this.system(), (Function0 & Serializable)() -> in.readObject());
        in.close();
        return obj;
    }

    public JavaSerializer(ExtendedActorSystem system) {
        this.system = system;
        BaseSerializer.$init$(this);
        if (!system.settings().AllowJavaSerialization()) {
            throw new DisabledJavaSerializer.JavaSerializationException("Attempted creation of `JavaSerializer` while `pekko.actor.allow-java-serialization = off` was set!");
        }
        Statics.releaseFence();
    }

    public static final class CurrentSystem
    extends DynamicVariable<ExtendedActorSystem> {
        public <S> S withValue(ExtendedActorSystem value, Callable<S> callable) {
            return (S)super.withValue((Object)value, (Function0 & Serializable)() -> callable.call());
        }

        public CurrentSystem() {
            super(null);
        }
    }
}

