/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.type.codec.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.util.Strings;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public abstract class GeometryCodec<T extends Geometry>
implements TypeCodec<T> {
    @Override
    @Nullable
    public T decode(@Nullable ByteBuffer bb, @NonNull ProtocolVersion protocolVersion) {
        return bb == null || bb.remaining() == 0 ? null : (T)this.fromWellKnownBinary(bb.slice());
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable T geometry, @NonNull ProtocolVersion protocolVersion) {
        return geometry == null ? null : this.toWellKnownBinary(geometry);
    }

    @Override
    @Nullable
    public T parse(@Nullable String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).isEmpty() || s.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!Strings.isQuoted(s)) {
            throw new IllegalArgumentException("Geometry values must be enclosed by single quotes");
        }
        return this.fromWellKnownText(Strings.unquote(s));
    }

    @Override
    @NonNull
    public String format(@Nullable T geometry) throws IllegalArgumentException {
        return geometry == null ? "NULL" : Strings.quote(this.toWellKnownText(geometry));
    }

    @NonNull
    protected abstract T fromWellKnownText(@NonNull String var1);

    @NonNull
    protected abstract T fromWellKnownBinary(@NonNull ByteBuffer var1);

    @NonNull
    protected abstract String toWellKnownText(@NonNull T var1);

    @NonNull
    protected abstract ByteBuffer toWellKnownBinary(@NonNull T var1);
}

