/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.tasks;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.task.Task;
import org.apache.james.task.TaskManager;
import org.apache.james.webadmin.tasks.TaskFromRequest;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;
import spark.Request;
import spark.Route;

public class TaskFromRequestRegistry
implements TaskFromRequest {
    private static final String DEFAULT_PARAMETER = "action";
    private final String taskParameterName;
    private final Map<TaskRegistrationKey, TaskFromRequest> taskGenerators;

    public static Builder builder() {
        return new Builder();
    }

    public static TaskFromRequestRegistry of(TaskRegistrationKey key, TaskFromRequest generator) {
        return TaskFromRequestRegistry.builder().register(key, generator).build();
    }

    private TaskFromRequestRegistry(String taskParameterName, Map<TaskRegistrationKey, TaskFromRequest> taskGenerators) {
        this.taskParameterName = taskParameterName;
        this.taskGenerators = taskGenerators;
    }

    @Override
    public Task fromRequest(Request request) throws Exception {
        TaskRegistrationKey registrationKey = this.parseRegistrationKey(request);
        return (Task)Optional.ofNullable(this.taskGenerators.get(registrationKey)).map(Throwing.function(taskGenerator -> taskGenerator.fromRequest(request)).sneakyThrow()).orElseThrow(() -> new IllegalArgumentException("Invalid value supplied for query parameter '" + this.taskParameterName + "': " + registrationKey.asString() + ". " + this.supportedValueMessage()));
    }

    private TaskRegistrationKey parseRegistrationKey(Request request) {
        return Optional.ofNullable(request.queryParams(this.taskParameterName)).map(this::validateParameter).map(TaskRegistrationKey::of).orElseThrow(() -> new IllegalArgumentException("'" + this.taskParameterName + "' query parameter is compulsory. " + this.supportedValueMessage()));
    }

    private String validateParameter(String parameter) {
        if (StringUtils.isBlank((CharSequence)parameter)) {
            throw new IllegalArgumentException("'" + this.taskParameterName + "' query parameter cannot be empty or blank. " + this.supportedValueMessage());
        }
        return parameter;
    }

    private String supportedValueMessage() {
        ImmutableList supportedTasks = (ImmutableList)this.taskGenerators.keySet().stream().map(TaskRegistrationKey::asString).collect(ImmutableList.toImmutableList());
        return "Supported values are [" + Joiner.on((String)", ").join((Iterable)supportedTasks) + "]";
    }

    public static class TaskRegistration
    implements TaskFromRequest {
        private final TaskRegistrationKey taskRegistrationKey;
        private final TaskFromRequest taskFromRequest;

        public TaskRegistration(TaskRegistrationKey taskRegistrationKey, TaskFromRequest taskFromRequest) {
            this.taskRegistrationKey = taskRegistrationKey;
            this.taskFromRequest = taskFromRequest;
        }

        public TaskRegistrationKey registrationKey() {
            return this.taskRegistrationKey;
        }

        @Override
        public Task fromRequest(Request request) throws Exception {
            return this.taskFromRequest.fromRequest(request);
        }
    }

    public static class Builder {
        private Optional<String> taskParameterName = Optional.empty();
        private ImmutableMap.Builder<TaskRegistrationKey, TaskFromRequest> tasks = ImmutableMap.builder();

        public Builder parameterName(String parameterName) {
            this.taskParameterName = Optional.of(parameterName);
            return this;
        }

        public Builder registrations(TaskRegistration ... taskRegistrations) {
            return this.registrations((Collection<TaskRegistration>)ImmutableSet.copyOf((Object[])taskRegistrations));
        }

        public Builder registrations(Collection<TaskRegistration> taskRegistrations) {
            this.tasks.putAll((Map)taskRegistrations.stream().collect(ImmutableMap.toImmutableMap(TaskRegistration::registrationKey, Function.identity())));
            return this;
        }

        public Builder register(TaskRegistrationKey key, TaskFromRequest taskFromRequest) {
            this.tasks.put((Object)key, (Object)taskFromRequest);
            return this;
        }

        public TaskFromRequestRegistry build() {
            return this.buildAsOptional().orElseThrow(() -> new IllegalStateException("Expecting some registered tasks but got none"));
        }

        public Route buildAsRoute(TaskManager taskManager) {
            return this.build().asRoute(taskManager);
        }

        public Optional<Route> buildAsRouteOptional(TaskManager taskManager) {
            return this.buildAsOptional().map(registry -> registry.asRoute(taskManager));
        }

        Optional<TaskFromRequestRegistry> buildAsOptional() {
            ImmutableMap registrations = this.tasks.build();
            if (registrations.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new TaskFromRequestRegistry(this.taskParameterName.orElse(TaskFromRequestRegistry.DEFAULT_PARAMETER), (Map<TaskRegistrationKey, TaskFromRequest>)registrations));
        }
    }
}

