/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.core.healthcheck.ResultStatus;
import org.apache.james.webadmin.PublicRoutes;
import org.apache.james.webadmin.dto.HealthCheckDto;
import org.apache.james.webadmin.dto.HealthCheckExecutionResultDto;
import org.apache.james.webadmin.dto.HeathCheckAggregationExecutionResultDto;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import spark.HaltException;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

public class HealthCheckRoutes
implements PublicRoutes {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckRoutes.class);
    public static final String HEALTHCHECK = "/healthcheck";
    public static final String CHECKS = "/checks";
    private static final String PARAM_COMPONENT_NAME = "componentName";
    private final JsonTransformer jsonTransformer;
    private final Set<HealthCheck> healthChecks;

    @Inject
    public HealthCheckRoutes(@Named(value="resolved-checks") Set<HealthCheck> healthChecks, JsonTransformer jsonTransformer) {
        this.healthChecks = healthChecks;
        this.jsonTransformer = jsonTransformer;
    }

    @Override
    public String getBasePath() {
        return HEALTHCHECK;
    }

    @Override
    public void define(Service service) {
        service.get(HEALTHCHECK, this::validateHealthChecks, (ResponseTransformer)this.jsonTransformer);
        service.get("/healthcheck/checks/:componentName", this::performHealthCheckForComponent, (ResponseTransformer)this.jsonTransformer);
        service.get("/healthcheck/checks", this::getHealthChecks, (ResponseTransformer)this.jsonTransformer);
    }

    public Object validateHealthChecks(Request request, Response response) {
        List results = (List)this.executeHealthChecks().collectList().block();
        ResultStatus status = this.retrieveAggregationStatus(results);
        response.status(this.getCorrespondingStatusCode(status));
        return new HeathCheckAggregationExecutionResultDto(status, this.mapResultToDto(results));
    }

    public Object performHealthCheckForComponent(Request request, Response response) {
        String componentName = request.params(PARAM_COMPONENT_NAME);
        HealthCheck healthCheck = this.healthChecks.stream().filter(c -> c.componentName().getName().equals(componentName)).findFirst().orElseThrow(() -> this.throw404(componentName));
        Result result = (Result)Mono.from((Publisher)healthCheck.check()).block();
        this.logFailedCheck(result);
        response.status(this.getCorrespondingStatusCode(result.getStatus()));
        return new HealthCheckExecutionResultDto(result);
    }

    public Object getHealthChecks(Request request, Response response) {
        return this.healthChecks.stream().map(healthCheck -> new HealthCheckDto(healthCheck.componentName())).collect(ImmutableList.toImmutableList());
    }

    private int getCorrespondingStatusCode(ResultStatus resultStatus) {
        switch (resultStatus) {
            case HEALTHY: 
            case DEGRADED: {
                return 200;
            }
            case UNHEALTHY: {
                return 503;
            }
        }
        throw new NotImplementedException(resultStatus + " is not supported");
    }

    private void logFailedCheck(Result result) {
        switch (result.getStatus()) {
            case UNHEALTHY: {
                if (result.getError().isPresent()) {
                    LOGGER.error("HealthCheck failed for {} : {}", new Object[]{result.getComponentName().getName(), result.getCause().orElse(""), result.getError().get()});
                    break;
                }
                LOGGER.error("HealthCheck failed for {} : {}", (Object)result.getComponentName().getName(), (Object)result.getCause().orElse(""));
                break;
            }
            case DEGRADED: {
                if (result.getError().isPresent()) {
                    LOGGER.warn("HealthCheck is unstable for {} : {}", new Object[]{result.getComponentName().getName(), result.getCause().orElse(""), result.getError().get()});
                    break;
                }
                LOGGER.warn("HealthCheck is unstable for {} : {}", (Object)result.getComponentName().getName(), (Object)result.getCause().orElse(""));
                break;
            }
        }
    }

    private Flux<Result> executeHealthChecks() {
        return Flux.fromIterable(this.healthChecks).flatMap(HealthCheck::check, 16).doOnNext(this::logFailedCheck);
    }

    private ResultStatus retrieveAggregationStatus(List<Result> results) {
        return results.stream().map(Result::getStatus).reduce(ResultStatus::merge).orElse(ResultStatus.HEALTHY);
    }

    private ImmutableList<HealthCheckExecutionResultDto> mapResultToDto(List<Result> results) {
        return (ImmutableList)results.stream().map(HealthCheckExecutionResultDto::new).collect(ImmutableList.toImmutableList());
    }

    private HaltException throw404(String componentName) {
        return ErrorResponder.builder().message("Component with name %s cannot be found", componentName).statusCode(404).type(ErrorResponder.ErrorType.NOT_FOUND).haltError();
    }
}

