/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.server.blob.deduplication.DeDuplicationBlobStore$;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuples;
import scala.Function1;
import scala.compat.java8.FunctionConverters.package$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsConsumer$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsFunction$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]w!\u0002\r\u001a\u0011\u00031c!\u0002\u0015\u001a\u0011\u0003I\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004b\u0002\u001a\u0002\u0005\u0004%\ta\r\u0005\u0007o\u0005\u0001\u000b\u0011\u0002\u001b\t\u000fa\n!\u0019!C\u0001s!1Q(\u0001Q\u0001\ni2A\u0001K\r\u0001}!Aaj\u0002B\u0001B\u0003%q\n\u0003\u0005S\u000f\t\u0005\t\u0015!\u0003T\u0011!\u0011wA!A!\u0002\u0013\u0019\u0007\"\u0002\u0019\b\t\u0003Q\u0007\"\u0002;\b\t\u0003*\bB\u0002;\b\t\u0003\n)\u0003\u0003\u0004u\u000f\u0011\u0005\u0013Q\t\u0005\b\u0003/:A\u0011BA-\u0011\u001d\tii\u0002C!\u0003\u001fCq!!'\b\t\u0003\nY\nC\u0004\u0002\"\u001e!\t%a)\t\u000f\u0005-v\u0001\"\u0011\u0002.\"9\u0011qV\u0004\u0005B\u0005E\u0006bBA_\u000f\u0011\u0005\u0013q\u0018\u0005\b\u0003\u0017<A\u0011IAg\u0011\u001d\t\tn\u0002C!\u0003'\fa\u0003R3EkBd\u0017nY1uS>t'\t\\8c'R|'/\u001a\u0006\u00035m\tQ\u0002Z3ekBd\u0017nY1uS>t'B\u0001\u000f\u001e\u0003\u0011\u0011Gn\u001c2\u000b\u0005yy\u0012AB:feZ,'O\u0003\u0002!C\u0005)!.Y7fg*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u0001\"aJ\u0001\u000e\u0003e\u0011a\u0003R3EkBd\u0017nY1uS>t'\t\\8c'R|'/Z\n\u0003\u0003)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001'\u0003Ua\u0015IW-`%\u0016\u001bv*\u0016*D\u000b~\u001bE*R!O+B+\u0012\u0001\u000e\t\u0003WUJ!A\u000e\u0017\u0003\u000f\t{w\u000e\\3b]\u00061B*\u0011.Z?J+5kT+S\u0007\u0016{6\tT#B\u001dV\u0003\u0006%\u0001\bG\u00132+u\f\u0016%S\u000bNCu\n\u0014#\u0016\u0003i\u0002\"aK\u001e\n\u0005qb#aA%oi\u0006ya)\u0013'F?RC%+R*I\u001f2#\u0005eE\u0002\b\u007f\u001d\u0003\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\t1\fgn\u001a\u0006\u0002\t\u0006!!.\u0019<b\u0013\t1\u0015I\u0001\u0004PE*,7\r\u001e\t\u0003\u00112k\u0011!\u0013\u0006\u0003\u0015.\u000b1!\u00199j\u0015\tar$\u0003\u0002N\u0013\nI!\t\\8c'R|'/Z\u0001\rE2|'m\u0015;pe\u0016$\u0015i\u0014\t\u0003\u0011BK!!U%\u0003\u0019\tcwNY*u_J,G)Q(\u0002#\u0011,g-Y;mi\n+8m[3u\u001d\u0006lW\r\u0005\u0002I)&\u0011Q+\u0013\u0002\u000b\u0005V\u001c7.\u001a;OC6,\u0007\u0006B\u0005X?\u0002\u0004\"\u0001W/\u000e\u0003eS!AW.\u0002\r%t'.Z2u\u0015\u0005a\u0016!\u00026bm\u0006D\u0018B\u00010Z\u0005\u0015q\u0015-\\3e\u0003\u00151\u0018\r\\;fC\u0005\t\u0017!\u00043fM\u0006,H\u000e\u001e\"vG.,G/A\u0007cY>\u0014\u0017\n\u001a$bGR|'/\u001f\t\u0003I\u001et!\u0001S3\n\u0005\u0019L\u0015A\u0002\"m_\nLE-\u0003\u0002iS\n9a)Y2u_JL(B\u00014J)\u0011YG.\\8\u0011\u0005\u001d:\u0001\"\u0002(\f\u0001\u0004y\u0005\"\u0002*\f\u0001\u0004\u0019\u0006\u0006B7X?\u0002DQAY\u0006A\u0002\rD#aC9\u0011\u0005a\u0013\u0018BA:Z\u0005\u0019IeN[3di\u0006!1/\u0019<f)\u00191x0a\u0001\u0002\u0014A\u0019qO\u001f?\u000e\u0003aT!!_\u0012\u0002\u001fI,\u0017m\u0019;jm\u0016\u001cHO]3b[NL!a\u001f=\u0003\u0013A+(\r\\5tQ\u0016\u0014\bC\u0001%~\u0013\tq\u0018J\u0001\u0004CY>\u0014\u0017\n\u001a\u0005\u0007\u0003\u0003a\u0001\u0019A*\u0002\u0015\t,8m[3u\u001d\u0006lW\rC\u0004\u0002\u00061\u0001\r!a\u0002\u0002\t\u0011\fG/\u0019\t\u0006W\u0005%\u0011QB\u0005\u0004\u0003\u0017a#!B!se\u0006L\bcA\u0016\u0002\u0010%\u0019\u0011\u0011\u0003\u0017\u0003\t\tKH/\u001a\u0005\b\u0003+a\u0001\u0019AA\f\u00035\u0019Ho\u001c:bO\u0016\u0004v\u000e\\5dsB!\u0011\u0011DA\u0010\u001d\rA\u00151D\u0005\u0004\u0003;I\u0015!\u0003\"m_\n\u001cFo\u001c:f\u0013\u0011\t\t#a\t\u0003\u001bM#xN]1hKB{G.[2z\u0015\r\ti\"\u0013\u000b\bm\u0006\u001d\u0012\u0011FA\"\u0011\u0019\t\t!\u0004a\u0001'\"9\u0011QA\u0007A\u0002\u0005-\u0002\u0003BA\u0017\u0003\u007fi!!a\f\u000b\t\u0005E\u00121G\u0001\u0003S>TA!!\u000e\u00028\u000511m\\7n_:TA!!\u000f\u0002<\u00051qm\\8hY\u0016T!!!\u0010\u0002\u0007\r|W.\u0003\u0003\u0002B\u0005=\"A\u0003\"zi\u0016\u001cv.\u001e:dK\"9\u0011QC\u0007A\u0002\u0005]Ac\u0002<\u0002H\u0005%\u0013Q\u000b\u0005\u0007\u0003\u0003q\u0001\u0019A*\t\u000f\u0005\u0015a\u00021\u0001\u0002LA!\u0011QJA)\u001b\t\tyEC\u0002\u00022\rKA!a\u0015\u0002P\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\t)B\u0004a\u0001\u0003/\tQc]1wK\u0006sGmR3oKJ\fG/\u001a\"m_\nLE\r\u0006\u0005\u0002\\\u0005E\u00141OAB!\u0015\ti&!\u001c}\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014!\u00039vE2L7\u000f[3s\u0015\ri\u0013Q\r\u0006\u0005\u0003O\nI'\u0001\u0003d_J,'BAA6\u0003\u001d\u0011X-Y2u_JLA!a\u001c\u0002`\t)1+T8o_\"1\u0011\u0011A\bA\u0002MCq!!\u001e\u0010\u0001\u0004\t9(\u0001\niCND\u0017N\\4J]B,Ho\u0015;sK\u0006l\u0007\u0003BA=\u0003\u007fj!!a\u001f\u000b\t\u0005u\u00141G\u0001\u0005Q\u0006\u001c\b.\u0003\u0003\u0002\u0002\u0006m$A\u0005%bg\"LgnZ%oaV$8\u000b\u001e:fC6Dq!!\"\u0010\u0001\u0004\t9)\u0001\fgS2,')Y2lK\u0012|U\u000f\u001e9viN#(/Z1n!\u0011\ti#!#\n\t\u0005-\u0015q\u0006\u0002\u0017\r&dWMQ1dW\u0016$w*\u001e;qkR\u001cFO]3b[\u0006I!/Z1e\u0005f$Xm\u001d\u000b\u0007\u0003#\u000b\u0019*!&\u0011\t]T\u0018q\u0001\u0005\u0007\u0003\u0003\u0001\u0002\u0019A*\t\r\u0005]\u0005\u00031\u0001}\u0003\u0019\u0011Gn\u001c2JI\u0006!!/Z1e)\u0019\tY%!(\u0002 \"1\u0011\u0011A\tA\u0002MCa!a&\u0012\u0001\u0004a\u0018\u0001\u0004:fC\u0012\u0014V-Y2uSZ,GCBAS\u0003O\u000bI\u000b\u0005\u0003xu\u0006-\u0003BBA\u0001%\u0001\u00071\u000b\u0003\u0004\u0002\u0018J\u0001\r\u0001`\u0001\u0015O\u0016$H)\u001a4bk2$()^2lKRt\u0015-\\3\u0015\u0003M\u000bA\u0002Z3mKR,')^2lKR$B!a-\u0002<B!qO_A[!\r\u0001\u0015qW\u0005\u0004\u0003s\u000b%\u0001\u0002,pS\u0012Da!!\u0001\u0015\u0001\u0004\u0019\u0016A\u00023fY\u0016$X\r\u0006\u0004\u0002B\u0006\u001d\u0017\u0011\u001a\t\u0005oj\f\u0019\rE\u0002A\u0003\u000bL!AN!\t\r\u0005\u0005Q\u00031\u0001T\u0011\u0019\t9*\u0006a\u0001y\u0006YA.[:u\u0005V\u001c7.\u001a;t)\t\ty\rE\u0002xuN\u000b\u0011\u0002\\5ti\ncwNY:\u0015\u0007Y\f)\u000e\u0003\u0004\u0002\u0002]\u0001\ra\u0015")
public class DeDuplicationBlobStore
implements BlobStore {
    private final BlobStoreDAO blobStoreDAO;
    @Named(value="defaultBucket")
    private final BucketName defaultBucketName;
    private final BlobId.Factory blobIdFactory;

    public static int FILE_THRESHOLD() {
        return DeDuplicationBlobStore$.MODULE$.FILE_THRESHOLD();
    }

    public static boolean LAZY_RESOURCE_CLEANUP() {
        return DeDuplicationBlobStore$.MODULE$.LAZY_RESOURCE_CLEANUP();
    }

    public Publisher<BlobId> save(BucketName x$1, String x$2, BlobStore.StoragePolicy x$3) {
        return super.save(x$1, x$2, x$3);
    }

    public Publisher<byte[]> readBytes(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.readBytes(x$1, x$2, x$3);
    }

    public InputStream read(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.read(x$1, x$2, x$3);
    }

    public Publisher<InputStream> readReactive(BucketName x$1, BlobId x$2, BlobStore.StoragePolicy x$3) {
        return super.readReactive(x$1, x$2, x$3);
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        BlobId blobId = this.blobIdFactory.forPayload(data);
        return SMono$.MODULE$.apply(this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just((Object)blobId));
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return SMono$.MODULE$.fromCallable(() -> $this.blobIdFactory.forPayload(data)).subscribeOn(Schedulers.boundedElastic()).flatMap((Function1 & Serializable)blobId -> SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just(blobId)));
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        HashingInputStream hashingInputStream = new HashingInputStream(Hashing.sha256(), data);
        Function1 & Serializable sourceSupplier = (Function1 & Serializable)fileBackedOutputStream -> this.saveAndGenerateBlobId(bucketName, hashingInputStream, (FileBackedOutputStream)fileBackedOutputStream).asJava();
        Callable<FileBackedOutputStream> ressourceSupplier = () -> new FileBackedOutputStream(DeDuplicationBlobStore$.MODULE$.FILE_THRESHOLD());
        return Mono.using(ressourceSupplier, (Function)RichFunction1AsFunction$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaFunction((Function1)sourceSupplier)), (Consumer)RichFunction1AsConsumer$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaConsumer((Function1 & Serializable)fileBackedOutputStream -> {
            fileBackedOutputStream.reset();
            return BoxedUnit.UNIT;
        })), (boolean)DeDuplicationBlobStore$.MODULE$.LAZY_RESOURCE_CLEANUP());
    }

    private SMono<BlobId> saveAndGenerateBlobId(BucketName bucketName, HashingInputStream hashingInputStream, FileBackedOutputStream fileBackedOutputStream) {
        return SMono$.MODULE$.fromCallable(() -> {
            IOUtils.copy((InputStream)hashingInputStream, (OutputStream)fileBackedOutputStream);
            return Tuples.of((Object)$this.blobIdFactory.from(hashingInputStream.hash().toString()), (Object)fileBackedOutputStream.asByteSource());
        }).subscribeOn(Schedulers.boundedElastic()).flatMap((Function1 & Serializable)tuple -> SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, (BlobId)tuple.getT1(), (ByteSource)tuple.getT2())).then(SMono$.MODULE$.just(tuple.getT1())));
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readBytes(bucketName, blobId);
    }

    public InputStream read(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.read(bucketName, blobId);
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readReactive(bucketName, blobId);
    }

    public BucketName getDefaultBucketName() {
        return this.defaultBucketName;
    }

    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.blobStoreDAO.deleteBucket(bucketName);
    }

    public Publisher<Boolean> delete(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        return SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Publisher<BucketName> listBuckets() {
        return Flux.concat((Publisher[])new Publisher[]{this.blobStoreDAO.listBuckets(), Flux.just((Object)this.defaultBucketName)}).distinct();
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return this.blobStoreDAO.listBlobs(bucketName);
    }

    @Inject
    public DeDuplicationBlobStore(BlobStoreDAO blobStoreDAO, @Named(value="defaultBucket") BucketName defaultBucketName, BlobId.Factory blobIdFactory) {
        this.blobStoreDAO = blobStoreDAO;
        this.defaultBucketName = defaultBucketName;
        this.blobIdFactory = blobIdFactory;
    }
}

