/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.version;

import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class AddVersionLabel
implements Command {
    private static Log log = LogFactory.getLog(AddVersionLabel.class);
    private String pathKey = "path";
    private String versionKey = "version";
    private String labelKey = "label";
    private String moveLabelKey = "moveLabel";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String path = (String)ctx.get(this.pathKey);
        String versionName = (String)ctx.get(this.versionKey);
        boolean moveLabel = Boolean.valueOf((String)ctx.get(this.moveLabelKey));
        String versionLabel = (String)ctx.get(this.labelKey);
        if (log.isDebugEnabled()) {
            log.debug("Add label " + versionLabel + " to version  " + versionName + " of node at " + path);
        }
        CommandHelper.getNode(ctx, path).getVersionHistory().addVersionLabel(versionName, versionLabel, moveLabel);
        return false;
    }

    public String getMoveLabelKey() {
        return this.moveLabelKey;
    }

    public void setMoveLabelKey(String moveLabelKey) {
        this.moveLabelKey = moveLabelKey;
    }

    public String getPathKey() {
        return this.pathKey;
    }

    public void setPathKey(String pathKey) {
        this.pathKey = pathKey;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public void setLabelKey(String versionLabelKey) {
        this.labelKey = versionLabelKey;
    }

    public String getVersionKey() {
        return this.versionKey;
    }

    public void setVersionKey(String versionNameKey) {
        this.versionKey = versionNameKey;
    }
}

