/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.combined;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AccessControlUtils;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.PrivilegeManagerImpl;
import org.apache.jackrabbit.core.security.authorization.combined.CombinedEditor;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLProvider;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedProvider
extends AbstractAccessControlProvider {
    private static Logger log = LoggerFactory.getLogger(CombinedProvider.class);
    private AccessControlProvider[] providers;

    @Override
    public boolean isAcItem(Path absPath) throws RepositoryException {
        for (AccessControlProvider provider : this.providers) {
            if (!(provider instanceof AccessControlUtils) || !((AccessControlUtils)((Object)provider)).isAcItem(absPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcItem(ItemImpl item) throws RepositoryException {
        for (AccessControlProvider provider : this.providers) {
            if (!(provider instanceof AccessControlUtils) || !((AccessControlUtils)((Object)provider)).isAcItem(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        for (AccessControlProvider provider : this.providers) {
            provider.close();
        }
        super.close();
    }

    @Override
    public void init(Session systemSession, Map configuration) throws RepositoryException {
        super.init(systemSession, configuration);
        this.providers = new AccessControlProvider[2];
        this.providers[0] = new org.apache.jackrabbit.core.security.authorization.acl.ACLProvider();
        HashMap<String, Boolean> config = new HashMap<String, Boolean>(configuration);
        config.put("omit-default-permission", Boolean.TRUE);
        this.providers[0].init(this.session, config);
        this.providers[1] = new ACLProvider();
        this.providers[1].init(this.session, configuration);
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Path absPath, CompiledPermissions permissions) throws ItemNotFoundException, RepositoryException {
        ArrayList<AccessControlPolicy> l = new ArrayList<AccessControlPolicy>();
        for (AccessControlProvider provider : this.providers) {
            l.addAll(Arrays.asList(provider.getEffectivePolicies(absPath, permissions)));
        }
        return l.toArray(new AccessControlPolicy[l.size()]);
    }

    @Override
    public AccessControlPolicy[] getEffectivePolicies(Set<Principal> principals, CompiledPermissions permissions) throws RepositoryException {
        ArrayList<AccessControlPolicy> l = new ArrayList<AccessControlPolicy>();
        for (AccessControlProvider provider : this.providers) {
            l.addAll(Arrays.asList(provider.getEffectivePolicies(principals, permissions)));
        }
        return l.toArray(new AccessControlPolicy[l.size()]);
    }

    @Override
    public AccessControlEditor getEditor(Session editingSession) {
        this.checkInitialized();
        ArrayList<AccessControlEditor> editors = new ArrayList<AccessControlEditor>();
        for (AccessControlProvider provider : this.providers) {
            try {
                editors.add(provider.getEditor(editingSession));
            }
            catch (RepositoryException e) {
                log.debug(e.getMessage());
            }
        }
        if (!editors.isEmpty()) {
            return new CombinedEditor(editors.toArray(new AccessControlEditor[editors.size()]));
        }
        log.debug("None of the derived access control providers supports editing.");
        return null;
    }

    @Override
    public CompiledPermissions compilePermissions(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return this.getAdminPermissions();
        }
        return new CompiledPermissionImpl(principals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAccessRoot(Set<Principal> principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return true;
        }
        try (CompiledPermissionImpl cp = new CompiledPermissionImpl(principals);){
            Path rootPath = PathFactoryImpl.getInstance().getRootPath();
            boolean bl = cp.grants(rootPath, 1);
            return bl;
        }
    }

    private class CompiledPermissionImpl
    extends AbstractCompiledPermissions {
        private final List<AbstractCompiledPermissions> cPermissions = new ArrayList<AbstractCompiledPermissions>();

        private CompiledPermissionImpl(Set<Principal> principals) throws RepositoryException {
            for (AccessControlProvider provider : CombinedProvider.this.providers) {
                CompiledPermissions cp = provider.compilePermissions(principals);
                if (cp instanceof AbstractCompiledPermissions) {
                    this.cPermissions.add((AbstractCompiledPermissions)cp);
                    continue;
                }
                log.warn("AbstractCompiledPermissions expected. Found " + cp.getClass().getName() + " -> ignore.");
            }
        }

        @Override
        public AbstractCompiledPermissions.Result getResult(Path absPath) throws RepositoryException {
            return this.buildResult(absPath);
        }

        @Override
        protected AbstractCompiledPermissions.Result buildResult(Path absPath) throws RepositoryException {
            AbstractCompiledPermissions.Result res = null;
            for (AbstractCompiledPermissions acp : this.cPermissions) {
                AbstractCompiledPermissions.Result other = acp.getResult(absPath);
                res = res == null ? other : res.combine(other);
            }
            return res;
        }

        @Override
        protected AbstractCompiledPermissions.Result buildRepositoryResult() throws RepositoryException {
            AbstractCompiledPermissions.Result res = null;
            for (AbstractCompiledPermissions acp : this.cPermissions) {
                AbstractCompiledPermissions.Result other = acp.getResult(null);
                res = res == null ? other : res.combine(other);
            }
            return res;
        }

        @Override
        protected PrivilegeManagerImpl getPrivilegeManagerImpl() throws RepositoryException {
            return CombinedProvider.this.getPrivilegeManagerImpl();
        }

        @Override
        public synchronized void close() {
            Iterator<AbstractCompiledPermissions> it = this.cPermissions.iterator();
            while (it.hasNext()) {
                CompiledPermissions cp = it.next();
                cp.close();
                it.remove();
            }
            super.close();
        }

        @Override
        public boolean canRead(Path path, ItemId itemId) throws RepositoryException {
            Path p = path == null ? CombinedProvider.this.session.getItemManager().getItem(itemId).getPrimaryPath() : path;
            return this.grants(p, 1);
        }
    }
}

