/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.converter;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.storageengine.load.converter.LoadConvertedInsertTabletStatement;
import org.apache.iotdb.db.storageengine.load.converter.LoadTsFileDataTypeConverter;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTreeStatementDataTypeConvertExecutionVisitor
extends StatementVisitor<Optional<TSStatus>, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTreeStatementDataTypeConvertExecutionVisitor.class);
    private static final long TABLET_BATCH_MEMORY_SIZE_IN_BYTES = IoTDBDescriptor.getInstance().getConfig().getLoadTsFileTabletConversionBatchMemorySizeInBytes();
    private final StatementExecutor statementExecutor;

    public LoadTreeStatementDataTypeConvertExecutionVisitor(StatementExecutor statementExecutor) {
        this.statementExecutor = statementExecutor;
    }

    @Override
    public Optional<TSStatus> visitNode(StatementNode statementNode, Void v) {
        return Optional.empty();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<TSStatus> visitLoadFile(LoadTsFileStatement loadTsFileStatement, Void v) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TSStatus executeInsertMultiTabletsWithRetry(List<PipeTransferTabletRawReq> tabletRawReqs, boolean isConvertOnTypeMismatch) {
        TSStatus result;
        InsertMultiTabletsStatement batchStatement = new InsertMultiTabletsStatement();
        batchStatement.setInsertTabletStatementList(tabletRawReqs.stream().map(req -> new LoadConvertedInsertTabletStatement(req.constructStatement(), isConvertOnTypeMismatch)).collect(Collectors.toList()));
        try {
            result = batchStatement.accept(LoadTsFileDataTypeConverter.STATEMENT_STATUS_VISITOR, this.statementExecutor.execute(batchStatement));
            for (int i = 0; i < 5 && result.getCode() == TSStatusCode.LOAD_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode(); ++i) {
                Thread.sleep(100L * (long)(i + 1));
                result = batchStatement.accept(LoadTsFileDataTypeConverter.STATEMENT_STATUS_VISITOR, this.statementExecutor.execute(batchStatement));
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            result = batchStatement.accept(LoadTsFileDataTypeConverter.STATEMENT_EXCEPTION_VISITOR, e);
        }
        return result;
    }

    public static boolean handleTSStatus(TSStatus result, Object loadTsFileStatement) {
        if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && result.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() && result.getCode() != TSStatusCode.LOAD_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()) {
            LOGGER.warn("Failed to convert data type for LoadTsFileStatement: {}, status code is {}.", loadTsFileStatement, (Object)result.getCode());
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$visitLoadFile$0(File tsfile) {
        FileUtils.deleteQuietly((File)tsfile);
        String tsFilePath = tsfile.getAbsolutePath();
        FileUtils.deleteQuietly((File)new File(tsFilePath + ".resource"));
        FileUtils.deleteQuietly((File)new File(tsFilePath + ".mods"));
        FileUtils.deleteQuietly((File)new File(tsFilePath + ".mods2"));
    }

    @FunctionalInterface
    public static interface StatementExecutor {
        public TSStatus execute(Statement var1);
    }
}

