/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.table;

import java.util.Arrays;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.table.TreeViewSchema;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.storageengine.dataregion.memtable.DeviceIDFactory;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.StringArrayDeviceID;

public class DataNodeTreeViewSchemaUtils {
    public static void checkTableInWrite(String database, TsTable table) {
        if (DataNodeTreeViewSchemaUtils.isTreeViewTable(table)) {
            throw new SemanticException(new IoTDBException(String.format("The table %s.%s is a view from tree, cannot be written or deleted from", database, table.getTableName()), TSStatusCode.SEMANTIC_ERROR.getStatusCode()));
        }
    }

    public static boolean isTreeViewTable(TsTable table) {
        return table.containsPropWithoutLock("__tree_path_pattern");
    }

    public static String[] getPatternNodes(TsTable table) {
        PartialPath path = TreeViewSchema.getPrefixPattern((TsTable)table);
        return Arrays.copyOf(path.getNodes(), path.getNodeLength() - 1);
    }

    public static String getPrefixPath(TsTable table) {
        PartialPath path = TreeViewSchema.getPrefixPattern((TsTable)table);
        StringJoiner joiner = new StringJoiner(".");
        for (int i = 0; i < path.getNodeLength() - 1; ++i) {
            joiner.add(path.getNodes()[i]);
        }
        return joiner.toString();
    }

    public static IDeviceID convertToIDeviceID(TsTable table, String[] idValues) {
        return IDeviceID.Factory.DEFAULT_FACTORY.create(StringArrayDeviceID.splitDeviceIdString((String[])((String[])Stream.concat(Arrays.stream(DataNodeTreeViewSchemaUtils.getPatternNodes(table)), Arrays.stream((String[])DeviceIDFactory.truncateTailingNull(idValues))).toArray(String[]::new))));
    }

    private DataNodeTreeViewSchemaUtils() {
    }
}

