/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;

public class AssignUniqueId
extends SingleChildProcessNode {
    private final Symbol idColumn;

    public AssignUniqueId(PlanNodeId id, PlanNode child, Symbol idColumn) {
        super(id);
        this.child = child;
        this.idColumn = Objects.requireNonNull(idColumn, "idColumn is null");
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAssignUniqueId(this, context);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.child.getOutputSymbols()).add((Object)this.idColumn).build();
    }

    @Override
    public PlanNode clone() {
        return new AssignUniqueId(this.id, null, this.idColumn);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 1 ? 1 : 0) != 0, (Object)"expected newChildren to contain 1 node");
        return new AssignUniqueId(this.getPlanNodeId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.idColumn);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_ASSIGN_UNIQUE_ID.serialize(byteBuffer);
        Symbol.serialize(this.idColumn, byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_ASSIGN_UNIQUE_ID.serialize(stream);
        Symbol.serialize(this.idColumn, stream);
    }

    public static AssignUniqueId deserialize(ByteBuffer byteBuffer) {
        Symbol idColumn = Symbol.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new AssignUniqueId(planNodeId, null, idColumn);
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    public Symbol getIdColumn() {
        return this.idColumn;
    }
}

