/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.address;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.router.AbstractRouter;
import org.apache.dubbo.rpc.cluster.router.address.Address;

public class AddressInvokersSelector
extends AbstractRouter {
    public static final String NAME = "ADDRESS_ROUTER";
    private static final int ADDRESS_INVOKERS_DEFAULT_PRIORITY = 180;

    public AddressInvokersSelector() {
        this.priority = 180;
    }

    @Override
    public <T> List<Invoker<T>> route(List<Invoker<T>> invokers, URL url, Invocation invocation) throws RpcException {
        Address address;
        if (CollectionUtils.isEmpty(invokers)) {
            return invokers;
        }
        if (invocation.getObjectAttachments() != null && Optional.ofNullable(address = (Address)Address.class.cast(invocation.getObjectAttachment("address"))).isPresent()) {
            invocation.getObjectAttachments().remove("address");
            return invokers.stream().filter(it -> it.getUrl().getIp().equals(address.getIp()) && it.getUrl().getPort() == address.getPort() && it.isAvailable()).collect(Collectors.toList());
        }
        return invokers;
    }
}

