/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.admin;

import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.QueryResult;
import org.apache.rocketmq.client.admin.MQAdminExtInner;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.MQClientManager;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.log.ClientLogger;
import org.apache.rocketmq.common.AclConfig;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.PlainAccessConfig;
import org.apache.rocketmq.common.ServiceState;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.admin.ConsumeStats;
import org.apache.rocketmq.common.admin.OffsetWrapper;
import org.apache.rocketmq.common.admin.RollbackStats;
import org.apache.rocketmq.common.admin.TopicOffset;
import org.apache.rocketmq.common.admin.TopicStatsTable;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.MessageClientExt;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.body.BrokerStatsData;
import org.apache.rocketmq.common.protocol.body.ClusterAclVersionInfo;
import org.apache.rocketmq.common.protocol.body.ClusterInfo;
import org.apache.rocketmq.common.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.common.protocol.body.ConsumeStatsList;
import org.apache.rocketmq.common.protocol.body.ConsumerConnection;
import org.apache.rocketmq.common.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.common.protocol.body.GroupList;
import org.apache.rocketmq.common.protocol.body.KVTable;
import org.apache.rocketmq.common.protocol.body.ProducerConnection;
import org.apache.rocketmq.common.protocol.body.ProducerTableInfo;
import org.apache.rocketmq.common.protocol.body.QueryConsumeQueueResponseBody;
import org.apache.rocketmq.common.protocol.body.QueueTimeSpan;
import org.apache.rocketmq.common.protocol.body.SubscriptionGroupWrapper;
import org.apache.rocketmq.common.protocol.body.TopicConfigSerializeWrapper;
import org.apache.rocketmq.common.protocol.body.TopicList;
import org.apache.rocketmq.common.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.protocol.route.QueueData;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.common.subscription.SubscriptionGroupConfig;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.MQAdminExt;
import org.apache.rocketmq.tools.admin.api.MessageTrack;
import org.apache.rocketmq.tools.admin.api.TrackType;

public class DefaultMQAdminExtImpl
implements MQAdminExt,
MQAdminExtInner {
    private final InternalLogger log = ClientLogger.getLog();
    private final DefaultMQAdminExt defaultMQAdminExt;
    private ServiceState serviceState = ServiceState.CREATE_JUST;
    private MQClientInstance mqClientInstance;
    private RPCHook rpcHook;
    private long timeoutMillis = 20000L;
    private Random random = new Random();
    private static final Set<String> SYSTEM_GROUP_SET = new HashSet<String>();

    public DefaultMQAdminExtImpl(DefaultMQAdminExt defaultMQAdminExt, long timeoutMillis) {
        this(defaultMQAdminExt, null, timeoutMillis);
    }

    public DefaultMQAdminExtImpl(DefaultMQAdminExt defaultMQAdminExt, RPCHook rpcHook, long timeoutMillis) {
        this.defaultMQAdminExt = defaultMQAdminExt;
        this.rpcHook = rpcHook;
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public void start() throws MQClientException {
        switch (this.serviceState) {
            case CREATE_JUST: {
                this.serviceState = ServiceState.START_FAILED;
                this.defaultMQAdminExt.changeInstanceNameToPID();
                this.mqClientInstance = MQClientManager.getInstance().getOrCreateMQClientInstance((ClientConfig)this.defaultMQAdminExt, this.rpcHook);
                boolean registerOK = this.mqClientInstance.registerAdminExt(this.defaultMQAdminExt.getAdminExtGroup(), (MQAdminExtInner)this);
                if (!registerOK) {
                    this.serviceState = ServiceState.CREATE_JUST;
                    throw new MQClientException("The adminExt group[" + this.defaultMQAdminExt.getAdminExtGroup() + "] has created already, specifed another name please." + FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/"), null);
                }
                this.mqClientInstance.start();
                this.log.info("the adminExt [{}] start OK", (Object)this.defaultMQAdminExt.getAdminExtGroup());
                this.serviceState = ServiceState.RUNNING;
                break;
            }
            case RUNNING: 
            case START_FAILED: 
            case SHUTDOWN_ALREADY: {
                throw new MQClientException("The AdminExt service state not OK, maybe started once, " + this.serviceState + FAQUrl.suggestTodo((String)"http://rocketmq.apache.org/docs/faq/"), null);
            }
        }
    }

    @Override
    public void shutdown() {
        switch (this.serviceState) {
            case CREATE_JUST: {
                break;
            }
            case RUNNING: {
                this.mqClientInstance.unregisterAdminExt(this.defaultMQAdminExt.getAdminExtGroup());
                this.mqClientInstance.shutdown();
                this.log.info("the adminExt [{}] shutdown OK", (Object)this.defaultMQAdminExt.getAdminExtGroup());
                this.serviceState = ServiceState.SHUTDOWN_ALREADY;
                break;
            }
            case SHUTDOWN_ALREADY: {
                break;
            }
        }
    }

    @Override
    public void updateBrokerConfig(String brokerAddr, Properties properties) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, UnsupportedEncodingException, InterruptedException, MQBrokerException {
        this.mqClientInstance.getMQClientAPIImpl().updateBrokerConfig(brokerAddr, properties, this.timeoutMillis);
    }

    @Override
    public Properties getBrokerConfig(String brokerAddr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, UnsupportedEncodingException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerConfig(brokerAddr, this.timeoutMillis);
    }

    @Override
    public void createAndUpdateTopicConfig(String addr, TopicConfig config) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().createTopic(addr, this.defaultMQAdminExt.getCreateTopicKey(), config, this.timeoutMillis);
    }

    @Override
    public void createAndUpdatePlainAccessConfig(String addr, PlainAccessConfig config) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().createPlainAccessConfig(addr, config, this.timeoutMillis);
    }

    @Override
    public void deletePlainAccessConfig(String addr, String accessKey) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().deleteAccessConfig(addr, accessKey, this.timeoutMillis);
    }

    @Override
    public void updateGlobalWhiteAddrConfig(String addr, String globalWhiteAddrs) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().updateGlobalWhiteAddrsConfig(addr, globalWhiteAddrs, null, this.timeoutMillis);
    }

    @Override
    public void updateGlobalWhiteAddrConfig(String addr, String globalWhiteAddrs, String aclFileFullPath) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().updateGlobalWhiteAddrsConfig(addr, globalWhiteAddrs, aclFileFullPath, this.timeoutMillis);
    }

    @Override
    public ClusterAclVersionInfo examineBrokerClusterAclVersionInfo(String addr) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerClusterAclInfo(addr, this.timeoutMillis);
    }

    @Override
    public AclConfig examineBrokerClusterAclConfig(String addr) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerClusterConfig(addr, this.timeoutMillis);
    }

    @Override
    public void createAndUpdateSubscriptionGroupConfig(String addr, SubscriptionGroupConfig config) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().createSubscriptionGroup(addr, config, this.timeoutMillis);
    }

    @Override
    public SubscriptionGroupConfig examineSubscriptionGroupConfig(String addr, String group) throws InterruptedException, RemotingException, MQClientException, MQBrokerException {
        SubscriptionGroupWrapper wrapper = this.mqClientInstance.getMQClientAPIImpl().getAllSubscriptionGroup(addr, this.timeoutMillis);
        return (SubscriptionGroupConfig)wrapper.getSubscriptionGroupTable().get(group);
    }

    @Override
    public TopicConfig examineTopicConfig(String addr, String topic) throws RemotingException, InterruptedException, MQBrokerException {
        TopicConfigSerializeWrapper topicConfigSerializeWrapper = this.mqClientInstance.getMQClientAPIImpl().getAllTopicConfig(addr, this.timeoutMillis);
        return (TopicConfig)topicConfigSerializeWrapper.getTopicConfigTable().get(topic);
    }

    @Override
    public TopicStatsTable examineTopicStats(String topic) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        TopicStatsTable topicStatsTable = new TopicStatsTable();
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            TopicStatsTable tst = this.mqClientInstance.getMQClientAPIImpl().getTopicStatsInfo(addr, topic, this.timeoutMillis);
            topicStatsTable.getOffsetTable().putAll(tst.getOffsetTable());
        }
        if (topicStatsTable.getOffsetTable().isEmpty()) {
            throw new MQClientException("Not found the topic stats info", null);
        }
        return topicStatsTable;
    }

    @Override
    public TopicList fetchAllTopicList() throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getTopicListFromNameServer(this.timeoutMillis);
    }

    @Override
    public TopicList fetchTopicsByCLuster(String clusterName) throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getTopicsByCluster(clusterName, this.timeoutMillis);
    }

    @Override
    public KVTable fetchBrokerRuntimeStats(String brokerAddr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerRuntimeInfo(brokerAddr, this.timeoutMillis);
    }

    @Override
    public ConsumeStats examineConsumeStats(String consumerGroup) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        return this.examineConsumeStats(consumerGroup, null);
    }

    @Override
    public ConsumeStats examineConsumeStats(String consumerGroup, String topic) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        String retryTopic = MixAll.getRetryTopic((String)consumerGroup);
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(retryTopic);
        ConsumeStats result = new ConsumeStats();
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            ConsumeStats consumeStats = this.mqClientInstance.getMQClientAPIImpl().getConsumeStats(addr, consumerGroup, topic, this.timeoutMillis * 3L);
            result.getOffsetTable().putAll(consumeStats.getOffsetTable());
            double value = result.getConsumeTps() + consumeStats.getConsumeTps();
            result.setConsumeTps(value);
        }
        if (result.getOffsetTable().isEmpty()) {
            throw new MQClientException(206, "Not found the consumer group consume stats, because return offset table is empty, maybe the consumer not consume any message");
        }
        return result;
    }

    @Override
    public ClusterInfo examineBrokerClusterInfo() throws InterruptedException, MQBrokerException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException {
        return this.mqClientInstance.getMQClientAPIImpl().getBrokerClusterInfo(this.timeoutMillis);
    }

    @Override
    public TopicRouteData examineTopicRouteInfo(String topic) throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getTopicRouteInfoFromNameServer(topic, this.timeoutMillis);
    }

    public MessageExt viewMessage(String topic, String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        try {
            MessageDecoder.decodeMessageId((String)msgId);
            return this.viewMessage(msgId);
        }
        catch (Exception e) {
            this.log.warn("the msgId maybe created by new client. msgId={}", (Object)msgId, (Object)e);
            return this.mqClientInstance.getMQAdminImpl().queryMessageByUniqKey(topic, msgId);
        }
    }

    @Override
    public ConsumerConnection examineConsumerConnectionInfo(String consumerGroup) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        ConsumerConnection result = new ConsumerConnection();
        String topic = MixAll.getRetryTopic((String)consumerGroup);
        List brokers = this.examineTopicRouteInfo(topic).getBrokerDatas();
        BrokerData brokerData = (BrokerData)brokers.get(this.random.nextInt(brokers.size()));
        String addr = null;
        if (brokerData != null && StringUtils.isNotBlank((CharSequence)(addr = brokerData.selectBrokerAddr()))) {
            result = this.mqClientInstance.getMQClientAPIImpl().getConsumerConnectionList(addr, consumerGroup, this.timeoutMillis);
        }
        if (result.getConnectionSet().isEmpty()) {
            this.log.warn("the consumer group not online. brokerAddr={}, group={}", (Object)addr, (Object)consumerGroup);
            throw new MQClientException(206, "Not found the consumer group connection");
        }
        return result;
    }

    @Override
    public ConsumerConnection examineConsumerConnectionInfo(String consumerGroup, String brokerAddr) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        ConsumerConnection result = this.mqClientInstance.getMQClientAPIImpl().getConsumerConnectionList(brokerAddr, consumerGroup, this.timeoutMillis);
        if (result.getConnectionSet().isEmpty()) {
            this.log.warn("the consumer group not online. brokerAddr={}, group={}", (Object)brokerAddr, (Object)consumerGroup);
            throw new MQClientException(206, "Not found the consumer group connection");
        }
        return result;
    }

    @Override
    public ProducerConnection examineProducerConnectionInfo(String producerGroup, String topic) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        ProducerConnection result = new ProducerConnection();
        List brokers = this.examineTopicRouteInfo(topic).getBrokerDatas();
        BrokerData brokerData = (BrokerData)brokers.get(this.random.nextInt(brokers.size()));
        String addr = null;
        if (brokerData != null && StringUtils.isNotBlank((CharSequence)(addr = brokerData.selectBrokerAddr()))) {
            result = this.mqClientInstance.getMQClientAPIImpl().getProducerConnectionList(addr, producerGroup, this.timeoutMillis);
        }
        if (result.getConnectionSet().isEmpty()) {
            this.log.warn("the producer group not online. brokerAddr={}, group={}", (Object)addr, (Object)producerGroup);
            throw new MQClientException("Not found the producer group connection", null);
        }
        return result;
    }

    @Override
    public ProducerTableInfo getAllProducerInfo(String brokerAddr) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getAllProducerInfo(brokerAddr, this.timeoutMillis);
    }

    @Override
    public List<String> getNameServerAddressList() {
        return this.mqClientInstance.getMQClientAPIImpl().getNameServerAddressList();
    }

    @Override
    public int wipeWritePermOfBroker(String namesrvAddr, String brokerName) throws RemotingCommandException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQClientAPIImpl().wipeWritePermOfBroker(namesrvAddr, brokerName, this.timeoutMillis);
    }

    @Override
    public int addWritePermOfBroker(String namesrvAddr, String brokerName) throws RemotingCommandException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQClientAPIImpl().addWritePermOfBroker(namesrvAddr, brokerName, this.timeoutMillis);
    }

    @Override
    public void putKVConfig(String namespace, String key, String value) {
    }

    @Override
    public String getKVConfig(String namespace, String key) throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getKVConfigValue(namespace, key, this.timeoutMillis);
    }

    @Override
    public KVTable getKVListByNamespace(String namespace) throws RemotingException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getKVListByNamespace(namespace, this.timeoutMillis);
    }

    @Override
    public void deleteTopicInBroker(Set<String> addrs, String topic) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        for (String addr : addrs) {
            this.mqClientInstance.getMQClientAPIImpl().deleteTopicInBroker(addr, topic, this.timeoutMillis);
        }
    }

    @Override
    public void deleteTopicInNameServer(Set<String> addrs, String topic, String clusterName) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        if (addrs == null) {
            String ns = this.mqClientInstance.getMQClientAPIImpl().fetchNameServerAddr();
            addrs = new HashSet<String>(Arrays.asList(ns.split(";")));
        }
        for (String addr : addrs) {
            this.mqClientInstance.getMQClientAPIImpl().deleteTopicInNameServer(addr, topic, clusterName, this.timeoutMillis);
        }
    }

    @Override
    public void deleteSubscriptionGroup(String addr, String groupName) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().deleteSubscriptionGroup(addr, groupName, false, this.timeoutMillis);
    }

    @Override
    public void deleteSubscriptionGroup(String addr, String groupName, boolean removeOffset) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().deleteSubscriptionGroup(addr, groupName, removeOffset, this.timeoutMillis);
    }

    @Override
    public void createAndUpdateKvConfig(String namespace, String key, String value) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().putKVConfigValue(namespace, key, value, this.timeoutMillis);
    }

    @Override
    public void deleteKvConfig(String namespace, String key) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        this.mqClientInstance.getMQClientAPIImpl().deleteKVConfigValue(namespace, key, this.timeoutMillis);
    }

    @Override
    public List<RollbackStats> resetOffsetByTimestampOld(String consumerGroup, String topic, long timestamp, boolean force) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        ArrayList<RollbackStats> rollbackStatsList = new ArrayList<RollbackStats>();
        HashMap<String, Integer> topicRouteMap = new HashMap<String, Integer>();
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            for (QueueData queueData : topicRouteData.getQueueDatas()) {
                if (!StringUtils.equals((CharSequence)queueData.getBrokerName(), (CharSequence)bd.getBrokerName())) continue;
                topicRouteMap.put(bd.selectBrokerAddr(), queueData.getReadQueueNums());
            }
        }
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            RollbackStats rollbackStats;
            OffsetWrapper offsetWrapper;
            MessageQueue queue;
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            ConsumeStats consumeStats = this.mqClientInstance.getMQClientAPIImpl().getConsumeStats(addr, consumerGroup, this.timeoutMillis);
            boolean hasConsumed = false;
            for (Map.Entry entry : consumeStats.getOffsetTable().entrySet()) {
                queue = (MessageQueue)entry.getKey();
                offsetWrapper = (OffsetWrapper)entry.getValue();
                if (!topic.equals(queue.getTopic())) continue;
                hasConsumed = true;
                rollbackStats = this.resetOffsetConsumeOffset(addr, consumerGroup, queue, offsetWrapper, timestamp, force);
                rollbackStatsList.add(rollbackStats);
            }
            if (hasConsumed) continue;
            HashMap topicStatus = this.mqClientInstance.getMQClientAPIImpl().getTopicStatsInfo(addr, topic, this.timeoutMillis).getOffsetTable();
            for (int i = 0; i < (Integer)topicRouteMap.get(addr); ++i) {
                queue = new MessageQueue(topic, bd.getBrokerName(), i);
                offsetWrapper = new OffsetWrapper();
                offsetWrapper.setBrokerOffset(((TopicOffset)topicStatus.get(queue)).getMaxOffset());
                offsetWrapper.setConsumerOffset(((TopicOffset)topicStatus.get(queue)).getMinOffset());
                rollbackStats = this.resetOffsetConsumeOffset(addr, consumerGroup, queue, offsetWrapper, timestamp, force);
                rollbackStatsList.add(rollbackStats);
            }
        }
        return rollbackStatsList;
    }

    @Override
    public Map<MessageQueue, Long> resetOffsetByTimestamp(String topic, String group, long timestamp, boolean isForce) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        return this.resetOffsetByTimestamp(topic, group, timestamp, isForce, false);
    }

    @Override
    public void resetOffsetNew(String consumerGroup, String topic, long timestamp) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        try {
            this.resetOffsetByTimestamp(topic, consumerGroup, timestamp, true);
        }
        catch (MQClientException e) {
            if (206 == e.getResponseCode()) {
                this.resetOffsetByTimestampOld(consumerGroup, topic, timestamp, true);
                return;
            }
            throw e;
        }
    }

    public Map<MessageQueue, Long> resetOffsetByTimestamp(String topic, String group, long timestamp, boolean isForce, boolean isC) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        List brokerDatas = topicRouteData.getBrokerDatas();
        HashMap<MessageQueue, Long> allOffsetTable = new HashMap<MessageQueue, Long>();
        if (brokerDatas != null) {
            for (BrokerData brokerData : brokerDatas) {
                Map offsetTable;
                String addr = brokerData.selectBrokerAddr();
                if (addr == null || (offsetTable = this.mqClientInstance.getMQClientAPIImpl().invokeBrokerToResetOffset(addr, topic, group, timestamp, isForce, this.timeoutMillis, isC)) == null) continue;
                allOffsetTable.putAll(offsetTable);
            }
        }
        return allOffsetTable;
    }

    private RollbackStats resetOffsetConsumeOffset(String brokerAddr, String consumeGroup, MessageQueue queue, OffsetWrapper offsetWrapper, long timestamp, boolean force) throws RemotingException, InterruptedException, MQBrokerException {
        long resetOffset = timestamp == -1L ? this.mqClientInstance.getMQClientAPIImpl().getMaxOffset(brokerAddr, queue.getTopic(), queue.getQueueId(), this.timeoutMillis) : this.mqClientInstance.getMQClientAPIImpl().searchOffset(brokerAddr, queue.getTopic(), queue.getQueueId(), timestamp, this.timeoutMillis);
        RollbackStats rollbackStats = new RollbackStats();
        rollbackStats.setBrokerName(queue.getBrokerName());
        rollbackStats.setQueueId((long)queue.getQueueId());
        rollbackStats.setBrokerOffset(offsetWrapper.getBrokerOffset());
        rollbackStats.setConsumerOffset(offsetWrapper.getConsumerOffset());
        rollbackStats.setTimestampOffset(resetOffset);
        rollbackStats.setRollbackOffset(offsetWrapper.getConsumerOffset());
        if (force || resetOffset <= offsetWrapper.getConsumerOffset()) {
            rollbackStats.setRollbackOffset(resetOffset);
            UpdateConsumerOffsetRequestHeader requestHeader = new UpdateConsumerOffsetRequestHeader();
            requestHeader.setConsumerGroup(consumeGroup);
            requestHeader.setTopic(queue.getTopic());
            requestHeader.setQueueId(Integer.valueOf(queue.getQueueId()));
            requestHeader.setCommitOffset(Long.valueOf(resetOffset));
            this.mqClientInstance.getMQClientAPIImpl().updateConsumerOffset(brokerAddr, requestHeader, this.timeoutMillis);
        }
        return rollbackStats;
    }

    @Override
    public Map<String, Map<MessageQueue, Long>> getConsumeStatus(String topic, String group, String clientAddr) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        String addr;
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        List brokerDatas = topicRouteData.getBrokerDatas();
        if (brokerDatas != null && brokerDatas.size() > 0 && (addr = ((BrokerData)brokerDatas.get(0)).selectBrokerAddr()) != null) {
            return this.mqClientInstance.getMQClientAPIImpl().invokeBrokerToGetConsumerStatus(addr, topic, group, clientAddr, this.timeoutMillis);
        }
        return Collections.EMPTY_MAP;
    }

    @Override
    public void createOrUpdateOrderConf(String key, String value, boolean isCluster) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        if (isCluster) {
            this.mqClientInstance.getMQClientAPIImpl().putKVConfigValue("ORDER_TOPIC_CONFIG", key, value, this.timeoutMillis);
        } else {
            String oldOrderConfs = null;
            try {
                oldOrderConfs = this.mqClientInstance.getMQClientAPIImpl().getKVConfigValue("ORDER_TOPIC_CONFIG", key, this.timeoutMillis);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            HashMap<String, String> orderConfMap = new HashMap<String, String>();
            if (!UtilAll.isBlank((String)oldOrderConfs)) {
                String[] oldOrderConfArr;
                for (String oldOrderConf : oldOrderConfArr = oldOrderConfs.split(";")) {
                    String[] items = oldOrderConf.split(":");
                    orderConfMap.put(items[0], oldOrderConf);
                }
            }
            String[] items = value.split(":");
            orderConfMap.put(items[0], value);
            StringBuilder newOrderConf = new StringBuilder();
            String splitor = "";
            for (Map.Entry entry : orderConfMap.entrySet()) {
                newOrderConf.append(splitor).append((String)entry.getValue());
                splitor = ";";
            }
            this.mqClientInstance.getMQClientAPIImpl().putKVConfigValue("ORDER_TOPIC_CONFIG", key, newOrderConf.toString(), this.timeoutMillis);
        }
    }

    @Override
    public GroupList queryTopicConsumeByWho(String topic) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        BrokerData bd;
        String addr;
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        Iterator iterator = topicRouteData.getBrokerDatas().iterator();
        if (iterator.hasNext() && (addr = (bd = (BrokerData)iterator.next()).selectBrokerAddr()) != null) {
            return this.mqClientInstance.getMQClientAPIImpl().queryTopicConsumeByWho(addr, topic, this.timeoutMillis);
        }
        return null;
    }

    @Override
    public List<QueueTimeSpan> queryConsumeTimeSpan(String topic, String group) throws InterruptedException, MQBrokerException, RemotingException, MQClientException {
        ArrayList<QueueTimeSpan> spanSet = new ArrayList<QueueTimeSpan>();
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            spanSet.addAll(this.mqClientInstance.getMQClientAPIImpl().queryConsumeTimeSpan(addr, topic, group, this.timeoutMillis));
        }
        return spanSet;
    }

    @Override
    public boolean cleanExpiredConsumerQueue(String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = false;
        try {
            ClusterInfo clusterInfo = this.examineBrokerClusterInfo();
            if (null == cluster || "".equals(cluster)) {
                for (String targetCluster : clusterInfo.retrieveAllClusterNames()) {
                    result = this.cleanExpiredConsumerQueueByCluster(clusterInfo, targetCluster);
                }
            } else {
                result = this.cleanExpiredConsumerQueueByCluster(clusterInfo, cluster);
            }
        }
        catch (MQBrokerException e) {
            this.log.error("cleanExpiredConsumerQueue error.", (Throwable)e);
        }
        return result;
    }

    public boolean cleanExpiredConsumerQueueByCluster(ClusterInfo clusterInfo, String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        String[] addrs;
        boolean result = false;
        for (String addr : addrs = clusterInfo.retrieveAllAddrByCluster(cluster)) {
            result = this.cleanExpiredConsumerQueueByAddr(addr);
        }
        return result;
    }

    @Override
    public boolean cleanExpiredConsumerQueueByAddr(String addr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = this.mqClientInstance.getMQClientAPIImpl().cleanExpiredConsumeQueue(addr, this.timeoutMillis);
        this.log.warn("clean expired ConsumeQueue on target " + addr + " broker " + result);
        return result;
    }

    @Override
    public boolean deleteExpiredCommitLog(String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = false;
        try {
            ClusterInfo clusterInfo = this.examineBrokerClusterInfo();
            if (null == cluster || "".equals(cluster)) {
                for (String targetCluster : clusterInfo.retrieveAllClusterNames()) {
                    result = this.deleteExpiredCommitLogByCluster(clusterInfo, targetCluster);
                }
            } else {
                result = this.deleteExpiredCommitLogByCluster(clusterInfo, cluster);
            }
        }
        catch (MQBrokerException e) {
            this.log.error("deleteExpiredCommitLog error.", (Throwable)e);
        }
        return result;
    }

    public boolean deleteExpiredCommitLogByCluster(ClusterInfo clusterInfo, String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        String[] addrs;
        boolean result = false;
        for (String addr : addrs = clusterInfo.retrieveAllAddrByCluster(cluster)) {
            result = this.deleteExpiredCommitLogByAddr(addr);
        }
        return result;
    }

    @Override
    public boolean deleteExpiredCommitLogByAddr(String addr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = this.mqClientInstance.getMQClientAPIImpl().deleteExpiredCommitLog(addr, this.timeoutMillis);
        this.log.warn("Delete expired CommitLog on target " + addr + " broker " + result);
        return result;
    }

    @Override
    public boolean cleanUnusedTopic(String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = false;
        try {
            ClusterInfo clusterInfo = this.examineBrokerClusterInfo();
            if (null == cluster || "".equals(cluster)) {
                for (String targetCluster : clusterInfo.retrieveAllClusterNames()) {
                    result = this.cleanUnusedTopicByCluster(clusterInfo, targetCluster);
                }
            } else {
                result = this.cleanUnusedTopicByCluster(clusterInfo, cluster);
            }
        }
        catch (MQBrokerException e) {
            this.log.error("cleanExpiredConsumerQueue error.", (Throwable)e);
        }
        return result;
    }

    public boolean cleanUnusedTopicByCluster(ClusterInfo clusterInfo, String cluster) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        String[] addrs;
        boolean result = false;
        for (String addr : addrs = clusterInfo.retrieveAllAddrByCluster(cluster)) {
            result = this.cleanUnusedTopicByAddr(addr);
        }
        return result;
    }

    @Override
    public boolean cleanUnusedTopicByAddr(String addr) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        boolean result = this.mqClientInstance.getMQClientAPIImpl().cleanUnusedTopicByAddr(addr, this.timeoutMillis);
        this.log.warn("clean expired ConsumeQueue on target " + addr + " broker " + result);
        return result;
    }

    @Override
    public ConsumerRunningInfo getConsumerRunningInfo(String consumerGroup, String clientId, boolean jstack) throws RemotingException, MQClientException, InterruptedException {
        String topic = "%RETRY%" + consumerGroup;
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        List brokerDatas = topicRouteData.getBrokerDatas();
        if (brokerDatas != null) {
            for (BrokerData brokerData : brokerDatas) {
                String addr = brokerData.selectBrokerAddr();
                if (addr == null) continue;
                return this.mqClientInstance.getMQClientAPIImpl().getConsumerRunningInfo(addr, consumerGroup, clientId, jstack, this.timeoutMillis * 3L);
            }
        }
        return null;
    }

    @Override
    public ConsumeMessageDirectlyResult consumeMessageDirectly(String consumerGroup, String clientId, String msgId) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        MessageExt msg = this.viewMessage(msgId);
        return this.mqClientInstance.getMQClientAPIImpl().consumeMessageDirectly(RemotingUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), consumerGroup, clientId, msgId, this.timeoutMillis * 3L);
    }

    @Override
    public ConsumeMessageDirectlyResult consumeMessageDirectly(String consumerGroup, String clientId, String topic, String msgId) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        MessageExt msg = this.viewMessage(topic, msgId);
        if (msg.getProperty("UNIQ_KEY") == null) {
            return this.mqClientInstance.getMQClientAPIImpl().consumeMessageDirectly(RemotingUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), consumerGroup, clientId, msgId, this.timeoutMillis * 3L);
        }
        MessageClientExt msgClient = (MessageClientExt)msg;
        return this.mqClientInstance.getMQClientAPIImpl().consumeMessageDirectly(RemotingUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), consumerGroup, clientId, msgClient.getOffsetMsgId(), this.timeoutMillis * 3L);
    }

    @Override
    public List<MessageTrack> messageTrackDetail(MessageExt msg) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        ArrayList<MessageTrack> result = new ArrayList<MessageTrack>();
        GroupList groupList = this.queryTopicConsumeByWho(msg.getTopic());
        block11: for (String group : groupList.getGroupList()) {
            MessageTrack mt = new MessageTrack();
            mt.setConsumerGroup(group);
            mt.setTrackType(TrackType.UNKNOWN);
            ConsumerConnection cc = null;
            try {
                cc = this.examineConsumerConnectionInfo(group);
            }
            catch (MQBrokerException e) {
                if (206 == e.getResponseCode()) {
                    mt.setTrackType(TrackType.NOT_ONLINE);
                }
                mt.setExceptionDesc("CODE:" + e.getResponseCode() + " DESC:" + e.getErrorMessage());
                result.add(mt);
                continue;
            }
            catch (Exception e) {
                mt.setExceptionDesc(RemotingHelper.exceptionSimpleDesc((Throwable)e));
                result.add(mt);
                continue;
            }
            switch (cc.getConsumeType()) {
                case CONSUME_ACTIVELY: {
                    mt.setTrackType(TrackType.PULL);
                    break;
                }
                case CONSUME_PASSIVELY: {
                    boolean ifConsumed = false;
                    try {
                        ifConsumed = this.consumed(msg, group);
                    }
                    catch (MQClientException e) {
                        if (206 == e.getResponseCode()) {
                            mt.setTrackType(TrackType.NOT_ONLINE);
                        }
                        mt.setExceptionDesc("CODE:" + e.getResponseCode() + " DESC:" + e.getErrorMessage());
                        result.add(mt);
                        continue block11;
                    }
                    catch (MQBrokerException e) {
                        if (206 == e.getResponseCode()) {
                            mt.setTrackType(TrackType.NOT_ONLINE);
                        }
                        mt.setExceptionDesc("CODE:" + e.getResponseCode() + " DESC:" + e.getErrorMessage());
                        result.add(mt);
                        continue block11;
                    }
                    catch (Exception e) {
                        mt.setExceptionDesc(RemotingHelper.exceptionSimpleDesc((Throwable)e));
                        result.add(mt);
                        continue block11;
                    }
                    if (ifConsumed) {
                        mt.setTrackType(TrackType.CONSUMED);
                        for (Map.Entry next : cc.getSubscriptionTable().entrySet()) {
                            if (!((String)next.getKey()).equals(msg.getTopic()) || ((SubscriptionData)next.getValue()).getTagsSet().contains(msg.getTags()) || ((SubscriptionData)next.getValue()).getTagsSet().contains("*") || ((SubscriptionData)next.getValue()).getTagsSet().isEmpty()) continue;
                            mt.setTrackType(TrackType.CONSUMED_BUT_FILTERED);
                        }
                        break;
                    }
                    mt.setTrackType(TrackType.NOT_CONSUME_YET);
                    break;
                }
            }
            result.add(mt);
        }
        return result;
    }

    public boolean consumed(MessageExt msg, String group) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        ConsumeStats cstats = this.examineConsumeStats(group);
        ClusterInfo ci = this.examineBrokerClusterInfo();
        for (Map.Entry next : cstats.getOffsetTable().entrySet()) {
            BrokerData brokerData;
            MessageQueue mq = (MessageQueue)next.getKey();
            if (!mq.getTopic().equals(msg.getTopic()) || mq.getQueueId() != msg.getQueueId() || (brokerData = (BrokerData)ci.getBrokerAddrTable().get(mq.getBrokerName())) == null) continue;
            String addr = RemotingUtil.convert2IpString((String)((String)brokerData.getBrokerAddrs().get(0L)));
            if (!RemotingUtil.socketAddress2String((SocketAddress)msg.getStoreHost()).equals(addr) || ((OffsetWrapper)next.getValue()).getConsumerOffset() <= msg.getQueueOffset()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void cloneGroupOffset(String srcGroup, String destGroup, String topic, boolean isOffline) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        String retryTopic = MixAll.getRetryTopic((String)srcGroup);
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(retryTopic);
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String addr = bd.selectBrokerAddr();
            if (addr == null) continue;
            this.mqClientInstance.getMQClientAPIImpl().cloneGroupOffset(addr, srcGroup, destGroup, topic, isOffline, this.timeoutMillis * 3L);
        }
    }

    @Override
    public BrokerStatsData viewBrokerStatsData(String brokerAddr, String statsName, String statsKey) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().viewBrokerStatsData(brokerAddr, statsName, statsKey, this.timeoutMillis);
    }

    @Override
    public Set<String> getClusterList(String topic) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().getClusterList(topic, this.timeoutMillis);
    }

    @Override
    public ConsumeStatsList fetchConsumeStatsInBroker(String brokerAddr, boolean isOrder, long timeoutMillis) throws RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, InterruptedException {
        return this.mqClientInstance.getMQClientAPIImpl().fetchConsumeStatsInBroker(brokerAddr, isOrder, timeoutMillis);
    }

    @Override
    public Set<String> getTopicClusterList(String topic) throws InterruptedException, MQBrokerException, MQClientException, RemotingException {
        HashSet<String> clusterSet = new HashSet<String>();
        ClusterInfo clusterInfo = this.examineBrokerClusterInfo();
        TopicRouteData topicRouteData = this.examineTopicRouteInfo(topic);
        BrokerData brokerData = (BrokerData)topicRouteData.getBrokerDatas().get(0);
        String brokerName = brokerData.getBrokerName();
        for (Map.Entry next : clusterInfo.getClusterAddrTable().entrySet()) {
            if (!((Set)next.getValue()).contains(brokerName)) continue;
            clusterSet.add((String)next.getKey());
        }
        return clusterSet;
    }

    @Override
    public SubscriptionGroupWrapper getAllSubscriptionGroup(String brokerAddr, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getAllSubscriptionGroup(brokerAddr, timeoutMillis);
    }

    @Override
    public SubscriptionGroupWrapper getUserSubscriptionGroup(String brokerAddr, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        SubscriptionGroupWrapper subscriptionGroupWrapper = this.mqClientInstance.getMQClientAPIImpl().getAllSubscriptionGroup(brokerAddr, timeoutMillis);
        Iterator iterator = subscriptionGroupWrapper.getSubscriptionGroupTable().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry configEntry = iterator.next();
            if (!MixAll.isSysConsumerGroup((String)((String)configEntry.getKey())) && !SYSTEM_GROUP_SET.contains(configEntry.getKey())) continue;
            iterator.remove();
        }
        return subscriptionGroupWrapper;
    }

    @Override
    public TopicConfigSerializeWrapper getAllTopicConfig(String brokerAddr, long timeoutMillis) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQBrokerException {
        return this.mqClientInstance.getMQClientAPIImpl().getAllTopicConfig(brokerAddr, timeoutMillis);
    }

    @Override
    public TopicConfigSerializeWrapper getUserTopicConfig(String brokerAddr, boolean specialTopic, long timeoutMillis) throws InterruptedException, RemotingException, MQBrokerException, MQClientException {
        TopicConfigSerializeWrapper topicConfigSerializeWrapper = this.getAllTopicConfig(brokerAddr, timeoutMillis);
        TopicList topicList = this.mqClientInstance.getMQClientAPIImpl().getSystemTopicListFromBroker(brokerAddr, timeoutMillis);
        Iterator iterator = topicConfigSerializeWrapper.getTopicConfigTable().entrySet().iterator();
        while (iterator.hasNext()) {
            String topic = (String)iterator.next().getKey();
            if (!topicList.getTopicList().contains(topic) && (specialTopic || !topic.startsWith("%RETRY%") && !topic.startsWith("%DLQ%"))) continue;
            iterator.remove();
        }
        return topicConfigSerializeWrapper;
    }

    public void createTopic(String key, String newTopic, int queueNum) throws MQClientException {
        this.createTopic(key, newTopic, queueNum, 0);
    }

    public void createTopic(String key, String newTopic, int queueNum, int topicSysFlag) throws MQClientException {
        this.mqClientInstance.getMQAdminImpl().createTopic(key, newTopic, queueNum, topicSysFlag);
    }

    public long searchOffset(MessageQueue mq, long timestamp) throws MQClientException {
        return this.mqClientInstance.getMQAdminImpl().searchOffset(mq, timestamp);
    }

    public long maxOffset(MessageQueue mq) throws MQClientException {
        return this.mqClientInstance.getMQAdminImpl().maxOffset(mq);
    }

    public long minOffset(MessageQueue mq) throws MQClientException {
        return this.mqClientInstance.getMQAdminImpl().minOffset(mq);
    }

    public long earliestMsgStoreTime(MessageQueue mq) throws MQClientException {
        return this.mqClientInstance.getMQAdminImpl().earliestMsgStoreTime(mq);
    }

    public MessageExt viewMessage(String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        return this.mqClientInstance.getMQAdminImpl().viewMessage(msgId);
    }

    public QueryResult queryMessage(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        return this.mqClientInstance.getMQAdminImpl().queryMessage(topic, key, maxNum, begin, end);
    }

    public QueryResult queryMessageByUniqKey(String topic, String key, int maxNum, long begin, long end) throws MQClientException, InterruptedException {
        return this.mqClientInstance.getMQAdminImpl().queryMessageByUniqKey(topic, key, maxNum, begin, end);
    }

    @Override
    public void updateConsumeOffset(String brokerAddr, String consumeGroup, MessageQueue mq, long offset) throws RemotingException, InterruptedException, MQBrokerException {
        UpdateConsumerOffsetRequestHeader requestHeader = new UpdateConsumerOffsetRequestHeader();
        requestHeader.setConsumerGroup(consumeGroup);
        requestHeader.setTopic(mq.getTopic());
        requestHeader.setQueueId(Integer.valueOf(mq.getQueueId()));
        requestHeader.setCommitOffset(Long.valueOf(offset));
        this.mqClientInstance.getMQClientAPIImpl().updateConsumerOffset(brokerAddr, requestHeader, this.timeoutMillis);
    }

    @Override
    public void updateNameServerConfig(Properties properties, List<String> nameServers) throws InterruptedException, RemotingConnectException, UnsupportedEncodingException, RemotingSendRequestException, RemotingTimeoutException, MQClientException, MQBrokerException {
        this.mqClientInstance.getMQClientAPIImpl().updateNameServerConfig(properties, nameServers, this.timeoutMillis);
    }

    @Override
    public Map<String, Properties> getNameServerConfig(List<String> nameServers) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQClientException, UnsupportedEncodingException {
        return this.mqClientInstance.getMQClientAPIImpl().getNameServerConfig(nameServers, this.timeoutMillis);
    }

    @Override
    public QueryConsumeQueueResponseBody queryConsumeQueue(String brokerAddr, String topic, int queueId, long index, int count, String consumerGroup) throws InterruptedException, RemotingTimeoutException, RemotingSendRequestException, RemotingConnectException, MQClientException {
        return this.mqClientInstance.getMQClientAPIImpl().queryConsumeQueue(brokerAddr, topic, queueId, index, count, consumerGroup, this.timeoutMillis);
    }

    @Override
    public boolean resumeCheckHalfMessage(String msgId) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        MessageExt msg = this.viewMessage(msgId);
        return this.mqClientInstance.getMQClientAPIImpl().resumeCheckHalfMessage(RemotingUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), msgId, this.timeoutMillis);
    }

    @Override
    public boolean resumeCheckHalfMessage(String topic, String msgId) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        MessageExt msg = this.viewMessage(topic, msgId);
        if (msg.getProperty("UNIQ_KEY") == null) {
            return this.mqClientInstance.getMQClientAPIImpl().resumeCheckHalfMessage(RemotingUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), msgId, this.timeoutMillis);
        }
        MessageClientExt msgClient = (MessageClientExt)msg;
        return this.mqClientInstance.getMQClientAPIImpl().resumeCheckHalfMessage(RemotingUtil.socketAddress2String((SocketAddress)msg.getStoreHost()), msgClient.getOffsetMsgId(), this.timeoutMillis);
    }

    static {
        SYSTEM_GROUP_SET.add("DEFAULT_CONSUMER");
        SYSTEM_GROUP_SET.add("DEFAULT_PRODUCER");
        SYSTEM_GROUP_SET.add("TOOLS_CONSUMER");
        SYSTEM_GROUP_SET.add("FILTERSRV_CONSUMER");
        SYSTEM_GROUP_SET.add("__MONITOR_CONSUMER");
        SYSTEM_GROUP_SET.add("CLIENT_INNER_PRODUCER");
        SYSTEM_GROUP_SET.add("SELF_TEST_P_GROUP");
        SYSTEM_GROUP_SET.add("SELF_TEST_C_GROUP");
        SYSTEM_GROUP_SET.add("CID_ONS-HTTP-PROXY");
        SYSTEM_GROUP_SET.add("CID_ONSAPI_PERMISSION");
        SYSTEM_GROUP_SET.add("CID_ONSAPI_OWNER");
        SYSTEM_GROUP_SET.add("CID_ONSAPI_PULL");
        SYSTEM_GROUP_SET.add("CID_RMQ_SYS_TRANS");
    }
}

