/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.IObsCredentialsProvider;
import com.obs.services.internal.security.EcsSecurityUtils;
import com.obs.services.internal.security.LimitedTimeSecurityKey;
import com.obs.services.internal.security.SecurityKey;
import com.obs.services.internal.security.SecurityKeyBean;
import com.obs.services.internal.utils.JSONChange;
import com.obs.services.model.ISecurityKey;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public class EcsObsCredentialsProvider
implements IObsCredentialsProvider {
    private volatile LimitedTimeSecurityKey securityKey;
    private AtomicBoolean getNewKeyFlag = new AtomicBoolean(false);
    private static final ILogger ILOG = LoggerBuilder.getLogger(EcsObsCredentialsProvider.class);
    private int maxRetryTimes = -1;

    public EcsObsCredentialsProvider() {
        this.maxRetryTimes = 3;
    }

    public EcsObsCredentialsProvider(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public void setSecurityKey(ISecurityKey securityKey) {
        throw new UnsupportedOperationException("EcsObsCredentialsProvider class does not support this method");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ISecurityKey getSecurityKey() {
        if (this.getNewKeyFlag.compareAndSet(false, true)) {
            try {
                if (this.securityKey == null || this.securityKey.willSoonExpire()) {
                    this.refresh(false);
                    return this.securityKey;
                }
                if (!this.securityKey.aboutToExpire()) return this.securityKey;
                this.refresh(true);
                return this.securityKey;
            }
            finally {
                this.getNewKeyFlag.set(false);
            }
        } else {
            if (!ILOG.isDebugEnabled()) return this.securityKey;
            ILOG.debug("some other thread is refreshing.");
        }
        return this.securityKey;
    }

    private void refresh(boolean ignoreException) {
        int times = 0;
        do {
            try {
                this.securityKey = this.getNewSecurityKey();
            }
            catch (IOException | RuntimeException e) {
                ILOG.warn("refresh new security key failed. times : " + times + "; maxRetryTimes is : " + this.maxRetryTimes + "; ignoreException : " + ignoreException, e);
                if (times < this.maxRetryTimes) continue;
                ILOG.error("refresh new security key failed.", e);
                if (ignoreException) continue;
                throw new IllegalArgumentException(e);
            }
        } while (times++ < this.maxRetryTimes && this.maxRetryTimes > 0);
    }

    private LimitedTimeSecurityKey getNewSecurityKey() throws IOException, IllegalArgumentException {
        String content = EcsSecurityUtils.getSecurityKeyInfoWithDetail();
        SecurityKey securityInfo = (SecurityKey)JSONChange.jsonToObj(new SecurityKey(), content);
        if (securityInfo == null) {
            throw new IllegalArgumentException("Invalid securityKey : " + content);
        }
        Date expiryDate = null;
        SecurityKeyBean bean = securityInfo.getBean();
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            String strDate = bean.getExpiresDate();
            expiryDate = df.parse(strDate.substring(0, strDate.length() - 4));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Date parse failed :" + e.getMessage());
        }
        StringBuilder strAccess = new StringBuilder();
        String accessKey = bean.getAccessKey();
        int length = accessKey.length();
        strAccess.append(accessKey.substring(0, length / 3));
        strAccess.append("******");
        strAccess.append(accessKey.substring(2 * length / 3, length - 1));
        ILOG.warn("the AccessKey : " + strAccess.toString() + "will expiry at UTC time : " + expiryDate);
        return new LimitedTimeSecurityKey(bean.getAccessKey(), bean.getSecretKey(), bean.getSecurityToken(), expiryDate);
    }
}

