/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public interface FileIO
extends Serializable,
Closeable {
    public InputFile newInputFile(String var1);

    default public InputFile newInputFile(String path, long length) {
        return this.newInputFile(path);
    }

    default public InputFile newInputFile(DataFile file) {
        Preconditions.checkArgument((file.keyMetadata() == null ? 1 : 0) != 0, (String)"Cannot decrypt data file: %s (use EncryptingFileIO)", (Object)file.path());
        return this.newInputFile(file.path().toString(), file.fileSizeInBytes());
    }

    default public InputFile newInputFile(DeleteFile file) {
        Preconditions.checkArgument((file.keyMetadata() == null ? 1 : 0) != 0, (String)"Cannot decrypt delete file: %s (use EncryptingFileIO)", (Object)file.path());
        return this.newInputFile(file.path().toString(), file.fileSizeInBytes());
    }

    default public InputFile newInputFile(ManifestFile manifest) {
        Preconditions.checkArgument((manifest.keyMetadata() == null ? 1 : 0) != 0, (String)"Cannot decrypt manifest: %s (use EncryptingFileIO)", (Object)manifest.path());
        return this.newInputFile(manifest.path(), manifest.length());
    }

    public OutputFile newOutputFile(String var1);

    public void deleteFile(String var1);

    default public void deleteFile(InputFile file) {
        this.deleteFile(file.location());
    }

    default public void deleteFile(OutputFile file) {
        this.deleteFile(file.location());
    }

    default public Map<String, String> properties() {
        throw new UnsupportedOperationException(String.format("%s does not expose configuration properties", this.getClass().toString()));
    }

    default public void initialize(Map<String, String> properties) {
    }

    @Override
    default public void close() {
    }
}

