/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper.provider.base;

import org.apache.gravitino.storage.relational.po.UserPO;
import org.apache.ibatis.annotations.Param;

public class UserMetaBaseSQLProvider {
    public String selectUserIdByMetalakeIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="userName") String name) {
        return "SELECT user_id as userId FROM user_meta WHERE metalake_id = #{metalakeId} AND user_name = #{userName} AND deleted_at = 0";
    }

    public String selectUserMetaByMetalakeIdAndName(@Param(value="metalakeId") Long metalakeId, @Param(value="userName") String name) {
        return "SELECT user_id as userId, user_name as userName, metalake_id as metalakeId, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM user_meta WHERE metalake_id = #{metalakeId} AND user_name = #{userName} AND deleted_at = 0";
    }

    public String insertUserMeta(@Param(value="userMeta") UserPO userPO) {
        return "INSERT INTO user_meta(user_id, user_name, metalake_id, audit_info, current_version, last_version, deleted_at) VALUES( #{userMeta.userId}, #{userMeta.userName}, #{userMeta.metalakeId}, #{userMeta.auditInfo}, #{userMeta.currentVersion}, #{userMeta.lastVersion}, #{userMeta.deletedAt} )";
    }

    public String insertUserMetaOnDuplicateKeyUpdate(@Param(value="userMeta") UserPO userPO) {
        return "INSERT INTO user_meta(user_id, user_name,metalake_id, audit_info, current_version, last_version, deleted_at) VALUES( #{userMeta.userId}, #{userMeta.userName}, #{userMeta.metalakeId}, #{userMeta.auditInfo}, #{userMeta.currentVersion}, #{userMeta.lastVersion}, #{userMeta.deletedAt} ) ON DUPLICATE KEY UPDATE user_name = #{userMeta.userName}, metalake_id = #{userMeta.metalakeId}, audit_info = #{userMeta.auditInfo}, current_version = #{userMeta.currentVersion}, last_version = #{userMeta.lastVersion}, deleted_at = #{userMeta.deletedAt}";
    }

    public String softDeleteUserMetaByUserId(@Param(value="userId") Long userId) {
        return "UPDATE user_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE user_id = #{userId} AND deleted_at = 0";
    }

    public String softDeleteUserMetasByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "UPDATE user_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0";
    }

    public String updateUserMeta(@Param(value="newUserMeta") UserPO newUserPO, @Param(value="oldUserMeta") UserPO oldUserPO) {
        return "UPDATE user_meta SET user_name = #{newUserMeta.userName}, metalake_id = #{newUserMeta.metalakeId}, audit_info = #{newUserMeta.auditInfo}, current_version = #{newUserMeta.currentVersion}, last_version = #{newUserMeta.lastVersion}, deleted_at = #{newUserMeta.deletedAt} WHERE user_id = #{oldUserMeta.userId} AND user_name = #{oldUserMeta.userName} AND metalake_id = #{oldUserMeta.metalakeId} AND audit_info = #{oldUserMeta.auditInfo} AND current_version = #{oldUserMeta.currentVersion} AND last_version = #{oldUserMeta.lastVersion} AND deleted_at = 0";
    }

    public String listUsersByRoleId(@Param(value="roleId") Long roleId) {
        return "SELECT us.user_id as userId, us.user_name as userName, us.metalake_id as metalakeId, us.audit_info as auditInfo, us.current_version as currentVersion, us.last_version as lastVersion, us.deleted_at as deletedAt FROM user_meta us JOIN user_role_rel re ON us.user_id = re.user_id WHERE re.role_id = #{roleId} AND us.deleted_at = 0 AND re.deleted_at = 0";
    }

    public String listUserPOsByMetalake(@Param(value="metalakeName") String metalakeName) {
        return "SELECT ut.user_id as userId, ut.user_name as userName, ut.metalake_id as metalakeId, ut.audit_info as auditInfo, ut.current_version as currentVersion, ut.last_version as lastVersion, ut.deleted_at as deletedAt FROM user_meta ut JOIN metalake_meta mt ON ut.metalake_id = mt.metalake_id WHERE mt.metalake_name = #{metalakeName} AND ut.deleted_at = 0 AND mt.deleted_at = 0";
    }

    public String listExtendedUserPOsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return "SELECT ut.user_id as userId, ut.user_name as userName, ut.metalake_id as metalakeId, ut.audit_info as auditInfo, ut.current_version as currentVersion, ut.last_version as lastVersion, ut.deleted_at as deletedAt, JSON_ARRAYAGG(rot.role_name) as roleNames, JSON_ARRAYAGG(rot.role_id) as roleIds FROM user_meta ut LEFT OUTER JOIN user_role_rel rt ON rt.user_id = ut.user_id LEFT OUTER JOIN role_meta rot ON rot.role_id = rt.role_id WHERE  ut.deleted_at = 0 AND (rot.deleted_at = 0 OR rot.deleted_at is NULL) AND (rt.deleted_at = 0 OR rt.deleted_at is NULL) AND ut.metalake_id = #{metalakeId} GROUP BY ut.user_id";
    }

    public String deleteUserMetasByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return "DELETE FROM user_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}";
    }
}

