/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.storage.relational.JDBCBackend;
import org.apache.gravitino.storage.relational.mapper.provider.base.FilesetVersionBaseSQLProvider;
import org.apache.gravitino.storage.relational.po.FilesetVersionPO;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.annotations.Param;

public class FilesetVersionSQLProviderFactory {
    private static final Map<JDBCBackend.JDBCBackendType, FilesetVersionBaseSQLProvider> METALAKE_META_SQL_PROVIDER_MAP = ImmutableMap.of((Object)((Object)JDBCBackend.JDBCBackendType.MYSQL), (Object)new FilesetVersionMySQLProvider(), (Object)((Object)JDBCBackend.JDBCBackendType.H2), (Object)new FilesetVersionH2Provider());

    public static FilesetVersionBaseSQLProvider getProvider() {
        String databaseId = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().getConfiguration().getDatabaseId();
        JDBCBackend.JDBCBackendType jdbcBackendType = JDBCBackend.JDBCBackendType.fromString(databaseId);
        return METALAKE_META_SQL_PROVIDER_MAP.get((Object)jdbcBackendType);
    }

    public static String insertFilesetVersion(@Param(value="filesetVersion") FilesetVersionPO filesetVersionPO) {
        return FilesetVersionSQLProviderFactory.getProvider().insertFilesetVersion(filesetVersionPO);
    }

    public static String insertFilesetVersionOnDuplicateKeyUpdate(@Param(value="filesetVersion") FilesetVersionPO filesetVersionPO) {
        return FilesetVersionSQLProviderFactory.getProvider().insertFilesetVersionOnDuplicateKeyUpdate(filesetVersionPO);
    }

    public static String softDeleteFilesetVersionsByMetalakeId(@Param(value="metalakeId") Long metalakeId) {
        return FilesetVersionSQLProviderFactory.getProvider().softDeleteFilesetVersionsByMetalakeId(metalakeId);
    }

    public static String softDeleteFilesetVersionsByCatalogId(@Param(value="catalogId") Long catalogId) {
        return FilesetVersionSQLProviderFactory.getProvider().softDeleteFilesetVersionsByCatalogId(catalogId);
    }

    public static String softDeleteFilesetVersionsBySchemaId(@Param(value="schemaId") Long schemaId) {
        return FilesetVersionSQLProviderFactory.getProvider().softDeleteFilesetVersionsBySchemaId(schemaId);
    }

    public static String softDeleteFilesetVersionsByFilesetId(@Param(value="filesetId") Long filesetId) {
        return FilesetVersionSQLProviderFactory.getProvider().softDeleteFilesetVersionsByFilesetId(filesetId);
    }

    public static String deleteFilesetVersionsByLegacyTimeline(@Param(value="legacyTimeline") Long legacyTimeline, @Param(value="limit") int limit) {
        return FilesetVersionSQLProviderFactory.getProvider().deleteFilesetVersionsByLegacyTimeline(legacyTimeline, limit);
    }

    public static String selectFilesetVersionsByRetentionCount(@Param(value="versionRetentionCount") Long versionRetentionCount) {
        return FilesetVersionSQLProviderFactory.getProvider().selectFilesetVersionsByRetentionCount(versionRetentionCount);
    }

    public static String softDeleteFilesetVersionsByRetentionLine(@Param(value="filesetId") Long filesetId, @Param(value="versionRetentionLine") long versionRetentionLine, @Param(value="limit") int limit) {
        return FilesetVersionSQLProviderFactory.getProvider().softDeleteFilesetVersionsByRetentionLine(filesetId, versionRetentionLine, limit);
    }

    static class FilesetVersionH2Provider
    extends FilesetVersionBaseSQLProvider {
        FilesetVersionH2Provider() {
        }
    }

    static class FilesetVersionMySQLProvider
    extends FilesetVersionBaseSQLProvider {
        FilesetVersionMySQLProvider() {
        }
    }
}

