/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.op;

import java.util.List;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.op.UpdateHiveFiles;
import org.apache.amoro.hive.table.UnkeyedHiveTable;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;

public class OverwriteHiveFiles
extends UpdateHiveFiles<OverwriteFiles>
implements OverwriteFiles {
    public OverwriteHiveFiles(Transaction transaction, boolean insideTransaction, UnkeyedHiveTable table, HMSClientPool hmsClient, HMSClientPool transactionClient) {
        super(transaction, insideTransaction, table, transaction.newOverwrite(), hmsClient, transactionClient);
    }

    @Override
    protected OverwriteFiles self() {
        return this;
    }

    public OverwriteFiles overwriteByRowFilter(Expression expr) {
        Preconditions.checkArgument((!this.table.spec().isUnpartitioned() || expr == Expressions.alwaysTrue() ? 1 : 0) != 0, (Object)"Unpartitioned hive table support alwaysTrue expression only");
        ((OverwriteFiles)this.delegate).overwriteByRowFilter(expr);
        this.expr = expr;
        return this;
    }

    public OverwriteFiles addFile(DataFile file) {
        if (!this.isHiveDataFile(file)) {
            ((OverwriteFiles)this.delegate).addFile(file);
        } else {
            this.addFiles.add(file);
        }
        return this;
    }

    public OverwriteFiles deleteFile(DataFile file) {
        ((OverwriteFiles)this.delegate).deleteFile(file);
        if (this.isHiveDataFile(file)) {
            this.deleteFiles.add(file);
        }
        return this;
    }

    public OverwriteFiles validateAddedFilesMatchOverwriteFilter() {
        ((OverwriteFiles)this.delegate).validateAddedFilesMatchOverwriteFilter();
        return this;
    }

    public OverwriteFiles validateFromSnapshot(long snapshotId) {
        ((OverwriteFiles)this.delegate).validateFromSnapshot(snapshotId);
        return this;
    }

    public OverwriteFiles caseSensitive(boolean caseSensitive) {
        ((OverwriteFiles)this.delegate).caseSensitive(caseSensitive);
        return this;
    }

    public OverwriteFiles conflictDetectionFilter(Expression conflictDetectionFilter) {
        ((OverwriteFiles)this.delegate).conflictDetectionFilter(conflictDetectionFilter);
        return this;
    }

    public OverwriteFiles validateNoConflictingData() {
        ((OverwriteFiles)this.delegate).validateNoConflictingData();
        return this;
    }

    public OverwriteFiles validateNoConflictingDeletes() {
        ((OverwriteFiles)this.delegate).validateNoConflictingDeletes();
        return this;
    }

    @Override
    protected void postHiveDataCommitted(List<DataFile> committedDataFile) {
        committedDataFile.forEach(arg_0 -> ((OverwriteFiles)((OverwriteFiles)this.delegate)).addFile(arg_0));
    }
}

